/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rephraserengine.core.preservation;

import java.util.Iterator;
import org.eclipse.rephraserengine.core.util.TwoKeyHashMap;
import org.eclipse.rephraserengine.core.vpg.VPGEdge;

public class PreservationRuleset {
    private TwoKeyHashMap<Integer, VPGEdge.Classification, Rule> preservationRules = new TwoKeyHashMap();

    public void preserveAll(int edgeType) {
        VPGEdge.Classification[] classificationArray = VPGEdge.Classification.values();
        int n = classificationArray.length;
        int n2 = 0;
        while (n2 < n) {
            VPGEdge.Classification c = classificationArray[n2];
            this.addRule(edgeType, c, Rule.PRESERVE_ALL);
            ++n2;
        }
    }

    public void preserveIncoming(int edgeType) {
        this.addRule(edgeType, VPGEdge.Classification.INCOMING, Rule.PRESERVE_ALL);
        this.addRule(edgeType, VPGEdge.Classification.EXTERNAL, Rule.PRESERVE_ALL);
    }

    public void preserveSupersetOutgoing(int edgeType) {
        this.addRule(edgeType, VPGEdge.Classification.OUTGOING, Rule.PRESERVE_SUPERSET);
        this.addRule(edgeType, VPGEdge.Classification.EXTERNAL, Rule.PRESERVE_ALL);
    }

    public void preserveSubsetInternal(int edgeType) {
        this.addRule(edgeType, VPGEdge.Classification.INTERNAL, Rule.PRESERVE_SUBSET);
        this.addRule(edgeType, VPGEdge.Classification.EXTERNAL, Rule.PRESERVE_ALL);
    }

    private void addRule(int edgeType, VPGEdge.Classification classification, Rule rule) {
        this.preservationRules.put((Object)edgeType, (Object)classification, (Object)rule);
    }

    void invokeCallback(int edgeType, VPGEdge.Classification classification, Processor processor) {
        this.getRule(edgeType, classification).processUsing(processor);
    }

    private Rule getRule(int edgeType, VPGEdge.Classification classification) {
        Rule result = (Rule)((Object)this.preservationRules.getEntry((Object)edgeType, (Object)classification));
        if (result != null) {
            return result;
        }
        return Rule.IGNORE;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        Iterator iterator = this.preservationRules.keySet().iterator();
        while (iterator.hasNext()) {
            int type = (Integer)iterator.next();
            sb.append("Type ");
            sb.append(type);
            sb.append(": ");
            VPGEdge.Classification[] classificationArray = VPGEdge.Classification.values();
            int n = classificationArray.length;
            int n2 = 0;
            while (n2 < n) {
                VPGEdge.Classification c = classificationArray[n2];
                sb.append("  ");
                sb.append(c.toString());
                sb.append(" - ");
                sb.append((Object)this.getRule(type, c));
                ++n2;
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    static abstract class Processor {
        Processor() {
        }

        abstract void handlePreserveAll();

        abstract void handlePreserveSubset();

        abstract void handlePreserveSuperset();

        abstract void handleIgnore();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Rule {
        PRESERVE_ALL{

            protected void processUsing(Processor p) {
                p.handlePreserveAll();
            }
        }
        ,
        PRESERVE_SUBSET{

            protected void processUsing(Processor p) {
                p.handlePreserveSubset();
            }
        }
        ,
        PRESERVE_SUPERSET{

            protected void processUsing(Processor p) {
                p.handlePreserveSuperset();
            }
        }
        ,
        IGNORE{

            protected void processUsing(Processor p) {
                p.handleIgnore();
            }
        };


        protected abstract void processUsing(Processor var1);
    }
}

