/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rephraserengine.core.vpg.db.ram;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.nio.channels.FileChannel;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import org.eclipse.rephraserengine.core.util.Pair;
import org.eclipse.rephraserengine.core.util.TwoKeyHashMap;
import org.eclipse.rephraserengine.core.vpg.IVPGComponentFactory;
import org.eclipse.rephraserengine.core.vpg.IVPGNode;
import org.eclipse.rephraserengine.core.vpg.VPGDB;
import org.eclipse.rephraserengine.core.vpg.VPGDependency;
import org.eclipse.rephraserengine.core.vpg.VPGEdge;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RAMDB<A, T, R extends IVPGNode<T>>
extends VPGDB<A, T, R> {
    protected final File file;
    protected HashMap<String, Long> files;
    protected HashSet<VPGDependency<A, T, R>> dependencies;
    protected HashMap<R, Set<VPGEdge<A, T, R>>> outgoingEdges;
    protected HashMap<R, Set<VPGEdge<A, T, R>>> incomingEdges;
    protected TwoKeyHashMap<R, Integer, Serializable> annotations;
    private File originalContents = null;

    public RAMDB(IVPGComponentFactory<A, T, R> locator, File file) {
        super(locator);
        this.file = file;
        if (file.exists() && file.canRead()) {
            this.readFrom(file);
        } else {
            this.createEmptyDatabase();
        }
    }

    protected void createEmptyDatabase() {
        this.files = new HashMap();
        this.dependencies = new HashSet();
        this.outgoingEdges = new HashMap();
        this.incomingEdges = new HashMap();
        this.annotations = new TwoKeyHashMap();
    }

    protected void readFrom(File file) {
        try {
            ObjectInputStream in = new ObjectInputStream(new InflaterInputStream(new BufferedInputStream(new FileInputStream(file))));
            this.files = (HashMap)this.readObject(in);
            this.dependencies = (HashSet)this.readObject(in);
            this.outgoingEdges = (HashMap)this.readObject(in);
            this.incomingEdges = (HashMap)this.readObject(in);
            this.annotations = (TwoKeyHashMap)this.readObject(in);
            in.close();
        }
        catch (EOFException eOFException) {
            this.createEmptyDatabase();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.createEmptyDatabase();
        }
    }

    protected abstract Object readObject(ObjectInputStream var1) throws IOException, ClassNotFoundException;

    protected void writeTo(File file) {
        try {
            ObjectOutputStream out = new ObjectOutputStream(new DeflaterOutputStream(new BufferedOutputStream(new FileOutputStream(file))));
            out.writeObject(this.files);
            out.writeObject(this.dependencies);
            out.writeObject(this.outgoingEdges);
            out.writeObject(this.incomingEdges);
            out.writeObject(this.annotations);
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            file.delete();
        }
    }

    @Override
    public void flush() {
        this.writeTo(this.file);
    }

    @Override
    public void close() {
        this.flush();
        this.files = null;
        this.dependencies = null;
        this.outgoingEdges = null;
        this.incomingEdges = null;
        this.annotations = null;
    }

    @Override
    public void clearDatabase() {
        this.files.clear();
        this.dependencies.clear();
        this.outgoingEdges.clear();
        this.incomingEdges.clear();
        this.annotations.clear();
    }

    @Override
    public void enterHypotheticalMode() throws IOException {
        if (this.isInHypotheticalMode()) {
            return;
        }
        this.flush();
        this.originalContents = RAMDB.copyFile(this.file);
        this.clearDatabase();
        this.readFrom(this.file);
    }

    private static File copyFile(File orig) throws IOException {
        File tempFile = File.createTempFile("rephraser-tmp", "db");
        tempFile.deleteOnExit();
        FileChannel from = new FileInputStream(orig).getChannel();
        FileChannel to = new FileOutputStream(tempFile).getChannel();
        to.transferFrom(from, 0L, from.size());
        from.close();
        to.close();
        return tempFile;
    }

    @Override
    public void leaveHypotheticalMode() throws IOException {
        if (!this.isInHypotheticalMode()) {
            return;
        }
        this.clearDatabase();
        this.readFrom(this.originalContents);
        this.originalContents.delete();
        this.originalContents = null;
    }

    @Override
    public boolean isInHypotheticalMode() {
        return this.originalContents != null;
    }

    @Override
    public void updateModificationStamp(String filename) {
        this.files.put(filename, this.getModificationStamp(filename));
    }

    public abstract long getModificationStamp(String var1);

    @Override
    public boolean isOutOfDate(String filename) {
        this.checkIfFileInDatabase(filename);
        long storedModificationStamp = this.files.get(filename);
        return storedModificationStamp < this.getModificationStamp(filename);
    }

    @Override
    public void deleteAllEntriesFor(String filename) {
        this.deleteAllIncomingDependenciesFor(filename);
        this.deleteAllOutgoingDependenciesFor(filename);
        this.deleteAllEdgesAndAnnotationsFor(filename);
    }

    @Override
    public void deleteAllEdgesAndAnnotationsFor(String filename) {
        Iterator<Object> it = this.outgoingEdges.keySet().iterator();
        while (it.hasNext()) {
            if (!((IVPGNode)it.next()).getFilename().equals(filename)) continue;
            it.remove();
        }
        it = this.incomingEdges.keySet().iterator();
        while (it.hasNext()) {
            if (!((IVPGNode)it.next()).getFilename().equals(filename)) continue;
            it.remove();
        }
        it = this.annotations.keySet().iterator();
        while (it.hasNext()) {
            if (!((IVPGNode)it.next()).getFilename().equals(filename)) continue;
            it.remove();
        }
    }

    @Override
    public void deleteAllIncomingDependenciesFor(String filename) {
        Iterator<VPGDependency<A, T, R>> dItr = this.dependencies.iterator();
        while (dItr.hasNext()) {
            if (!dItr.next().getDependsOnFile().equals(filename)) continue;
            dItr.remove();
        }
    }

    @Override
    public void deleteAllOutgoingDependenciesFor(String filename) {
        Iterator<VPGDependency<A, T, R>> dItr = this.dependencies.iterator();
        while (dItr.hasNext()) {
            if (!dItr.next().getDependentFile().equals(filename)) continue;
            dItr.remove();
        }
    }

    public Set<String> listAllFilenames() {
        return this.files.keySet();
    }

    public Set<String> listAllFilenamesWithDependents() {
        HashSet<String> toReturn = new HashSet<String>();
        for (VPGDependency<A, T, R> d : this.dependencies) {
            toReturn.add(d.getDependsOnFile());
        }
        return toReturn;
    }

    public Set<String> listAllDependentFilenames() {
        HashSet<String> toReturn = new HashSet<String>();
        for (VPGDependency<A, T, R> d : this.dependencies) {
            toReturn.add(d.getDependentFile());
        }
        return toReturn;
    }

    @Override
    public void ensure(VPGDependency<A, T, R> dependency) {
        this.checkIfFileInDatabase(dependency.getDependentFile());
        this.checkIfFileInDatabase(dependency.getDependsOnFile());
        this.dependencies.add(dependency);
    }

    @Override
    public void delete(VPGDependency<A, T, R> dependency) {
        this.dependencies.remove(dependency);
    }

    @Override
    public Iterable<String> getOutgoingDependenciesFrom(String filename) {
        this.checkIfFileInDatabase(filename);
        TreeSet<String> toReturn = new TreeSet<String>();
        for (VPGDependency<A, T, R> d : this.dependencies) {
            if (!d.getDependentFile().equals(filename)) continue;
            toReturn.add(d.getDependsOnFile());
        }
        return toReturn;
    }

    @Override
    public Iterable<String> getIncomingDependenciesTo(String filename) {
        this.checkIfFileInDatabase(filename);
        TreeSet<String> toReturn = new TreeSet<String>();
        for (VPGDependency<A, T, R> d : this.dependencies) {
            if (!d.getDependsOnFile().equals(filename)) continue;
            toReturn.add(d.getDependentFile());
        }
        return toReturn;
    }

    @Override
    public void ensure(VPGEdge<A, T, R> edge) {
        this.checkIfFileInDatabase(edge.getSource().getFilename());
        this.checkIfFileInDatabase(edge.getSink().getFilename());
        R source = edge.getSource();
        R sink = edge.getSink();
        Set<VPGEdge<A, T, R>> eSource = this.outgoingEdges.get(source);
        Set<VPGEdge<A, T, R>> eSink = this.incomingEdges.get(sink);
        if (eSource == null) {
            this.outgoingEdges.put(source, new TreeSet());
        }
        this.outgoingEdges.get(source).add(edge);
        if (eSink == null) {
            this.incomingEdges.put(sink, new TreeSet());
        }
        this.incomingEdges.get(sink).add(edge);
    }

    @Override
    public void delete(VPGEdge<A, T, R> edge) {
        Set<VPGEdge<A, T, R>> e2;
        Set<VPGEdge<A, T, R>> e1 = this.outgoingEdges.get(edge.getSource());
        if (e1 != null && e1.contains(edge)) {
            if (e1.size() == 1) {
                this.outgoingEdges.remove(edge.getSource());
            } else {
                this.outgoingEdges.get(edge.getSource()).remove(edge);
            }
        }
        if ((e2 = this.incomingEdges.get(edge.getSink())) != null && e2.contains(edge)) {
            if (e2.size() == 1) {
                this.incomingEdges.remove(edge.getSink());
            } else {
                this.incomingEdges.get(edge.getSink()).remove(edge);
            }
        }
    }

    public Collection<? extends VPGEdge<A, T, R>> getAllEdgesFor(String filename) {
        this.checkIfFileInDatabase(filename);
        TreeSet toReturn = new TreeSet();
        for (IVPGNode r : this.outgoingEdges.keySet()) {
            if (!r.getFilename().equals(filename)) continue;
            toReturn.addAll(this.getOutgoingEdgesFrom(r, Integer.MIN_VALUE));
        }
        for (IVPGNode r : this.incomingEdges.keySet()) {
            if (!r.getFilename().equals(filename)) continue;
            toReturn.addAll(this.getIncomingEdgesTo(r, Integer.MIN_VALUE));
        }
        return toReturn;
    }

    public Collection<? extends VPGEdge<A, T, R>> getOutgoingEdgesFrom(R source, int edgeType) {
        if (this.outgoingEdges.get(source) == null) {
            return Collections.emptySet();
        }
        this.checkIfFileInDatabase(source.getFilename());
        if (edgeType == Integer.MIN_VALUE) {
            return this.outgoingEdges.get(source);
        }
        TreeSet<VPGEdge<A, T, R>> toReturn = new TreeSet<VPGEdge<A, T, R>>();
        for (VPGEdge<A, T, R> e : this.outgoingEdges.get(source)) {
            if (e.getType() != edgeType) continue;
            toReturn.add(e);
        }
        return toReturn;
    }

    public Collection<? extends VPGEdge<A, T, R>> getIncomingEdgesTo(R sink, int edgeType) {
        if (this.incomingEdges.get(sink) == null) {
            return new TreeSet();
        }
        this.checkIfFileInDatabase(sink.getFilename());
        if (edgeType == Integer.MIN_VALUE) {
            return this.incomingEdges.get(sink);
        }
        TreeSet<VPGEdge<A, T, R>> toReturn = new TreeSet<VPGEdge<A, T, R>>();
        for (VPGEdge<A, T, R> e : this.incomingEdges.get(sink)) {
            if (e.getType() != edgeType) continue;
            toReturn.add(e);
        }
        return toReturn;
    }

    @Override
    public void setAnnotation(R token, int annotationID, Serializable annotation) {
        this.checkIfFileInDatabase(token.getFilename());
        this.annotations.put(token, (Object)annotationID, (Object)annotation);
    }

    @Override
    public void deleteAnnotation(R token, int annotationID) {
        this.annotations.remove(token, (Object)annotationID);
    }

    @Override
    public Serializable getAnnotation(R token, int annotationID) {
        this.checkIfFileInDatabase(token.getFilename());
        return (Serializable)this.annotations.getEntry(token, (Object)annotationID);
    }

    @Override
    public Iterable<Pair<R, Integer>> getAllAnnotationsFor(String filename) {
        this.checkIfFileInDatabase(filename);
        HashSet<Pair<R, Integer>> toReturn = new HashSet<Pair<R, Integer>>();
        for (IVPGNode r : this.annotations.keySet()) {
            if (!r.getFilename().equals(filename)) continue;
            for (Integer i : this.annotations.getAllEntriesFor((Object)r).keySet()) {
                toReturn.add(new Pair((Object)r, (Object)i));
            }
        }
        return toReturn;
    }

    @Override
    public void printOn(PrintStream out) {
        out.println("MODIFICATION STAMPS:");
        out.println();
        out.println(this.files.toString());
        out.println();
        out.println();
        out.println("DEPENDENCIES:");
        out.println();
        out.println(this.dependencies.toString());
        out.println();
        out.println();
        out.println("EDGES:");
        out.println();
        out.println(this.outgoingEdges.toString());
        out.println();
        out.println();
        out.println("ANNOTATIONS:");
        out.println();
        out.println(this.annotations.toString());
    }

    @Override
    public void printStatisticsOn(PrintStream out) {
    }

    @Override
    public void resetStatistics() {
    }

    private void checkIfFileInDatabase(String filename) {
        if (!this.files.containsKey(filename)) {
            this.files.put(filename, Long.MIN_VALUE);
        }
    }
}

