/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rephraserengine.core.vpg.refactoring;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.FileStatusContext;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.rephraserengine.core.refactorings.IRefactoring;
import org.eclipse.rephraserengine.core.vpg.IVPGNode;
import org.eclipse.rephraserengine.core.vpg.VPG;
import org.eclipse.rephraserengine.core.vpg.VPGLog;
import org.eclipse.rephraserengine.core.vpg.eclipse.EclipseVPG;
import org.eclipse.rephraserengine.core.vpg.refactoring.Messages;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class VPGRefactoring<A, T, V extends EclipseVPG<A, T, ? extends IVPGNode<T>>>
extends Refactoring
implements IRefactoring {
    protected static final String EOL = System.getProperty("line.separator");
    protected V vpg;
    protected CompositeChange allChanges = null;

    public final RefactoringStatus checkInitialConditions(IProgressMonitor pm) {
        this.vpg = this.getVPG();
        RefactoringStatus status = new RefactoringStatus();
        pm.beginTask(Messages.VPGRefactoring_EnsuringIndexIsUpToDate, -1);
        ((EclipseVPG)this.vpg).ensureVPGIsUpToDate(pm);
        pm.done();
        try {
            this.checkFiles(status);
            if (!status.hasFatalError()) {
                this.preCheckInitialConditions(status, new ForwardingProgressMonitor(pm));
                this.doCheckInitialConditions(status, new ForwardingProgressMonitor(pm));
            }
        }
        catch (PreconditionFailure f) {
            status.addFatalError(f.getMessage());
        }
        return status;
    }

    protected abstract V getVPG();

    protected abstract void checkFiles(RefactoringStatus var1) throws PreconditionFailure;

    protected void preCheckInitialConditions(RefactoringStatus status, IProgressMonitor pm) throws PreconditionFailure {
    }

    protected abstract void doCheckInitialConditions(RefactoringStatus var1, IProgressMonitor var2) throws PreconditionFailure;

    protected void logVPGErrors(RefactoringStatus status) {
        this.logVPGErrors(status, (Collection<IFile>)null);
    }

    protected void logVPGErrors(RefactoringStatus status, IFile file) {
        this.logVPGErrors(status, file == null ? null : Collections.singleton(file));
    }

    protected void logVPGErrors(RefactoringStatus status, Collection<IFile> files) {
        for (VPGLog.Entry entry : ((VPG)this.vpg).getLog().getEntries()) {
            if (files != null && !this.contains(files, (IVPGNode<T>)entry.getTokenRef())) continue;
            if (entry.isWarning()) {
                status.addWarning(entry.getMessage(), this.createContext((IVPGNode<T>)entry.getTokenRef()));
                continue;
            }
            status.addError(entry.getMessage(), this.createContext((IVPGNode<T>)entry.getTokenRef()));
        }
    }

    private boolean contains(Collection<IFile> files, IVPGNode<T> tokenRef) {
        if (files == null || tokenRef == null || tokenRef.getFilename() == null) {
            return false;
        }
        IFile file = EclipseVPG.getIFileForFilename(tokenRef.getFilename());
        if (file == null) {
            return false;
        }
        return files.contains(file);
    }

    public final RefactoringStatus checkFinalConditions(IProgressMonitor pm) {
        this.allChanges = new CompositeChange(this.getName());
        RefactoringStatus status = new RefactoringStatus();
        try {
            this.preCheckFinalConditions(status, new ForwardingProgressMonitor(pm));
            this.doCheckFinalConditions(status, new ForwardingProgressMonitor(pm));
        }
        catch (PreconditionFailure f) {
            status.addFatalError(f.getMessage());
        }
        return status;
    }

    protected void preCheckFinalConditions(RefactoringStatus status, IProgressMonitor pm) throws PreconditionFailure {
    }

    protected abstract void doCheckFinalConditions(RefactoringStatus var1, IProgressMonitor var2) throws PreconditionFailure;

    public final Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        assert (pm != null);
        this.doCreateChange(pm);
        this.postCreateChange(pm);
        return this.allChanges;
    }

    protected abstract void doCreateChange(IProgressMonitor var1) throws CoreException, OperationCanceledException;

    protected void postCreateChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
    }

    protected void fail(String message) throws PreconditionFailure {
        throw new PreconditionFailure(message);
    }

    protected RefactoringStatusContext createContext(IVPGNode<T> tokenRef) {
        if (tokenRef == null) {
            return null;
        }
        IFile file = EclipseVPG.getIFileForFilename(tokenRef.getFilename());
        if (file == null) {
            return null;
        }
        return new FileStatusContext(file, (IRegion)new Region(tokenRef.getOffset(), tokenRef.getLength()));
    }

    protected void addChangeFromModifiedAST(IFile file, IProgressMonitor pm) {
        try {
            Object ast = ((EclipseVPG)this.vpg).acquireTransientAST(file);
            TextFileChange changeThisFile = new TextFileChange(String.valueOf(this.getName()) + " - " + file.getFullPath().toOSString(), file);
            changeThisFile.initializeValidationData(pm);
            changeThisFile.setEdit((TextEdit)new ReplaceEdit(0, this.countCharsIn(file), this.getSourceCodeFromAST(ast)));
            this.allChanges.add((Change)changeThisFile);
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    protected String getSourceCodeFromAST(A ast) {
        return ast.toString();
    }

    private int countCharsIn(IFile file) throws CoreException, IOException {
        int size = 0;
        BufferedReader in = new BufferedReader(new InputStreamReader(file.getContents(true), file.getCharset()));
        while (((Reader)in).read() > -1) {
            ++size;
        }
        ((Reader)in).close();
        return size;
    }

    protected void checkIfFileIsAccessibleAndWritable(IFile file) throws PreconditionFailure {
        if (!file.isAccessible()) {
            this.fail(Messages.bind((String)Messages.VPGRefactoring_FileInTheEditorIsNotAccessible, (Object)file.getName()));
        }
        if (file.isReadOnly()) {
            this.fail(Messages.bind((String)Messages.VPGRefactoring_FileInTheEditorIsReadOnly, (Object)file.getName()));
        }
    }

    protected static class ForwardingProgressMonitor
    implements IProgressMonitor {
        private IProgressMonitor pm;
        private String prefix = "";

        public ForwardingProgressMonitor(IProgressMonitor pm) {
            this.pm = pm;
        }

        public void beginTask(String name, int totalWork) {
            this.pm.beginTask(name, totalWork);
            this.pm.setTaskName(name);
            this.prefix = String.valueOf(name) + " - ";
        }

        public void done() {
            this.prefix = "";
            this.pm.setTaskName("");
            this.pm.done();
        }

        public void internalWorked(double work) {
            this.pm.internalWorked(work);
        }

        public boolean isCanceled() {
            return this.pm.isCanceled();
        }

        public void setCanceled(boolean value) {
            this.pm.setCanceled(value);
        }

        public void setTaskName(String name) {
            this.pm.setTaskName(String.valueOf(this.prefix) + name);
        }

        public void worked(int work) {
            this.pm.worked(work);
        }

        public void subTask(String name) {
            this.pm.setTaskName(String.valueOf(this.prefix) + name);
        }
    }

    protected static class PreconditionFailure
    extends Exception {
        private static final long serialVersionUID = 1L;

        public PreconditionFailure(String message) {
            super(message);
        }
    }
}

