/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.mpi.openmpi.core.rtsystem;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Pattern;

public class OpenMPI13xInputStream
extends FilterInputStream {
    private static final String rootStartTagString = "<mpirun>";
    private static final String rootEndTagString = "</mpirun>";
    private static final String mapStartTagString = "<map>";
    private static final String mapEndTagString = "</map>";
    private final TagItem rootStartTag;
    private final TagList validStartTags = new TagList();
    private final TagList validTags = new TagList();
    private final TagList finalTags = new TagList();
    private State state = State.PROLOG;
    private boolean rootTag = true;
    private StringBuilder buffer = new StringBuilder();

    protected OpenMPI13xInputStream(InputStream in) {
        super(in);
        this.rootStartTag = this.validStartTags.add(rootStartTagString);
        this.validStartTags.add(mapStartTagString);
        this.validTags.add(mapStartTagString);
        this.validTags.add(mapEndTagString);
        this.validTags.add("<host.*>");
        this.validTags.add("</host>");
        this.validTags.add("<process.*>");
        this.validTags.add("</process>");
        this.validTags.add("<noderesolve.*>");
        this.validTags.add("</noderesolve>");
        this.validTags.add("<stdout.*>");
        this.validTags.add("</stdout>");
        this.validTags.add("<stderr.*>");
        this.validTags.add("</stderr>");
        this.validTags.add("<stddiag.*>");
        this.validTags.add("</stddiag>");
    }

    public int available() throws IOException {
        int available = 0;
        switch (this.state) {
            case PROLOG: {
                available = rootStartTagString.length();
                break;
            }
            case START_TAG: {
                available = super.available();
                break;
            }
            default: {
                available = this.buffer.length() + super.available();
            }
        }
        return available;
    }

    public boolean markSupported() {
        return false;
    }

    public int read() throws IOException {
        int ch;
        block21: while (this.state != State.EPILOG) {
            block0 : switch (this.state) {
                case PROLOG: {
                    ch = super.read();
                    if (ch < 0) {
                        return -1;
                    }
                    if (ch != 60) continue block21;
                    this.buffer.append((char)ch);
                    this.state = State.START_TAG;
                    break;
                }
                case START_TAG: {
                    ch = super.read();
                    if (ch < 0) {
                        return -1;
                    }
                    this.buffer.append((char)ch);
                    switch (ch) {
                        case 60: {
                            this.buffer.delete(0, this.buffer.length());
                            this.state = State.PROLOG;
                            break;
                        }
                        case 62: {
                            TagItem item = this.validStartTags.match(this.buffer.toString());
                            if (item != null) {
                                if (item == this.rootStartTag) {
                                    this.finalTags.add(rootEndTagString);
                                } else {
                                    this.finalTags.add(mapEndTagString);
                                    this.buffer.insert(0, rootStartTagString);
                                    this.rootTag = false;
                                }
                                this.state = State.SEEN_TAG_END;
                                break;
                            }
                            this.buffer.delete(0, this.buffer.length());
                            this.state = State.PROLOG;
                        }
                    }
                    continue block21;
                }
                case XML: {
                    ch = super.read();
                    if (ch < 0) {
                        return -1;
                    }
                    if (ch < 32) continue block21;
                    switch (ch) {
                        case 60: {
                            this.buffer.append((char)ch);
                            this.state = State.SEEN_TAG_START;
                            break block0;
                        }
                        case 62: {
                            this.buffer.append("&gt;");
                            break block0;
                        }
                    }
                    return ch;
                }
                case SEEN_TAG_START: {
                    ch = super.read();
                    if (ch < 0) {
                        return -1;
                    }
                    if (ch < 32) continue block21;
                    switch (ch) {
                        case 60: {
                            this.buffer.append("&lt;");
                            this.state = State.XML;
                            break;
                        }
                        case 62: {
                            this.buffer.append((char)ch);
                            String val = this.buffer.toString();
                            if (this.finalTags.match(val) != null) {
                                this.state = State.SEEN_FINAL;
                                break;
                            }
                            if (this.validTags.match(val) == null) continue block21;
                            this.state = State.SEEN_TAG_END;
                            break;
                        }
                        default: {
                            this.buffer.append((char)ch);
                            break;
                        }
                    }
                    continue block21;
                }
                case SEEN_TAG_END: {
                    ch = this.buffer.charAt(0);
                    this.buffer.deleteCharAt(0);
                    if (this.buffer.length() == 0) {
                        this.state = State.FINISHED_TAG;
                    }
                    return ch;
                }
                case FINISHED_TAG: {
                    this.state = State.XML;
                    break;
                }
                case SEEN_FINAL: {
                    if (this.buffer.length() > 0) {
                        ch = this.buffer.charAt(0);
                        this.buffer.deleteCharAt(0);
                        return ch;
                    }
                    if (!this.rootTag) {
                        this.buffer.insert(0, rootEndTagString);
                    }
                    this.state = State.EPILOG;
                    break;
                }
                default: {
                    assert (false);
                    continue block21;
                }
            }
        }
        if (this.buffer.length() == 0) {
            return -1;
        }
        ch = this.buffer.charAt(0);
        this.buffer.deleteCharAt(0);
        return ch;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        int pos = off;
        int avail = this.available();
        if (avail > len) {
            avail = len;
        } else if (avail == 0) {
            avail = 1;
        }
        int i = 0;
        while (i < avail) {
            int ch = this.read();
            if (ch < 0) {
                if (i > 0) break;
                return -1;
            }
            b[pos++] = (byte)(ch & 0xFF);
            if (this.state == State.FINISHED_TAG) break;
            ++i;
        }
        return pos - off;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        PROLOG,
        START_TAG,
        XML,
        SEEN_TAG_START,
        SEEN_TAG_END,
        FINISHED_TAG,
        SEEN_FINAL,
        EPILOG;

    }

    protected class TagItem {
        private final Pattern pattern;

        public TagItem(String pattern) {
            this.pattern = Pattern.compile(pattern);
        }

        public boolean match(String tag) {
            return this.pattern.matcher(tag).matches();
        }
    }

    protected class TagList {
        private int longest = 0;
        private int shortest = 0;
        private final ArrayList<TagItem> tags = new ArrayList();

        protected TagList() {
        }

        public TagItem add(String pattern) {
            TagItem item = new TagItem(pattern);
            this.tags.add(item);
            return item;
        }

        public TagItem match(String str) {
            for (TagItem item : this.tags) {
                if (!item.match(str)) continue;
                return item;
            }
            return null;
        }

        public int longest() {
            return this.longest;
        }

        public int shortest() {
            return this.shortest;
        }
    }

    protected class TagSet {
        private final int len;
        private HashMap<String, TagItem> tags = new HashMap();

        public TagSet(int len) {
            this.len = len;
        }

        public int length() {
            return this.len;
        }

        public TagItem add(String tag) {
            TagItem item = new TagItem(tag);
            this.tags.put(tag, item);
            return item;
        }

        public TagItem match(String str) {
            if (str.length() >= this.len) {
                return this.tags.get(str.substring(0, this.len));
            }
            return null;
        }
    }
}

