/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.lml.internal.core.model;

import java.util.HashMap;
import java.util.List;
import org.eclipse.ptp.rm.lml.core.events.ILguiUpdatedEvent;
import org.eclipse.ptp.rm.lml.core.listeners.ILguiListener;
import org.eclipse.ptp.rm.lml.core.model.ILguiItem;
import org.eclipse.ptp.rm.lml.internal.core.elements.LguiType;
import org.eclipse.ptp.rm.lml.internal.core.elements.ObjectName;
import org.eclipse.ptp.rm.lml.internal.core.elements.ObjectType;
import org.eclipse.ptp.rm.lml.internal.core.elements.ObjectsType;
import org.eclipse.ptp.rm.lml.internal.core.model.LMLColor;
import org.eclipse.ptp.rm.lml.internal.core.model.LguiHandler;

public class OIDToObject
extends LguiHandler {
    private static final LMLColor notConnectedColor = LMLColor.lightGray;
    private HashMap<String, ObjectType> oidToObject;
    private HashMap<String, LMLColor> oidToColor;
    private String systemId = null;

    public OIDToObject(ILguiItem lguiItem, LguiType lgui) {
        super(lguiItem, lgui);
        this.updateData();
        this.lguiItem.addListener(new ILguiListener(){

            public void handleEvent(ILguiUpdatedEvent e) {
                OIDToObject.this.update(e.getLgui());
                OIDToObject.this.updateData();
            }
        });
    }

    public LMLColor getColorById(String id) {
        if (id == null) {
            return notConnectedColor;
        }
        LMLColor res = this.oidToColor.get(id);
        if (res == null) {
            return notConnectedColor;
        }
        return res;
    }

    public ObjectType getObjectById(String id) {
        return this.oidToObject.get(id);
    }

    public String getSystemObjectId() {
        return this.systemId;
    }

    private void updateData() {
        List<ObjectsType> allobjs = this.lguiItem.getOverviewAccess().getObjects();
        for (ObjectsType frame : allobjs) {
            List<ObjectType> objects = frame.getObject();
            this.oidToObject = new HashMap();
            this.oidToColor = new HashMap();
            for (ObjectType obj : objects) {
                this.oidToObject.put(obj.getId(), obj);
                this.oidToColor.put(obj.getId(), LMLColor.stringToColor(obj.getColor()));
                if (obj.getType() != ObjectName.SYSTEM) continue;
                this.systemId = obj.getId();
            }
        }
    }
}

