/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core;

import java.net.URISyntaxException;
import java.util.regex.Pattern;
import org.eclipse.egit.core.CoreText;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.osgi.util.NLS;

public final class ProjectReference {
    private static final String DEFAULT_BRANCH = "master";
    private String version;
    private String projectDir;
    private URIish repository;
    private String branch = "master";
    private String origin = "origin";
    static final String SEPARATOR = ",";

    public ProjectReference(String reference) throws URISyntaxException, IllegalArgumentException {
        String[] tokens = reference.split(Pattern.quote(SEPARATOR));
        if (tokens.length != 4) {
            throw new IllegalArgumentException(NLS.bind((String)CoreText.ProjectReference_InvalidTokensCount, (Object[])new Object[]{4, tokens.length, tokens}));
        }
        this.version = tokens[0];
        this.repository = new URIish(tokens[1]);
        if (!"".equals(tokens[2])) {
            this.branch = tokens[2];
        }
        this.projectDir = tokens[3];
    }

    public URIish getRepository() {
        return this.repository;
    }

    public String getBranch() {
        return this.branch;
    }

    public String getOrigin() {
        return this.origin;
    }

    public String getProjectDir() {
        return this.projectDir;
    }

    String getVersion() {
        return this.version;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.branch == null ? 0 : this.branch.hashCode());
        result = 31 * result + (this.projectDir == null ? 0 : this.projectDir.hashCode());
        result = 31 * result + (this.repository == null ? 0 : this.repository.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProjectReference)) {
            return false;
        }
        ProjectReference other = (ProjectReference)obj;
        if (this.branch == null ? other.branch != null : !this.branch.equals(other.branch)) {
            return false;
        }
        if (this.projectDir == null ? other.projectDir != null : !this.projectDir.equals(other.projectDir)) {
            return false;
        }
        return !(this.repository == null ? other.repository != null : !this.repository.equals((Object)other.repository));
    }
}

