/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remotetools.environment.launcher.internal;

import java.io.File;
import java.io.PrintWriter;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.remotetools.core.IRemoteCopyTools;
import org.eclipse.ptp.remotetools.core.IRemoteExecutionManager;
import org.eclipse.ptp.remotetools.core.IRemoteFileTools;
import org.eclipse.ptp.remotetools.core.IRemoteItem;
import org.eclipse.ptp.remotetools.environment.launcher.core.LinuxPath;
import org.eclipse.ptp.remotetools.environment.launcher.data.ExecutionConfiguration;
import org.eclipse.ptp.remotetools.environment.launcher.internal.DownloadBackRule;
import org.eclipse.ptp.remotetools.environment.launcher.internal.ILaunchProcessCallback;
import org.eclipse.ptp.remotetools.environment.launcher.internal.IRuleAction;
import org.eclipse.ptp.remotetools.environment.launcher.internal.Messages;
import org.eclipse.ptp.remotetools.exception.CancelException;
import org.eclipse.ptp.remotetools.exception.RemoteConnectionException;
import org.eclipse.ptp.remotetools.exception.RemoteOperationException;

public class DownloadBackAction
implements IRuleAction {
    private ILaunchProcessCallback process;
    private DownloadBackRule rule;
    private ExecutionConfiguration configuration;
    private PrintWriter outputWriter;
    private PrintWriter errorWriter;
    private IRemoteExecutionManager manager;

    public DownloadBackAction(ILaunchProcessCallback process, DownloadBackRule downloadBackRule) {
        this.process = process;
        this.rule = downloadBackRule;
        this.configuration = process.getConfiguration();
        this.outputWriter = process.getOutputWriter();
        this.errorWriter = process.getErrorWriter();
        this.manager = process.getExecutionManager();
    }

    public void run() throws CoreException, CancelException, RemoteConnectionException {
        Assert.isNotNull((Object)this.process);
        Assert.isNotNull((Object)this.rule);
        Assert.isNotNull((Object)this.configuration);
        Assert.isNotNull((Object)this.outputWriter);
        Assert.isNotNull((Object)this.errorWriter);
        Assert.isNotNull((Object)this.manager);
        int i = 0;
        while (i < this.rule.count()) {
            File localFile = this.rule.getLocalFile(i);
            IPath remotePath = this.rule.getRemoteFile(i);
            this.downloadFile(localFile, remotePath, null);
            ++i;
        }
    }

    private void downloadFile(File localFile, IPath remotePath, IProgressMonitor monitor) throws CoreException, CancelException, RemoteConnectionException {
        String remotePathAsString = LinuxPath.toString(remotePath);
        IRemoteCopyTools copyTools = this.manager.getRemoteCopyTools();
        IRemoteFileTools fileTools = this.manager.getRemoteFileTools();
        IRemoteItem remoteFile = null;
        try {
            remoteFile = fileTools.getFile(remotePathAsString, monitor);
        }
        catch (RemoteOperationException e) {
            this.errorWriter.println(NLS.bind((String)Messages.DownloadBackAction_FailedFetchRemoteProperties, (Object)e.getMessage()));
            return;
        }
        if (!remoteFile.exists()) {
            this.errorWriter.println(NLS.bind((String)Messages.DownloadBackAction_FailedFiledDoesNotExist, (Object)remotePathAsString));
            return;
        }
        long difference = remoteFile.getModificationTime() - localFile.lastModified();
        if (difference < 1000L && remoteFile.getSize() == localFile.length()) {
            this.outputWriter.println(NLS.bind((String)Messages.DownloadBackAction_NotifyFileNotChanged, (Object)remotePath));
            return;
        }
        try {
            this.outputWriter.println(NLS.bind((String)Messages.DownloadBackAction_NotifyDonwloadBack, (Object)remotePathAsString));
            copyTools.downloadFileToFile(remotePathAsString, localFile);
        }
        catch (RemoteOperationException e) {
            this.errorWriter.println(NLS.bind((String)Messages.DownloadBackAction_FailedDownloadBack, (Object)e.getMessage()));
            return;
        }
    }
}

