/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remotetools.environment.launcher.internal;

import org.eclipse.core.runtime.Assert;
import org.eclipse.ptp.remotetools.environment.launcher.data.DownloadRule;
import org.eclipse.ptp.remotetools.environment.launcher.data.ISynchronizationRule;
import org.eclipse.ptp.remotetools.environment.launcher.data.UploadRule;
import org.eclipse.ptp.remotetools.environment.launcher.internal.DownloadBackAction;
import org.eclipse.ptp.remotetools.environment.launcher.internal.DownloadBackRule;
import org.eclipse.ptp.remotetools.environment.launcher.internal.DownloadRuleAction;
import org.eclipse.ptp.remotetools.environment.launcher.internal.ILaunchProcessCallback;
import org.eclipse.ptp.remotetools.environment.launcher.internal.IRuleAction;
import org.eclipse.ptp.remotetools.environment.launcher.internal.UploadRuleAction;

public class RuleActionFactory {
    private ILaunchProcessCallback process;

    public RuleActionFactory(ILaunchProcessCallback process) {
        this.process = process;
    }

    public IRuleAction getAction(ISynchronizationRule rule) {
        if (rule instanceof DownloadRule) {
            DownloadRule downloadRule = (DownloadRule)rule;
            DownloadRuleAction action = new DownloadRuleAction(this.process, downloadRule);
            return action;
        }
        if (rule instanceof UploadRule) {
            UploadRule uploadRule = (UploadRule)rule;
            UploadRuleAction action = new UploadRuleAction(this.process, uploadRule);
            return action;
        }
        if (rule instanceof DownloadBackRule) {
            DownloadBackRule uploadRule = (DownloadBackRule)rule;
            DownloadBackAction action = new DownloadBackAction(this.process, uploadRule);
            return action;
        }
        Assert.isLegal((boolean)false);
        return null;
    }
}

