/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remotetools.environment.launcher.internal.process;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.ptp.remotetools.environment.launcher.internal.process.Messages;

public abstract class AbstractProcess
extends PlatformObject
implements IProcess {
    protected String label = Messages.AbstractProcess_DefaultLabel;
    static int counter;
    protected ILaunch launch;
    protected Map attributes;
    protected boolean captureOutput = true;

    public AbstractProcess(ILaunch launch, String label) {
        this.launch = launch;
        this.label = label == null ? "bogus " + Integer.toString(++counter) : label;
        String captureOutputValue = launch.getAttribute("org.eclipse.debug.core.capture_output");
        this.captureOutput = !"false".equals(captureOutputValue);
    }

    public void start() {
        this.launch.addProcess((IProcess)this);
        this.fireCreationEvent();
        this.fireChangeEvent();
    }

    public String getLabel() {
        return this.label;
    }

    public ILaunch getLaunch() {
        return this.launch;
    }

    public void setAttribute(String key, String value) {
        Object origVal;
        if (this.attributes == null) {
            this.attributes = new HashMap(5);
        }
        if ((origVal = this.attributes.get(key)) != null && origVal.equals(value)) {
            return;
        }
        this.attributes.put(key, value);
        this.fireChangeEvent();
    }

    public String getAttribute(String key) {
        if (this.attributes == null) {
            return null;
        }
        return (String)this.attributes.get(key);
    }

    public void copyAttributes(Map attributes) {
        if (attributes != null) {
            for (String key : attributes.keySet()) {
                this.setAttribute(key, (String)attributes.get(key));
            }
        }
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(IProcess.class)) {
            return this;
        }
        if (adapter.equals(IDebugTarget.class)) {
            ILaunch launch = this.getLaunch();
            IDebugTarget[] targets = launch.getDebugTargets();
            int i = 0;
            while (i < targets.length) {
                if (((Object)((Object)this)).equals(targets[i].getProcess())) {
                    return targets[i];
                }
                ++i;
            }
            return null;
        }
        return super.getAdapter(adapter);
    }

    protected void fireCreationEvent() {
        this.fireEvent(new DebugEvent((Object)this, 4));
    }

    protected void fireEvent(DebugEvent event) {
        DebugPlugin manager = DebugPlugin.getDefault();
        if (manager != null) {
            manager.fireDebugEventSet(new DebugEvent[]{event});
        }
    }

    protected void fireTerminateEvent() {
        this.fireEvent(new DebugEvent((Object)this, 8));
    }

    protected void fireChangeEvent() {
        this.fireEvent(new DebugEvent((Object)this, 16));
    }
}

