/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remotetools.environment.launcher.internal.process;

import java.io.OutputStream;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.ptp.remotetools.environment.launcher.core.ILaunchProcess;
import org.eclipse.ptp.remotetools.environment.launcher.core.ILaunchProgressListener;
import org.eclipse.ptp.remotetools.environment.launcher.internal.process.AbstractProcess;
import org.eclipse.ptp.remotetools.environment.launcher.internal.process.ExecutionStreamsProxy;
import org.eclipse.ptp.remotetools.environment.launcher.internal.process.Messages;
import org.eclipse.ptp.remotetools.environment.launcher.internal.process.MonitorOutputStream;

public class TargetProcess
extends AbstractProcess
implements ILaunchProgressListener {
    final ILaunchProcess executionJob;
    boolean wasFinished = false;
    final MonitorOutputStream monitorOutputStream = new MonitorOutputStream();
    final MonitorOutputStream monitorErrorStream = new MonitorOutputStream();
    final ExecutionStreamsProxy streamsProxy = new ExecutionStreamsProxy(this.monitorErrorStream, this.monitorOutputStream);

    public TargetProcess(ILaunch launch, ILaunchProcess job) {
        super(launch, Messages.TargetProcess_Label);
        this.executionJob = job;
    }

    public int getExitValue() throws DebugException {
        return 0;
    }

    public IStreamsProxy getStreamsProxy() {
        return this.streamsProxy;
    }

    public boolean canTerminate() {
        return this.executionJob.getCurrentProgress() != 13;
    }

    public boolean isTerminated() {
        return this.wasFinished || !this.canTerminate();
    }

    public void terminate() throws DebugException {
        this.executionJob.markAsCanceled();
    }

    public OutputStream getOutputStream() {
        return this.monitorOutputStream;
    }

    public OutputStream getErrorStream() {
        return this.monitorErrorStream;
    }

    public void notifyProgress(int progress) {
        this.fireChangeEvent();
        if (progress == 13) {
            this.fireTerminateEvent();
        }
    }

    public void notifyInterrupt() {
        this.wasFinished = true;
        this.fireTerminateEvent();
    }
}

