/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remotetools.environment.launcher.variables;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.IDynamicVariable;
import org.eclipse.core.variables.IDynamicVariableResolver;
import org.eclipse.ptp.remotetools.environment.launcher.RemoteLauncherPlugin;
import org.eclipse.ptp.remotetools.environment.launcher.variables.Messages;

public class RemoteWorkspaceResolver
implements IDynamicVariableResolver {
    protected static final String USER_WORKSPACE_VARIABLE = "user_workspace";
    protected static final String CONCATENATE_CHAR = "_";
    protected static final String DEFAULT_USER_WORKSPACE = "generic_user_workspace";

    public String resolveValue(IDynamicVariable variable, String argument) throws CoreException {
        String variableName = variable.getName();
        if (variableName.equals(USER_WORKSPACE_VARIABLE)) {
            try {
                String hostname = InetAddress.getLocalHost().getHostName();
                String username = System.getProperty("user.name");
                return String.valueOf(hostname) + CONCATENATE_CHAR + username;
            }
            catch (UnknownHostException uhe) {
                uhe.printStackTrace();
                return DEFAULT_USER_WORKSPACE;
            }
        }
        throw new CoreException((IStatus)new Status(4, RemoteLauncherPlugin.getUniqueIdentifier(), 0, Messages.invalidEclipseVariableErrorMessage, null));
    }
}

