/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.jaxb.control.ui.handlers;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.ptp.rm.jaxb.control.ui.messages.Messages;
import org.eclipse.ptp.rm.jaxb.control.ui.utils.ControlStateRule;
import org.eclipse.ptp.rm.jaxb.core.data.ControlStateRuleType;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TypedListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlStateListener
implements SelectionListener {
    private final ControlStateRule rule;
    private final Control target;
    private final Action action;

    public ControlStateListener(Control target, ControlStateRuleType rule, Action action, Map<String, Button> map) throws Throwable {
        this.target = target;
        this.action = action;
        HashSet<Button> sources = new HashSet<Button>();
        this.rule = new ControlStateRule(rule, map, sources);
        for (Button b : sources) {
            b.addSelectionListener((SelectionListener)this);
        }
    }

    public void findCyclicalDependecies(Set<Button> buttons) throws Throwable {
        if (this.target instanceof Button) {
            Listener[] listeners;
            if (buttons.contains(this.target)) {
                throw new Throwable(String.valueOf(Messages.ControlStateListener_0) + this.target + Messages.ControlStateListener_1 + buttons);
            }
            Button b = (Button)this.target;
            buttons.add(b);
            Listener[] listenerArray = listeners = b.getListeners(13);
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                SWTEventListener swtListener;
                Listener listener = listenerArray[n2];
                if (listener instanceof TypedListener && (swtListener = ((TypedListener)listener).getEventListener()) instanceof ControlStateListener) {
                    ((ControlStateListener)swtListener).findCyclicalDependecies(buttons);
                }
                ++n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setState() {
        Class<ControlStateListener> clazz = ControlStateListener.class;
        synchronized (ControlStateListener.class) {
            if (this.rule.evaluate()) {
                switch (this.action) {
                    case ENABLE: {
                        this.target.setEnabled(true);
                        break;
                    }
                    case DISABLE: {
                        this.target.setEnabled(false);
                        break;
                    }
                    case SHOW: {
                        this.target.setVisible(true);
                        break;
                    }
                    case HIDE: {
                        this.target.setVisible(false);
                    }
                }
            } else {
                switch (this.action) {
                    case ENABLE: {
                        this.target.setEnabled(false);
                        break;
                    }
                    case DISABLE: {
                        this.target.setEnabled(true);
                        break;
                    }
                    case SHOW: {
                        this.target.setVisible(false);
                        break;
                    }
                    case HIDE: {
                        this.target.setVisible(true);
                    }
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.setState();
    }

    public void widgetSelected(SelectionEvent e) {
        this.setState();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Action {
        ENABLE,
        DISABLE,
        SHOW,
        HIDE,
        NONE;

    }
}

