/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.jaxb.control.ui.handlers;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ptp.rm.jaxb.control.ui.ICellEditorUpdateModel;
import org.eclipse.ptp.rm.jaxb.control.ui.IUpdateModel;
import org.eclipse.ptp.rm.jaxb.control.ui.IUpdateModelEnabled;
import org.eclipse.ptp.rm.jaxb.control.ui.model.ViewerUpdateModel;

public class ValueUpdateHandler {
    private final Map<Object, IUpdateModel> controlToModelMap = new HashMap<Object, IUpdateModel>();
    private final Map<Object, ICellEditorUpdateModel> cellEditorToModelMap = new HashMap<Object, ICellEditorUpdateModel>();
    private final Map<Viewer, ViewerUpdateModel> viewerModelMap = new HashMap<Viewer, ViewerUpdateModel>();
    private final TreeMap<String, String> errors = new TreeMap();
    private final IUpdateModelEnabled tab;

    public ValueUpdateHandler(IUpdateModelEnabled tab) {
        this.tab = tab;
    }

    public void addError(String source, String error) {
        this.errors.put(source, error);
        this.tab.fireContentsChanged();
    }

    public void addUpdateModelEntry(Object control, IUpdateModel model) {
        if (model instanceof ViewerUpdateModel) {
            ViewerUpdateModel vum = (ViewerUpdateModel)model;
            this.viewerModelMap.put((Viewer)control, vum);
        } else if (model instanceof ICellEditorUpdateModel) {
            this.cellEditorToModelMap.put(control, (ICellEditorUpdateModel)model);
        } else {
            this.controlToModelMap.put(control, model);
        }
    }

    public void clear() {
        this.cellEditorToModelMap.clear();
        this.controlToModelMap.clear();
        this.viewerModelMap.clear();
    }

    public String getFirstError() {
        String name;
        if (!this.errors.isEmpty() && (name = this.errors.firstKey()) != null) {
            return String.valueOf(name) + ":" + " " + this.errors.get(name);
        }
        return null;
    }

    public void handleUpdate(Object source, Object value) {
        if (!this.errors.isEmpty()) {
            return;
        }
        this.tab.relink();
        int i = 0;
        while (i < 2) {
            for (Object control : this.cellEditorToModelMap.keySet()) {
                if (control == source) continue;
                ICellEditorUpdateModel m = this.cellEditorToModelMap.get(control);
                m.refreshValueFromMap();
            }
            for (ViewerUpdateModel vum : this.viewerModelMap.values()) {
                vum.storeValue();
            }
            ++i;
        }
        for (Object control : this.controlToModelMap.keySet()) {
            if (control == source) continue;
            IUpdateModel m = this.controlToModelMap.get(control);
            m.refreshValueFromMap();
        }
        for (Viewer viewer : this.viewerModelMap.keySet()) {
            viewer.refresh();
        }
        this.tab.fireContentsChanged();
    }

    public void removeError(String source) {
        this.errors.remove(source);
        if (!this.errors.isEmpty()) {
            this.tab.fireContentsChanged();
        }
    }
}

