/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.jaxb.control.ui.wizards;

import java.net.URI;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.remote.ui.PTPRemoteUIPlugin;
import org.eclipse.ptp.remote.ui.RemoteUIServicesUtils;
import org.eclipse.ptp.remote.ui.widgets.RemoteConnectionWidget;
import org.eclipse.ptp.rm.jaxb.control.ui.messages.Messages;
import org.eclipse.ptp.rm.jaxb.core.IJAXBResourceManagerConfiguration;
import org.eclipse.ptp.rm.jaxb.core.data.ResourceManagerData;
import org.eclipse.ptp.rm.jaxb.core.data.SiteType;
import org.eclipse.ptp.rm.jaxb.ui.JAXBUIPlugin;
import org.eclipse.ptp.rm.ui.wizards.AbstractRemoteResourceManagerConfigurationWizardPage;
import org.eclipse.ptp.ui.wizards.IRMConfigurationWizard;
import org.eclipse.swt.widgets.Composite;

public final class JAXBRMControlConfigurationWizardPage
extends AbstractRemoteResourceManagerConfigurationWizardPage {
    public JAXBRMControlConfigurationWizardPage(IRMConfigurationWizard wizard) {
        super(wizard, Messages.JAXBRMControlConfigurationWizardPage_Title);
        this.setPageComplete(false);
        this.setTitle(Messages.JAXBRMControlConfigurationWizardPage_Title);
        this.setDescription(Messages.JAXBConnectionWizardPage_Description);
    }

    protected Composite doCreateContents(Composite parent) {
        Composite comp = super.doCreateContents(parent);
        try {
            SiteType site;
            ResourceManagerData data = this.getBaseConfiguration().getResourceManagerData();
            if (data != null && (site = data.getSiteData()) != null && site.getControlConnection() != null && this.getConfiguration().getRemoteServicesId() == null) {
                URI uri = new URI(site.getControlConnection());
                IRemoteServices services = PTPRemoteUIPlugin.getDefault().getRemoteServices(uri, (IRunnableContext)this.getWizard().getContainer());
                if (services != null) {
                    this.getConfiguration().setRemoteServicesId(services.getId());
                    String auth = uri.getAuthority();
                    String host = uri.getHost();
                    String user = uri.getUserInfo();
                    int port = uri.getPort();
                    if (auth != null && host != null) {
                        IRemoteConnection conn = services.getConnectionManager().getConnection(host);
                        if (conn == null && services.canCreateConnections()) {
                            conn = services.getConnectionManager().newConnection(host);
                            conn.setAddress(host);
                            if (!auth.equals(host)) {
                                if (user != null) {
                                    conn.setUsername(user);
                                }
                                if (port != -1) {
                                    conn.setPort(port);
                                }
                            }
                        }
                        if (conn != null) {
                            this.getConfiguration().setConnectionName(conn.getName());
                            RemoteUIServicesUtils.setConnectionHints((RemoteConnectionWidget)this.connectionWidget, (IRemoteConnection)conn);
                        }
                    }
                }
            }
        }
        catch (Throwable t) {
            JAXBUIPlugin.log((Throwable)t);
        }
        return comp;
    }

    protected IJAXBResourceManagerConfiguration getConfiguration() {
        return (IJAXBResourceManagerConfiguration)super.getConfiguration();
    }

    private IJAXBResourceManagerConfiguration getBaseConfiguration() {
        return (IJAXBResourceManagerConfiguration)((IRMConfigurationWizard)this.getWizard()).getBaseConfiguration();
    }
}

