/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remotetools.environment.generichost.core;

import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ptp.remotetools.core.IAuthInfo;
import org.eclipse.ptp.remotetools.environment.control.ITargetConfig;
import org.eclipse.ptp.remotetools.environment.generichost.messages.Messages;
import org.eclipse.ptp.remotetools.environment.generichost.ui.KeyboardInteractiveDialog;
import org.eclipse.ptp.remotetools.environment.generichost.ui.UserValidationDialog;
import org.eclipse.swt.widgets.Display;

public class AuthInfo
implements IAuthInfo {
    private ITargetConfig fConfig = null;
    private String fPassword = null;
    private String fPassphrase = null;

    public AuthInfo(ITargetConfig config) {
        this.fConfig = config;
    }

    public String getPassphrase() {
        if (this.fPassphrase != null) {
            String res = this.fPassphrase;
            this.fPassphrase = null;
            return res;
        }
        return this.fConfig.getKeyPassphrase();
    }

    public String getPassword() {
        if (this.fPassword != null) {
            String res = this.fPassword;
            this.fPassword = null;
            return res;
        }
        return this.fConfig.getLoginPassword();
    }

    public String[] promptKeyboardInteractive(final String destination, final String name, final String instruction, final String[] prompt, final boolean[] echo) {
        String[] result;
        block5: {
            if (prompt.length == 0) {
                return new String[0];
            }
            try {
                final String[][] finResult = new String[1][];
                AuthInfo.getDisplay().syncExec(new Runnable(){

                    public void run() {
                        KeyboardInteractiveDialog dialog = new KeyboardInteractiveDialog(null, destination, name, instruction, prompt, echo);
                        dialog.open();
                        finResult[0] = dialog.getResult();
                    }
                });
                result = finResult[0];
                if (result != null) break block5;
                return null;
            }
            catch (OperationCanceledException operationCanceledException) {
                return null;
            }
        }
        if (result.length == 1 && prompt.length == 1 && prompt[0].trim().equalsIgnoreCase("password:")) {
            this.fPassword = result[0];
        }
        return result;
    }

    public boolean promptPassphrase(String message) {
        PromptSecret ps = new PromptSecret();
        ps.prompt(message);
        this.fPassphrase = ps.getResult();
        if (this.fPassphrase == null) {
            return false;
        }
        if (ps.isSaveResult()) {
            this.fConfig.setKeyPassphrase(ps.getResult());
        }
        return true;
    }

    public boolean promptPassword(String message) {
        PromptSecret ps = new PromptSecret();
        ps.prompt(message);
        this.fPassword = ps.getResult();
        if (this.fPassword == null) {
            return false;
        }
        if (ps.isSaveResult()) {
            this.fConfig.setLoginPassword(ps.getResult());
        }
        return true;
    }

    public boolean promptYesNo(final String str) {
        final boolean[] retval = new boolean[1];
        AuthInfo.getDisplay().syncExec(new Runnable(){

            public void run() {
                retval[0] = MessageDialog.openQuestion(null, (String)Messages.Environment_Warning, (String)str);
            }
        });
        return retval[0];
    }

    public void setPassphrase(String passphrase) {
        this.fConfig.setKeyPassphrase(passphrase);
    }

    public void setPassword(String password) {
        this.fConfig.setLoginPassword(password);
    }

    public void setUsePassword(boolean usePassword) {
        this.fConfig.setPasswordAuth(usePassword);
    }

    public void showMessage(final String message) {
        AuthInfo.getDisplay().syncExec(new Runnable(){

            public void run() {
                MessageDialog.openInformation(null, (String)Messages.Environment_Info, (String)message);
            }
        });
    }

    public String getKeyPath() {
        return this.fConfig.getKeyPath();
    }

    public String getUsername() {
        return this.fConfig.getLoginUsername();
    }

    public boolean isPasswordAuth() {
        return this.fConfig.isPasswordAuth();
    }

    public void setKeyPath(String keyPath) {
        this.fConfig.setKeyPath(keyPath);
    }

    public void setUsername(String username) {
        this.fConfig.setLoginUsername(username);
    }

    private static Display getDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    private class PromptSecret {
        private String fResult = null;
        private boolean fSaveResult = false;

        private PromptSecret() {
        }

        public void prompt(final String message) {
            final String finUser = AuthInfo.this.fConfig.getLoginUsername();
            AuthInfo.getDisplay().syncExec(new Runnable(){

                public void run() {
                    UserValidationDialog uvd = new UserValidationDialog(null, finUser, message);
                    uvd.setUsernameMutable(false);
                    if (uvd.open() == 0) {
                        PromptSecret.this.fResult = uvd.getPassword();
                        PromptSecret.this.fSaveResult = uvd.isSavePassword();
                    }
                }
            });
        }

        public String getResult() {
            return this.fResult;
        }

        public boolean isSaveResult() {
            return this.fSaveResult;
        }
    }
}

