/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.ui.memory.transport;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.math.BigInteger;
import org.eclipse.cdt.debug.ui.memory.transport.ExportMemoryDialog;
import org.eclipse.cdt.debug.ui.memory.transport.MemoryTransportPlugin;
import org.eclipse.cdt.debug.ui.memory.transport.Messages;
import org.eclipse.cdt.debug.ui.memory.transport.model.IMemoryExporter;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockExtension;
import org.eclipse.debug.core.model.MemoryByte;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class PlainTextExporter
implements IMemoryExporter {
    File fOutputFile;
    BigInteger fStartAddress;
    BigInteger fEndAddress;
    private Text fStartText;
    private Text fEndText;
    private Text fLengthText;
    private Text fFileText;
    private IMemoryBlock fMemoryBlock;
    private ExportMemoryDialog fParentDialog;
    private IDialogSettings fProperties;

    public Control createControl(final Composite parent, IMemoryBlock memBlock, IDialogSettings properties, ExportMemoryDialog parentDialog) {
        this.fMemoryBlock = memBlock;
        this.fParentDialog = parentDialog;
        this.fProperties = properties;
        Composite composite = new Composite(parent, 0){

            public void dispose() {
                PlainTextExporter.this.fProperties.put("File", PlainTextExporter.this.fFileText.getText());
                PlainTextExporter.this.fProperties.put("Start", PlainTextExporter.this.fStartText.getText());
                PlainTextExporter.this.fProperties.put("End", PlainTextExporter.this.fEndText.getText());
                PlainTextExporter.this.fStartAddress = PlainTextExporter.this.getStartAddress();
                PlainTextExporter.this.fEndAddress = PlainTextExporter.this.getEndAddress();
                PlainTextExporter.this.fOutputFile = PlainTextExporter.this.getFile();
                super.dispose();
            }
        };
        FormLayout formLayout = new FormLayout();
        formLayout.spacing = 5;
        formLayout.marginHeight = 9;
        formLayout.marginWidth = 9;
        composite.setLayout((Layout)formLayout);
        Label startLabel = new Label(composite, 0);
        startLabel.setText(Messages.getString("PlainTextExporter.StartAddress"));
        FormData data = new FormData();
        startLabel.setLayoutData((Object)data);
        this.fStartText = new Text(composite, 2048);
        data = new FormData();
        data.left = new FormAttachment((Control)startLabel);
        data.width = 100;
        this.fStartText.setLayoutData((Object)data);
        Label endLabel = new Label(composite, 0);
        endLabel.setText(Messages.getString("PlainTextExporter.EndAddress"));
        data = new FormData();
        data.top = new FormAttachment((Control)this.fStartText, 0, 0x1000000);
        data.left = new FormAttachment((Control)this.fStartText);
        endLabel.setLayoutData((Object)data);
        this.fEndText = new Text(composite, 2048);
        data = new FormData();
        data.top = new FormAttachment((Control)this.fStartText, 0, 0x1000000);
        data.left = new FormAttachment((Control)endLabel);
        data.width = 100;
        this.fEndText.setLayoutData((Object)data);
        Label lengthLabel = new Label(composite, 0);
        lengthLabel.setText(Messages.getString("PlainTextExporter.Length"));
        data = new FormData();
        data.top = new FormAttachment((Control)this.fStartText, 0, 0x1000000);
        data.left = new FormAttachment((Control)this.fEndText);
        lengthLabel.setLayoutData((Object)data);
        this.fLengthText = new Text(composite, 2048);
        data = new FormData();
        data.top = new FormAttachment((Control)this.fStartText, 0, 0x1000000);
        data.left = new FormAttachment((Control)lengthLabel);
        data.width = 100;
        this.fLengthText.setLayoutData((Object)data);
        Label fileLabel = new Label(composite, 0);
        this.fFileText = new Text(composite, 2048);
        Button fileButton = new Button(composite, 8);
        fileLabel.setText(Messages.getString("Exporter.FileName"));
        data = new FormData();
        data.top = new FormAttachment((Control)fileButton, 0, 0x1000000);
        fileLabel.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)fileButton, 0, 0x1000000);
        data.left = new FormAttachment((Control)fileLabel);
        data.width = 300;
        this.fFileText.setLayoutData((Object)data);
        fileButton.setText(Messages.getString("Exporter.Browse"));
        data = new FormData();
        data.top = new FormAttachment((Control)this.fLengthText);
        data.left = new FormAttachment((Control)this.fFileText);
        fileButton.setLayoutData((Object)data);
        String textValue = this.fProperties.get("File");
        this.fFileText.setText(textValue != null ? textValue : "");
        textValue = this.fProperties.get("Start");
        this.fStartText.setText(textValue != null ? textValue : "0x0");
        textValue = this.fProperties.get("End");
        this.fEndText.setText(textValue != null ? textValue : "0x0");
        this.fLengthText.setText(this.getEndAddress().subtract(this.getStartAddress()).toString());
        fileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(parent.getShell(), 8192);
                dialog.setText(Messages.getString("PlainTextExporter.ChooseFile"));
                dialog.setFilterExtensions(new String[]{"*.*;*"});
                dialog.setFilterNames(new String[]{Messages.getString("Exporter.AllFiles")});
                dialog.setFileName(PlainTextExporter.this.fFileText.getText());
                dialog.open();
                String filename = dialog.getFileName();
                if (filename != null && filename.length() != 0) {
                    PlainTextExporter.this.fFileText.setText(String.valueOf(dialog.getFilterPath()) + File.separator + filename);
                }
                PlainTextExporter.this.validate();
            }
        });
        this.fStartText.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                boolean valid = true;
                try {
                    PlainTextExporter.this.getStartAddress();
                }
                catch (Exception exception) {
                    valid = false;
                }
                PlainTextExporter.this.fStartText.setForeground(valid ? Display.getDefault().getSystemColor(2) : Display.getDefault().getSystemColor(3));
                BigInteger endAddress = PlainTextExporter.this.getEndAddress();
                BigInteger startAddress = PlainTextExporter.this.getStartAddress();
                PlainTextExporter.this.fLengthText.setText(endAddress.subtract(startAddress).toString());
                PlainTextExporter.this.validate();
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        this.fEndText.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                try {
                    PlainTextExporter.this.getEndAddress();
                    PlainTextExporter.this.fEndText.setForeground(Display.getDefault().getSystemColor(2));
                    BigInteger endAddress = PlainTextExporter.this.getEndAddress();
                    BigInteger startAddress = PlainTextExporter.this.getStartAddress();
                    String lengthString = endAddress.subtract(startAddress).toString();
                    if (!PlainTextExporter.this.fLengthText.getText().equals(lengthString)) {
                        PlainTextExporter.this.fLengthText.setText(lengthString);
                    }
                }
                catch (Exception exception) {
                    PlainTextExporter.this.fEndText.setForeground(Display.getDefault().getSystemColor(3));
                }
                PlainTextExporter.this.validate();
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        this.fLengthText.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                try {
                    BigInteger length = PlainTextExporter.this.getLength();
                    PlainTextExporter.this.fLengthText.setForeground(Display.getDefault().getSystemColor(2));
                    BigInteger startAddress = PlainTextExporter.this.getStartAddress();
                    String endString = "0x" + startAddress.add(length).toString(16);
                    if (!PlainTextExporter.this.fEndText.getText().equals(endString)) {
                        PlainTextExporter.this.fEndText.setText(endString);
                    }
                }
                catch (Exception exception) {
                    PlainTextExporter.this.fLengthText.setForeground(Display.getDefault().getSystemColor(3));
                }
                PlainTextExporter.this.validate();
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        this.fFileText.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                PlainTextExporter.this.validate();
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        composite.pack();
        return composite;
    }

    public BigInteger getEndAddress() {
        String text = this.fEndText.getText();
        boolean hex = text.startsWith("0x");
        BigInteger endAddress = new BigInteger(hex ? text.substring(2) : text, hex ? 16 : 10);
        return endAddress;
    }

    public BigInteger getStartAddress() {
        String text = this.fStartText.getText();
        boolean hex = text.startsWith("0x");
        BigInteger startAddress = new BigInteger(hex ? text.substring(2) : text, hex ? 16 : 10);
        return startAddress;
    }

    public BigInteger getLength() {
        String text = this.fLengthText.getText();
        boolean hex = text.startsWith("0x");
        BigInteger lengthAddress = new BigInteger(hex ? text.substring(2) : text, hex ? 16 : 10);
        return lengthAddress;
    }

    public File getFile() {
        return new File(this.fFileText.getText());
    }

    private void validate() {
        boolean isValid = true;
        try {
            this.getEndAddress();
            this.getStartAddress();
            BigInteger length = this.getLength();
            if (length.compareTo(BigInteger.ZERO) <= 0) {
                isValid = false;
            }
            if (!this.getFile().getParentFile().exists()) {
                isValid = false;
            }
        }
        catch (Exception exception) {
            isValid = false;
        }
        this.fParentDialog.setValid(isValid);
    }

    public String getId() {
        return "PlainTextExporter";
    }

    public String getName() {
        return Messages.getString("PlainTextExporter.Name");
    }

    public void exportMemory() {
        Job job = new Job("Memory Export to Plain Text File"){

            public IStatus run(IProgressMonitor monitor) {
                try {
                    BigInteger CELLSIZE = BigInteger.valueOf(4L);
                    BigInteger COLUMNS = BigInteger.valueOf(5L);
                    BigInteger DATA_PER_LINE = CELLSIZE.multiply(COLUMNS);
                    BigInteger transferAddress = PlainTextExporter.this.fStartAddress;
                    FileWriter writer = new FileWriter(PlainTextExporter.this.fOutputFile);
                    BigInteger jobs = PlainTextExporter.this.fEndAddress.subtract(transferAddress).divide(DATA_PER_LINE);
                    BigInteger factor = BigInteger.ONE;
                    if (jobs.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) > 0) {
                        factor = jobs.divide(BigInteger.valueOf(Integer.MAX_VALUE));
                        jobs = jobs.divide(factor);
                    }
                    monitor.beginTask(Messages.getString("Exporter.ProgressTitle"), jobs.intValue());
                    BigInteger jobCount = BigInteger.ZERO;
                    while (transferAddress.compareTo(PlainTextExporter.this.fEndAddress) < 0 && !monitor.isCanceled()) {
                        BigInteger length = DATA_PER_LINE;
                        if (PlainTextExporter.this.fEndAddress.subtract(transferAddress).compareTo(length) < 0) {
                            length = PlainTextExporter.this.fEndAddress.subtract(transferAddress);
                        }
                        monitor.subTask(String.format(Messages.getString("Exporter.Progress"), length.toString(10), transferAddress.toString(16)));
                        StringBuffer buf = new StringBuffer();
                        int i = 0;
                        while (i < length.divide(CELLSIZE).intValue()) {
                            if (i != 0) {
                                buf.append(" ");
                            }
                            MemoryByte[] bytes = ((IMemoryBlockExtension)PlainTextExporter.this.fMemoryBlock).getBytesFromAddress(transferAddress.add(CELLSIZE.multiply(BigInteger.valueOf(i))), CELLSIZE.longValue() / (long)((IMemoryBlockExtension)PlainTextExporter.this.fMemoryBlock).getAddressableSize());
                            int byteIndex = 0;
                            while (byteIndex < bytes.length) {
                                String bString = BigInteger.valueOf(0xFF & bytes[byteIndex].getValue()).toString(16);
                                if (bString.length() == 1) {
                                    buf.append("0");
                                }
                                buf.append(bString);
                                ++byteIndex;
                            }
                            ++i;
                        }
                        writer.write(buf.toString().toUpperCase());
                        writer.write("\n");
                        transferAddress = transferAddress.add(length);
                        jobCount = jobCount.add(BigInteger.ONE);
                        if (jobCount.compareTo(factor) != 0) continue;
                        jobCount = BigInteger.ZERO;
                        monitor.worked(1);
                    }
                    writer.close();
                    monitor.done();
                }
                catch (IOException ex) {
                    MemoryTransportPlugin.getDefault().getLog().log((IStatus)new Status(4, MemoryTransportPlugin.getUniqueIdentifier(), 5012, Messages.getString("Exporter.ErrFile"), (Throwable)ex));
                    return new Status(4, MemoryTransportPlugin.getUniqueIdentifier(), 5012, Messages.getString("Exporter.ErrFile"), (Throwable)ex);
                }
                catch (DebugException ex) {
                    MemoryTransportPlugin.getDefault().getLog().log((IStatus)new Status(4, MemoryTransportPlugin.getUniqueIdentifier(), 5012, Messages.getString("Exporter.ErrReadTarget"), (Throwable)ex));
                    return new Status(4, MemoryTransportPlugin.getUniqueIdentifier(), 5012, Messages.getString("Exporter.ErrReadTarget"), (Throwable)ex);
                }
                catch (Exception ex) {
                    MemoryTransportPlugin.getDefault().getLog().log((IStatus)new Status(4, MemoryTransportPlugin.getUniqueIdentifier(), 5013, Messages.getString("Exporter.Falure"), (Throwable)ex));
                    return new Status(4, MemoryTransportPlugin.getUniqueIdentifier(), 5013, Messages.getString("Exporter.Falure"), (Throwable)ex);
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
    }
}

