/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.core.param;

import java.io.IOException;
import java.io.StreamTokenizer;
import org.eclipse.cdt.codan.core.model.CheckerLaunchMode;
import org.eclipse.cdt.codan.core.param.AbstractProblemPreference;
import org.eclipse.cdt.codan.core.param.BasicProblemPreference;
import org.eclipse.cdt.codan.core.param.IProblemPreference;
import org.eclipse.cdt.codan.core.param.IProblemPreferenceDescriptor;
import org.eclipse.cdt.codan.core.param.MapProblemPreference;

public class LaunchModeProblemPreference
extends MapProblemPreference {
    public static final String KEY = "launchModes";

    public String getKey() {
        return KEY;
    }

    public boolean isDefault() {
        CheckerLaunchMode[] values = CheckerLaunchMode.values();
        int i = 0;
        while (i < values.length) {
            CheckerLaunchMode checkerLaunchMode = values[i];
            if (this.getChildDescriptor(checkerLaunchMode.name()) != null) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public IProblemPreference addLaunchMode(CheckerLaunchMode checkerLaunchMode, boolean value) {
        BasicProblemPreference desc = new BasicProblemPreference(checkerLaunchMode.name(), checkerLaunchMode.name(), IProblemPreferenceDescriptor.PreferenceType.TYPE_BOOLEAN);
        IProblemPreference desc1 = this.addChildDescriptor(desc);
        desc1.setValue(value);
        return desc1;
    }

    public boolean isRunningInMode(CheckerLaunchMode mode) {
        if (this.getChildDescriptor(mode.name()) == null) {
            if (mode == CheckerLaunchMode.RUN_ON_INC_BUILD) {
                return this.isRunningInMode(CheckerLaunchMode.RUN_ON_FULL_BUILD);
            }
            return true;
        }
        Object value = this.getChildValue(mode.name());
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return false;
    }

    public void setRunningMode(CheckerLaunchMode mode, boolean value) {
        if (this.getChildDescriptor(mode.name()) == null) {
            this.addLaunchMode(mode, value);
        } else {
            this.setChildValue(mode.name(), value);
        }
    }

    public void enableInLaunchModes(CheckerLaunchMode ... modes) {
        CheckerLaunchMode mode;
        CheckerLaunchMode[] all = CheckerLaunchMode.values();
        int i = 0;
        while (i < all.length) {
            mode = all[i];
            if (this.getChildDescriptor(mode.name()) == null) {
                this.addLaunchMode(mode, false);
            }
            ++i;
        }
        i = 0;
        while (i < modes.length) {
            mode = modes[i];
            this.setChildValue(mode.name(), true);
            ++i;
        }
    }

    public boolean isAllEnabled() {
        return this.isRunningInMode(CheckerLaunchMode.RUN_AS_YOU_TYPE) && this.isRunningInMode(CheckerLaunchMode.RUN_ON_DEMAND) && this.isRunningInMode(CheckerLaunchMode.RUN_ON_FULL_BUILD);
    }

    public boolean isAllDisabled() {
        return !this.isRunningInMode(CheckerLaunchMode.RUN_AS_YOU_TYPE) && !this.isRunningInMode(CheckerLaunchMode.RUN_ON_DEMAND) && !this.isRunningInMode(CheckerLaunchMode.RUN_ON_FULL_BUILD);
    }

    protected IProblemPreference importChildValue(String key, StreamTokenizer tokenizer) throws IOException {
        IProblemPreference desc = this.getChildDescriptor(key);
        if (desc == null) {
            CheckerLaunchMode mode = CheckerLaunchMode.valueOf(key);
            if (mode == null) {
                throw new IllegalArgumentException(key);
            }
            desc = this.addLaunchMode(mode, true);
        }
        if (desc != null && desc instanceof AbstractProblemPreference) {
            ((AbstractProblemPreference)desc).importValue(tokenizer);
            this.setChildValue(key, desc.getValue());
        }
        return desc;
    }
}

