/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core;

import java.io.File;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.FileRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryCache {
    private final Map<File, Reference<Repository>> repositoryCache = new HashMap<File, Reference<Repository>>();

    RepositoryCache() {
    }

    public synchronized Repository lookupRepository(File gitDir) throws IOException {
        Repository d;
        Reference<Repository> r = this.repositoryCache.get(gitDir);
        Repository repository = d = r != null ? r.get() : null;
        if (d == null) {
            d = new FileRepository(gitDir);
            this.repositoryCache.put(gitDir, new WeakReference<Repository>(d));
        }
        RepositoryCache.prune(this.repositoryCache);
        return d;
    }

    public synchronized Repository[] getAllRepositories() {
        ArrayList<Repository> result = new ArrayList<Repository>();
        Collection<Reference<Repository>> values = this.repositoryCache.values();
        for (Reference<Repository> ref : values) {
            Repository repo = ref.get();
            if (repo == null) continue;
            result.add(repo);
        }
        return result.toArray(new Repository[result.size()]);
    }

    private static <K, V> void prune(Map<K, Reference<V>> map) {
        Iterator<Map.Entry<K, Reference<V>>> i = map.entrySet().iterator();
        while (i.hasNext()) {
            if (i.next().getValue().get() != null) continue;
            i.remove();
        }
    }

    public void clear() {
        this.repositoryCache.clear();
    }
}

