/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.op;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.CoreText;
import org.eclipse.egit.core.op.IEGitOperation;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.WorkingTreeIterator;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.osgi.util.NLS;

public class IgnoreOperation
implements IEGitOperation {
    private IResource[] resources;
    private boolean gitignoreOutsideWSChanged;
    private ISchedulingRule schedulingRule;

    public IgnoreOperation(IResource[] resources) {
        this.resources = new IResource[resources.length];
        System.arraycopy(resources, 0, this.resources, 0, resources.length);
        this.gitignoreOutsideWSChanged = false;
        this.schedulingRule = this.calcSchedulingRule();
    }

    public void execute(IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(CoreText.IgnoreOperation_taskName, this.resources.length);
        try {
            IResource[] iResourceArray = this.resources;
            int n = this.resources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                if (monitor.isCanceled()) break;
                if (!this.isIgnored(resource)) {
                    this.addIgnore(monitor, resource);
                }
                monitor.worked(1);
                ++n2;
            }
            monitor.done();
        }
        catch (CoreException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CoreException(Activator.error(CoreText.IgnoreOperation_error, e));
        }
    }

    private boolean isIgnored(IResource resource) throws IOException {
        RepositoryMapping mapping = RepositoryMapping.getMapping(resource);
        Repository repository = mapping.getRepository();
        String path = mapping.getRepoRelativePath(resource);
        TreeWalk walk = new TreeWalk(repository);
        walk.addTree((AbstractTreeIterator)new FileTreeIterator(repository));
        walk.setFilter((TreeFilter)PathFilter.create((String)path));
        while (walk.next()) {
            WorkingTreeIterator workingTreeIterator = (WorkingTreeIterator)walk.getTree(0, WorkingTreeIterator.class);
            if (walk.getPathString().equals(path)) {
                return workingTreeIterator.isEntryIgnored();
            }
            if (!workingTreeIterator.getEntryFileMode().equals(FileMode.TREE)) continue;
            walk.enterSubtree();
        }
        return false;
    }

    public boolean isGitignoreOutsideWSChanged() {
        return this.gitignoreOutsideWSChanged;
    }

    public ISchedulingRule getSchedulingRule() {
        return this.schedulingRule;
    }

    private void addIgnore(IProgressMonitor monitor, IResource resource) throws UnsupportedEncodingException, CoreException, IOException {
        IContainer container = resource.getParent();
        String entry = "/" + resource.getName() + "\n";
        if (container instanceof IWorkspaceRoot) {
            Repository repository = RepositoryMapping.getMapping((IResource)resource.getProject()).getRepository();
            IPath gitIgnorePath = resource.getLocation().removeLastSegments(1).append(".gitignore");
            Path repoPath = new Path(repository.getWorkTree().getAbsolutePath());
            if (!repoPath.isPrefixOf(gitIgnorePath)) {
                String message = NLS.bind((String)CoreText.IgnoreOperation_parentOutsideRepo, (Object)resource.getLocation().toOSString(), (Object)repoPath.toOSString());
                IStatus status = Activator.error(message, null);
                throw new CoreException(status);
            }
            File gitIgnore = new File(gitIgnorePath.toOSString());
            this.updateGitIgnore(gitIgnore, entry);
            this.gitignoreOutsideWSChanged = true;
        } else {
            IFile gitignore = container.getFile((IPath)new Path(".gitignore"));
            entry = this.getEntry(gitignore.getLocation().toFile(), entry);
            SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 1);
            ByteArrayInputStream entryBytes = this.asStream(entry);
            if (gitignore.exists()) {
                gitignore.appendContents((InputStream)entryBytes, true, true, (IProgressMonitor)subMonitor);
            } else {
                gitignore.create((InputStream)entryBytes, true, (IProgressMonitor)subMonitor);
            }
        }
    }

    private boolean prependNewline(File file) throws IOException {
        boolean prepend = false;
        long length = file.length();
        if (length > 0L) {
            RandomAccessFile raf = new RandomAccessFile(file, "r");
            try {
                ByteBuffer buffer = ByteBuffer.allocate(1);
                FileChannel channel = raf.getChannel();
                channel.position(length - 1L);
                if (channel.read(buffer) > 0) {
                    buffer.rewind();
                    prepend = buffer.get() != 10;
                }
            }
            finally {
                raf.close();
            }
        }
        return prepend;
    }

    private String getEntry(File file, String entry) throws IOException {
        return this.prependNewline(file) ? "\n" + entry : entry;
    }

    private void updateGitIgnore(File gitIgnore, String entry) throws CoreException {
        try {
            String ignoreLine = entry;
            if (!gitIgnore.exists()) {
                if (!gitIgnore.createNewFile()) {
                    String error = NLS.bind((String)CoreText.IgnoreOperation_creatingFailed, (Object)gitIgnore.getAbsolutePath());
                    throw new CoreException(Activator.error(error, null));
                }
                ignoreLine = this.getEntry(gitIgnore, ignoreLine);
            }
            FileOutputStream os = new FileOutputStream(gitIgnore, true);
            try {
                os.write(ignoreLine.getBytes());
            }
            finally {
                os.close();
            }
        }
        catch (IOException e) {
            String error = NLS.bind((String)CoreText.IgnoreOperation_updatingFailed, (Object)gitIgnore.getAbsolutePath());
            throw new CoreException(Activator.error(error, e));
        }
    }

    private ByteArrayInputStream asStream(String entry) throws UnsupportedEncodingException {
        return new ByteArrayInputStream(entry.getBytes("UTF-8"));
    }

    private ISchedulingRule calcSchedulingRule() {
        ArrayList<ISchedulingRule> rules = new ArrayList<ISchedulingRule>();
        IResourceRuleFactory ruleFactory = ResourcesPlugin.getWorkspace().getRuleFactory();
        IResource[] iResourceArray = this.resources;
        int n = this.resources.length;
        int n2 = 0;
        while (n2 < n) {
            ISchedulingRule rule;
            IResource resource = iResourceArray[n2];
            IContainer container = resource.getParent();
            if (!(container instanceof IWorkspaceRoot) && (rule = ruleFactory.modifyRule((IResource)container)) != null) {
                rules.add(rule);
            }
            ++n2;
        }
        if (rules.size() == 0) {
            return null;
        }
        return new MultiRule((ISchedulingRule[])rules.toArray(new IResource[rules.size()]));
    }
}

