/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.op;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.internal.job.RuleUtil;
import org.eclipse.egit.core.op.IEGitOperation;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.lib.Repository;

public class RemoveFromIndexOperation
implements IEGitOperation {
    private final Repository repo;
    private final Collection<String> paths;
    private final IResource[] resources;

    public RemoveFromIndexOperation(Repository repo, IResource[] resources) {
        this.repo = repo;
        this.resources = resources;
        this.paths = new ArrayList<String>();
        RepositoryMapping mapping = RepositoryMapping.findRepositoryMapping(repo);
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource res = iResourceArray[n2];
            this.paths.add(mapping.getRepoRelativePath(res));
            ++n2;
        }
    }

    public void execute(IProgressMonitor m) throws CoreException {
        Object monitor = m == null ? new NullProgressMonitor() : m;
        ResetCommand resetCommand = new Git(this.repo).reset();
        resetCommand.setRef("HEAD");
        monitor.worked(1);
        for (String path : this.paths) {
            resetCommand.addPath(path);
            monitor.worked(1);
        }
        try {
            try {
                resetCommand.call();
                monitor.worked(1);
            }
            catch (IOException e) {
                Activator.logError(e.getMessage(), e);
                monitor.done();
                RepositoryMapping.findRepositoryMapping(this.repo).fireRepositoryChanged();
            }
        }
        finally {
            monitor.done();
            RepositoryMapping.findRepositoryMapping(this.repo).fireRepositoryChanged();
        }
    }

    public ISchedulingRule getSchedulingRule() {
        return RuleUtil.getRuleForRepositories(this.resources);
    }
}

