/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.op;

import java.io.IOException;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.CoreText;
import org.eclipse.egit.core.internal.job.RuleUtil;
import org.eclipse.egit.core.op.IEGitOperation;
import org.eclipse.egit.core.project.GitProjectData;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.jgit.dircache.DirCacheEditor;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UntrackOperation
implements IEGitOperation {
    private final Collection<? extends IResource> rsrcList;
    private final IdentityHashMap<Repository, DirCacheEditor> edits;
    private final IdentityHashMap<RepositoryMapping, Object> mappings;

    public UntrackOperation(Collection<? extends IResource> rsrcs) {
        this.rsrcList = rsrcs;
        this.edits = new IdentityHashMap();
        this.mappings = new IdentityHashMap();
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @Override
    public void execute(IProgressMonitor m) throws CoreException {
        monitor /* !! */  = m == null ? new NullProgressMonitor() : m;
        this.edits.clear();
        this.mappings.clear();
        monitor /* !! */ .beginTask(CoreText.UntrackOperation_adding, this.rsrcList.size() * 200);
        try {
            try {
                for (IResource obj : this.rsrcList) {
                    this.remove(obj);
                    monitor /* !! */ .worked(200);
                }
                for (Map.Entry e : this.edits.entrySet()) {
                    db = (Repository)e.getKey();
                    editor = (DirCacheEditor)e.getValue();
                    monitor /* !! */ .setTaskName(NLS.bind((String)CoreText.UntrackOperation_writingIndex, (Object)db.getDirectory()));
                    editor.commit();
                }
            }
            catch (RuntimeException e) {
                throw new CoreException(Activator.error(CoreText.UntrackOperation_failed, e));
            }
            catch (IOException e) {
                throw new CoreException(Activator.error(CoreText.UntrackOperation_failed, e));
            }
        }
        finally {
            ** for (rm : this.mappings.keySet())
        }
lbl-1000:
        // 1 sources

        {
            rm.fireRepositoryChanged();
            continue;
        }
lbl27:
        // 3 sources

        for (DirCacheEditor editor : this.edits.values()) {
            if (editor.getDirCache() == null) continue;
            editor.getDirCache().unlock();
        }
        this.edits.clear();
        this.mappings.clear();
        monitor /* !! */ .done();
    }

    @Override
    public ISchedulingRule getSchedulingRule() {
        return RuleUtil.getRuleForRepositories(this.rsrcList.toArray(new IResource[this.rsrcList.size()]));
    }

    private void remove(IResource path) throws CoreException {
        IProject proj = path.getProject();
        GitProjectData pd = GitProjectData.get(proj);
        if (pd == null) {
            return;
        }
        RepositoryMapping rm = pd.getRepositoryMapping(path);
        if (rm == null) {
            return;
        }
        Repository db = rm.getRepository();
        DirCacheEditor e = this.edits.get(db);
        if (e == null) {
            try {
                e = db.lockDirCache().editor();
            }
            catch (IOException err) {
                throw new CoreException(Activator.error(CoreText.UntrackOperation_failed, err));
            }
            this.edits.put(db, e);
            this.mappings.put(rm, rm);
        }
        if (path instanceof IContainer) {
            e.add((DirCacheEditor.PathEdit)new DirCacheEditor.DeleteTree(rm.getRepoRelativePath(path)));
        } else {
            e.add((DirCacheEditor.PathEdit)new DirCacheEditor.DeletePath(rm.getRepoRelativePath(path)));
        }
    }
}

