/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.preferences;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.internal.ui.preferences.IPreferenceConfigurationBlock;
import org.eclipse.cdt.internal.ui.preferences.OverlayPreferenceStore;
import org.eclipse.cdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.cdt.internal.ui.text.folding.CFoldingStructureProviderDescriptor;
import org.eclipse.cdt.internal.ui.text.folding.CFoldingStructureProviderRegistry;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.text.folding.ICFoldingPreferenceBlock;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FoldingConfigurationBlock
implements IPreferenceConfigurationBlock {
    protected final OverlayPreferenceStore fStore;
    private Combo fProviderCombo;
    protected Button fFoldingCheckbox;
    private ComboViewer fProviderViewer;
    protected Map<String, CFoldingStructureProviderDescriptor> fProviderDescriptors;
    private Composite fGroup;
    private Map<String, ICFoldingPreferenceBlock> fProviderPreferences;
    private Map<String, Control> fProviderControls;
    private StackLayout fStackLayout;

    public FoldingConfigurationBlock(OverlayPreferenceStore store) {
        Assert.isNotNull((Object)store);
        this.fStore = store;
        this.fStore.addKeys(this.createOverlayStoreKeys());
        this.fProviderDescriptors = this.createListModel();
        this.fProviderPreferences = new HashMap<String, ICFoldingPreferenceBlock>();
        this.fProviderControls = new HashMap<String, Control>();
    }

    private Map<String, CFoldingStructureProviderDescriptor> createListModel() {
        CFoldingStructureProviderRegistry reg = CUIPlugin.getDefault().getFoldingStructureProviderRegistry();
        reg.reloadExtensions();
        CFoldingStructureProviderDescriptor[] descs = reg.getFoldingProviderDescriptors();
        HashMap<String, CFoldingStructureProviderDescriptor> map = new HashMap<String, CFoldingStructureProviderDescriptor>();
        int i = 0;
        while (i < descs.length) {
            map.put(descs[i].getId(), descs[i]);
            ++i;
        }
        return map;
    }

    private OverlayPreferenceStore.OverlayKey[] createOverlayStoreKeys() {
        ArrayList<OverlayPreferenceStore.OverlayKey> overlayKeys = new ArrayList<OverlayPreferenceStore.OverlayKey>();
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "editor_folding_enabled"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "editor_folding_provider"));
        OverlayPreferenceStore.OverlayKey[] keys = new OverlayPreferenceStore.OverlayKey[overlayKeys.size()];
        overlayKeys.toArray(keys);
        return keys;
    }

    @Override
    public Control createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gd = new GridData(80);
        composite.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        PixelConverter pc = new PixelConverter((Control)composite);
        layout.verticalSpacing = pc.convertHeightInCharsToPixels(1) / 2;
        composite.setLayout((Layout)layout);
        this.fFoldingCheckbox = new Button(composite, 32);
        this.fFoldingCheckbox.setText(PreferencesMessages.FoldingConfigurationBlock_enable);
        gd = new GridData(34);
        this.fFoldingCheckbox.setLayoutData((Object)gd);
        this.fFoldingCheckbox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                boolean enabled = FoldingConfigurationBlock.this.fFoldingCheckbox.getSelection();
                FoldingConfigurationBlock.this.fStore.setValue("editor_folding_enabled", enabled);
                FoldingConfigurationBlock.this.updateCheckboxDependencies();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Label label = new Label(composite, 0x1000000);
        gd = new GridData(770);
        label.setLayoutData((Object)gd);
        Composite comboComp = new Composite(composite, 0);
        gd = new GridData(770);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        comboComp.setLayout((Layout)gridLayout);
        Label comboLabel = new Label(comboComp, 0x1000000);
        gd = new GridData(36);
        comboLabel.setLayoutData((Object)gd);
        comboLabel.setText(PreferencesMessages.FoldingConfigurationBlock_combo_caption);
        label = new Label(composite, 0x1000000);
        gd = new GridData(770);
        label.setLayoutData((Object)gd);
        this.fProviderCombo = new Combo(comboComp, 12);
        gd = new GridData(132);
        this.fProviderCombo.setLayoutData((Object)gd);
        this.fProviderViewer = new ComboViewer(this.fProviderCombo);
        this.fProviderViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getElements(Object inputElement) {
                return FoldingConfigurationBlock.this.fProviderDescriptors.values().toArray();
            }
        });
        this.fProviderViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                return null;
            }

            public String getText(Object element) {
                return ((CFoldingStructureProviderDescriptor)element).getName();
            }
        });
        this.fProviderViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                if (!sel.isEmpty()) {
                    FoldingConfigurationBlock.this.fStore.setValue("editor_folding_provider", ((CFoldingStructureProviderDescriptor)sel.getFirstElement()).getId());
                    FoldingConfigurationBlock.this.updateListDependencies();
                }
            }
        });
        this.fProviderViewer.setInput(this.fProviderDescriptors);
        this.fProviderViewer.refresh();
        Composite groupComp = new Composite(composite, 0);
        gd = new GridData(1808);
        gd.horizontalSpan = 2;
        groupComp.setLayoutData((Object)gd);
        gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        groupComp.setLayout((Layout)gridLayout);
        this.fGroup = new Composite(groupComp, 0);
        gd = new GridData(34);
        this.fGroup.setLayoutData((Object)gd);
        this.fStackLayout = new StackLayout();
        this.fGroup.setLayout((Layout)this.fStackLayout);
        return composite;
    }

    protected void updateCheckboxDependencies() {
    }

    void updateListDependencies() {
        ICFoldingPreferenceBlock prefs;
        String id = this.fStore.getString("editor_folding_provider");
        CFoldingStructureProviderDescriptor desc = this.fProviderDescriptors.get(id);
        if (desc == null) {
            String message = PreferencesMessages.FoldingConfigurationBlock_error_not_exist;
            CUIPlugin.log((IStatus)new Status(2, CUIPlugin.getPluginId(), 0, message, null));
            prefs = new ErrorPreferences(message);
        } else {
            prefs = this.fProviderPreferences.get(id);
            if (prefs == null) {
                try {
                    prefs = desc.createPreferences();
                    this.fProviderPreferences.put(id, prefs);
                }
                catch (CoreException e) {
                    CUIPlugin.log(e);
                    prefs = new ErrorPreferences(e.getLocalizedMessage());
                }
            }
        }
        Control control = this.fProviderControls.get(id);
        if (control == null) {
            control = prefs.createControl(this.fGroup);
            if (control == null) {
                String message = PreferencesMessages.FoldingConfigurationBlock_info_no_preferences;
                control = new ErrorPreferences(message).createControl(this.fGroup);
            } else {
                this.fProviderControls.put(id, control);
            }
        }
        this.fStackLayout.topControl = control;
        control.pack();
        this.fGroup.layout();
        this.fGroup.getParent().layout();
        prefs.initialize();
    }

    @Override
    public void initialize() {
        this.restoreFromPreferences();
    }

    @Override
    public void performOk() {
        for (ICFoldingPreferenceBlock prefs : this.fProviderPreferences.values()) {
            prefs.performOk();
        }
    }

    @Override
    public void performDefaults() {
        this.restoreFromPreferences();
        for (ICFoldingPreferenceBlock prefs : this.fProviderPreferences.values()) {
            prefs.performDefaults();
        }
    }

    @Override
    public void dispose() {
        for (ICFoldingPreferenceBlock prefs : this.fProviderPreferences.values()) {
            prefs.dispose();
        }
    }

    private void restoreFromPreferences() {
        boolean enabled = this.fStore.getBoolean("editor_folding_enabled");
        this.fFoldingCheckbox.setSelection(enabled);
        this.updateCheckboxDependencies();
        String id = this.fStore.getString("editor_folding_provider");
        CFoldingStructureProviderDescriptor provider = this.fProviderDescriptors.get(id);
        if (provider != null) {
            this.fProviderViewer.setSelection((ISelection)new StructuredSelection((Object)provider), true);
            this.updateListDependencies();
        }
    }

    private static class ErrorPreferences
    implements ICFoldingPreferenceBlock {
        private String fMessage;

        protected ErrorPreferences(String message) {
            this.fMessage = message;
        }

        public Control createControl(Composite composite) {
            Composite inner = new Composite(composite, 0);
            inner.setLayout((Layout)new FillLayout(512));
            Label label = new Label(inner, 0x1000000);
            label.setText(this.fMessage);
            return inner;
        }

        public void initialize() {
        }

        public void performOk() {
        }

        public void performDefaults() {
        }

        public void dispose() {
        }
    }
}

