/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.extractfunction;

import java.util.ArrayList;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.internal.ui.refactoring.NodeContainer;
import org.eclipse.cdt.internal.ui.refactoring.extractfunction.ExtractFunctionInformation;
import org.eclipse.cdt.internal.ui.refactoring.extractfunction.ExtractFunctionInputPage;
import org.eclipse.cdt.internal.ui.refactoring.extractfunction.Messages;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChooserComposite
extends Composite {
    private static final String COLUMN_RETURN = Messages.ChooserComposite_Return;
    private static final String COLUMN_REFERENCE = Messages.ChooserComposite_CallByRef;
    private static final String COLUMN_NAME = Messages.ChooserComposite_Name;
    private static final String COLUMN_TYPE = Messages.ChooserComposite_Type;
    private Button voidReturn;
    private final ExtractFunctionInputPage ip;

    public ChooserComposite(Composite parent, final ExtractFunctionInformation info, ExtractFunctionInputPage ip) {
        super(parent, 0);
        this.ip = ip;
        GridLayout layout = new GridLayout();
        this.setLayout((Layout)layout);
        boolean hasNoPredefinedReturnValue = true;
        if (info.getInScopeDeclaredVariable() != null) {
            hasNoPredefinedReturnValue = false;
        }
        final ArrayList<Button> returnButtons = new ArrayList<Button>();
        ArrayList<Button> referenceButtons = new ArrayList<Button>();
        Table table = new Table(parent, 2054);
        GridData tableLayoutData = new GridData(4, 4, true, true);
        table.setLayoutData((Object)tableLayoutData);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        this.addColumnToTable(table, COLUMN_TYPE);
        this.addColumnToTable(table, COLUMN_NAME);
        this.addColumnToTable(table, COLUMN_REFERENCE);
        this.addColumnToTable(table, Messages.ChooserComposite_const);
        if (!info.isExtractExpression()) {
            this.addColumnToTable(table, COLUMN_RETURN);
        }
        this.addColumnToTable(table, "");
        int i = 0;
        while (i < info.getAllUsedNames().size()) {
            if (!info.getAllUsedNames().get(i).isDeclarationInScope()) {
                TableItem item = new TableItem(table, 0);
                TableEditor editor = new TableEditor(table);
                int columnIndex = 0;
                final NodeContainer.NameInformation name = info.getAllUsedNames().get(i);
                item.setText(columnIndex++, name.getType());
                item.setText(columnIndex++, name.getName().toString());
                editor = new TableEditor(table);
                final Button referenceButton = new Button((Composite)table, 32);
                if (name.hasReferenceOperartor((IASTDeclarator)name.getDeclaration().getParent())) {
                    referenceButton.setSelection(true);
                    referenceButton.setEnabled(false);
                } else {
                    referenceButton.setSelection(name.isReference());
                }
                referenceButton.setBackground(table.getBackground());
                referenceButton.addSelectionListener(new SelectionListener(){

                    public void widgetDefaultSelected(SelectionEvent e) {
                        name.setUserSetIsReference(referenceButton.getSelection());
                        ChooserComposite.this.onVisibilityOrReturnChange(info.getAllUsedNames());
                    }

                    public void widgetSelected(SelectionEvent e) {
                        this.widgetDefaultSelected(e);
                    }
                });
                referenceButton.pack();
                editor.minimumWidth = referenceButton.getSize().x;
                editor.horizontalAlignment = 0x1000000;
                referenceButtons.add(referenceButton);
                editor.setEditor((Control)referenceButton, item, columnIndex++);
                editor = new TableEditor(table);
                final Button constButton = new Button((Composite)table, 32);
                constButton.setSelection(name.isConst());
                constButton.setEnabled(!name.isWriteAccess());
                constButton.setBackground(table.getBackground());
                constButton.addSelectionListener(new SelectionListener(){

                    public void widgetDefaultSelected(SelectionEvent e) {
                        name.setConst(constButton.getSelection());
                        ChooserComposite.this.onVisibilityOrReturnChange(info.getAllUsedNames());
                    }

                    public void widgetSelected(SelectionEvent e) {
                        this.widgetDefaultSelected(e);
                    }
                });
                constButton.pack();
                editor.minimumWidth = constButton.getSize().x;
                editor.horizontalAlignment = 0x1000000;
                editor.setEditor((Control)constButton, item, columnIndex++);
                if (!info.isExtractExpression()) {
                    editor = new TableEditor(table);
                    final Button returnButton = new Button((Composite)table, 16);
                    returnButton.setSelection(name.isReturnValue());
                    name.setUserSetIsReference(name.isReference());
                    returnButton.setEnabled(hasNoPredefinedReturnValue);
                    returnButton.setBackground(table.getBackground());
                    returnButton.addSelectionListener(new SelectionListener(){

                        public void widgetDefaultSelected(SelectionEvent e) {
                            name.setUserSetIsReturnValue(returnButton.getSelection());
                            if (returnButton.getSelection()) {
                                referenceButton.setSelection(false);
                                referenceButton.notifyListeners(13, new Event());
                            } else if (name.isReference()) {
                                referenceButton.setSelection(true);
                                referenceButton.notifyListeners(13, new Event());
                            }
                            ChooserComposite.this.onVisibilityOrReturnChange(info.getAllUsedNames());
                        }

                        public void widgetSelected(SelectionEvent e) {
                            this.widgetDefaultSelected(e);
                        }
                    });
                    returnButton.pack();
                    editor.minimumWidth = returnButton.getSize().x;
                    editor.horizontalAlignment = 0x1000000;
                    returnButtons.add(returnButton);
                    editor.setEditor((Control)returnButton, item, columnIndex++);
                }
            }
            ++i;
        }
        if (!info.isExtractExpression()) {
            this.voidReturn = new Button(parent, 16416);
            this.voidReturn.setText(Messages.ChooserComposite_NoReturnValue);
            this.voidReturn.setEnabled(hasNoPredefinedReturnValue);
            this.voidReturn.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    info.setReturnVariable(null);
                    for (Button button : returnButtons) {
                        if (ChooserComposite.this.voidReturn.getSelection()) {
                            button.setSelection(false);
                            button.notifyListeners(13, new Event());
                        }
                        button.setEnabled(!ChooserComposite.this.voidReturn.getSelection());
                    }
                }

                public void widgetSelected(SelectionEvent e) {
                    this.widgetDefaultSelected(e);
                }
            });
        }
        this.layout();
    }

    private void addColumnToTable(Table table, String string) {
        TableColumn column = new TableColumn(table, 0);
        column.setText(string);
        column.setWidth(100);
    }

    void onVisibilityOrReturnChange(ArrayList<NodeContainer.NameInformation> name) {
        String variableUsedAfterBlock = null;
        for (NodeContainer.NameInformation information : name) {
            if (!information.isUsedAfterReferences() || information.isUserSetIsReference() || information.isUserSetIsReturnValue()) continue;
            variableUsedAfterBlock = information.getName().toString();
        }
        this.ip.errorWithAfterUsedVariable(variableUsedAfterBlock);
    }
}

