/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.togglefunction;

import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.INodeFactory;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCatchHandler;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionWithTryBlock;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNamespaceDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateDeclaration;
import org.eclipse.cdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.cdt.internal.ui.refactoring.ModificationCollector;
import org.eclipse.cdt.internal.ui.refactoring.togglefunction.IToggleRefactoringStrategy;
import org.eclipse.cdt.internal.ui.refactoring.togglefunction.InsertionPointFinder;
import org.eclipse.cdt.internal.ui.refactoring.togglefunction.Messages;
import org.eclipse.cdt.internal.ui.refactoring.togglefunction.NotSupportedException;
import org.eclipse.cdt.internal.ui.refactoring.togglefunction.ToggleNodeHelper;
import org.eclipse.cdt.internal.ui.refactoring.togglefunction.ToggleRefactoringContext;
import org.eclipse.text.edits.TextEditGroup;

public class ToggleFromClassToInHeaderStrategy
implements IToggleRefactoringStrategy {
    protected TextEditGroup infoText = new TextEditGroup(Messages.EditGroupName);
    private ToggleRefactoringContext context;

    public ToggleFromClassToInHeaderStrategy(ToggleRefactoringContext context) {
        if (this.isInClass((IASTNode)context.getDeclaration()) && this.isInClass((IASTNode)context.getDefinition())) {
            throw new NotSupportedException(Messages.ToggleFromClassToInHeaderStrategy_DefAndDecInsideClass);
        }
        this.context = context;
    }

    private boolean isInClass(IASTNode node) {
        return ToggleNodeHelper.getAncestorOfType(node, ICPPASTCompositeTypeSpecifier.class) != null;
    }

    public void run(ModificationCollector modifications) {
        IASTNode parentNamespace = this.getParentNamespace();
        IASTNode newDefinition = this.getNewDefinition(parentNamespace);
        IASTSimpleDeclaration newDeclaration = this.getNewDeclaration();
        ASTRewrite rewriter = this.replaceDefinitionWithDeclaration(modifications, newDeclaration);
        IASTNode insertion_point = this.getInsertionPoint(parentNamespace);
        rewriter.insertBefore(parentNamespace, insertion_point, newDefinition, this.infoText);
    }

    private IASTNode getNewDefinition(IASTNode parentNamespace) {
        ICPPASTTemplateDeclaration templdecl;
        IASTFunctionDefinition newDefinition = ToggleNodeHelper.getQualifiedNameDefinition(this.context.getDefinition(), this.context.getDefinitionUnit(), parentNamespace);
        newDefinition.setBody(this.context.getDefinition().getBody().copy(IASTNode.CopyStyle.withLocations));
        if (newDefinition instanceof ICPPASTFunctionWithTryBlock) {
            ICPPASTFunctionWithTryBlock newTryFun = (ICPPASTFunctionWithTryBlock)newDefinition;
            ICPPASTFunctionWithTryBlock oldTryFun = (ICPPASTFunctionWithTryBlock)this.context.getDefinition();
            ICPPASTCatchHandler[] iCPPASTCatchHandlerArray = oldTryFun.getCatchHandlers();
            int n = iCPPASTCatchHandlerArray.length;
            int n2 = 0;
            while (n2 < n) {
                ICPPASTCatchHandler catchH = iCPPASTCatchHandlerArray[n2];
                newTryFun.addCatchHandler(catchH.copy(IASTNode.CopyStyle.withLocations));
                ++n2;
            }
        }
        if ((templdecl = ToggleNodeHelper.getTemplateDeclaration(this.context.getDefinition(), newDefinition)) != null) {
            newDefinition = templdecl;
        }
        newDefinition.setParent((IASTNode)this.context.getDefinitionUnit());
        return newDefinition;
    }

    private IASTNode getParentNamespace() {
        IASTNode parentNamespace = (IASTNode)ToggleNodeHelper.getAncestorOfType((IASTNode)this.context.getDefinition(), ICPPASTNamespaceDefinition.class);
        if (parentNamespace == null) {
            parentNamespace = this.context.getDefinitionUnit();
        }
        return parentNamespace;
    }

    private IASTNode getInsertionPoint(IASTNode parentNamespace) {
        IASTTranslationUnit unit = parentNamespace.getTranslationUnit();
        IASTDeclaration insertion_point = InsertionPointFinder.findInsertionPoint(unit, unit, this.context.getDefinition().getDeclarator());
        return insertion_point;
    }

    private ASTRewrite replaceDefinitionWithDeclaration(ModificationCollector modifications, IASTSimpleDeclaration newDeclaration) {
        ASTRewrite rewriter = modifications.rewriterForTranslationUnit(this.context.getDefinitionUnit());
        rewriter.replace((IASTNode)this.context.getDefinition(), (IASTNode)newDeclaration, this.infoText);
        return rewriter;
    }

    private IASTSimpleDeclaration getNewDeclaration() {
        INodeFactory factory = this.context.getDefinitionUnit().getASTNodeFactory();
        IASTDeclSpecifier newDeclSpecifier = this.context.getDefinition().getDeclSpecifier().copy(IASTNode.CopyStyle.withLocations);
        newDeclSpecifier.setInline(false);
        IASTSimpleDeclaration newDeclaration = factory.newSimpleDeclaration(newDeclSpecifier);
        IASTFunctionDeclarator newDeclarator = this.context.getDefinition().getDeclarator().copy(IASTNode.CopyStyle.withLocations);
        newDeclaration.addDeclarator((IASTDeclarator)newDeclarator);
        newDeclaration.setParent(this.context.getDefinition().getParent());
        return newDeclaration;
    }
}

