/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.resources;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.cdt.core.resources.ExclusionInstance;
import org.eclipse.cdt.core.resources.ExclusionType;
import org.eclipse.cdt.core.resources.RefreshExclusion;
import org.eclipse.cdt.internal.core.resources.ResourceExclusion;
import org.eclipse.cdt.ui.resources.Messages;
import org.eclipse.cdt.ui.resources.RefreshExclusionContributor;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.CheckedTreeSelectionDialog;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class ResourceExclusionContributor
extends RefreshExclusionContributor {
    public RefreshExclusion createExclusion() {
        ResourceExclusion newExclusion = new ResourceExclusion();
        newExclusion.setContributorId(this.getID());
        newExclusion.setExclusionType(ExclusionType.FOLDER);
        return newExclusion;
    }

    public void createProperiesUI(Composite parent, final RefreshExclusion exclusion) {
        final Shell shell = parent.getShell();
        Group g = new Group(parent, 0);
        g.setText(Messages.RefreshPolicyExceptionDialog_exceptionTypeResources);
        g.setLayout((Layout)new GridLayout(1, false));
        GridData gridData = new GridData(1808);
        gridData.verticalAlignment = 4;
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 2;
        g.setLayoutData((Object)gridData);
        final org.eclipse.swt.widgets.List exceptionsList = new org.eclipse.swt.widgets.List((Composite)g, 0);
        gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.verticalSpan = 2;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.minimumHeight = 250;
        gridData.minimumWidth = 275;
        exceptionsList.setLayoutData((Object)gridData);
        final LinkedHashMap<String, ExclusionInstance> exclusionInstanceStrings = new LinkedHashMap<String, ExclusionInstance>();
        final LinkedHashMap<String, IResource> exclusionInstanceResources = new LinkedHashMap<String, IResource>();
        List exclusionInstances = exclusion.getExclusionInstances();
        if (exclusionInstances != null) {
            for (ExclusionInstance exclusionInstance : exclusionInstances) {
                String name = exclusionInstance.getDisplayString();
                exceptionsList.add(name);
                exclusionInstanceStrings.put(name, exclusionInstance);
                exclusionInstanceResources.put(name, exclusionInstance.getResource());
            }
        }
        Composite buttonComp = new Composite(parent, 0);
        buttonComp.setLayout((Layout)new GridLayout(1, false));
        gridData = new GridData(1808);
        gridData.minimumWidth = 100;
        buttonComp.setLayoutData((Object)gridData);
        Button addButton = new Button(buttonComp, 0);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        addButton.setLayoutData((Object)gridData);
        addButton.setText(Messages.RefreshPolicyExceptionDialog_addButtonLabel);
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CheckedTreeSelectionDialog dialog = new CheckedTreeSelectionDialog(shell, WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider(), new ITreeContentProvider(){

                    public void dispose() {
                    }

                    public Object[] getChildren(Object parentElement) {
                        IContainer container;
                        if (parentElement instanceof IContainer && (container = (IContainer)parentElement).isAccessible()) {
                            try {
                                ArrayList<IResource> children = new ArrayList<IResource>();
                                IResource[] members = container.members();
                                int i = 0;
                                while (i < members.length) {
                                    if (members[i].getType() == 2) {
                                        children.add(members[i]);
                                    }
                                    ++i;
                                }
                                return children.toArray();
                            }
                            catch (CoreException coreException) {}
                        }
                        return new Object[0];
                    }

                    public Object[] getElements(Object inputElement) {
                        return this.getChildren(inputElement);
                    }

                    public Object getParent(Object element) {
                        if (element instanceof IResource) {
                            return ((IResource)element).getParent();
                        }
                        return null;
                    }

                    public boolean hasChildren(Object element) {
                        return this.getChildren(element).length > 0;
                    }

                    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                    }
                });
                dialog.setInput((Object)ResourceExclusionContributor.this.getResourceRoot(exclusion));
                if (exclusionInstanceResources.values().size() > 0) {
                    dialog.setInitialElementSelections(Arrays.asList(exclusionInstanceResources.values().toArray()));
                }
                dialog.setMessage(Messages.RefreshPolicyExceptionDialog_SelectResourceDialogMessage);
                dialog.setTitle(Messages.RefreshPolicyExceptionDialog_SelectResourceDialogTitle);
                if (dialog.open() == 0) {
                    Object[] selection = dialog.getResult();
                    exceptionsList.removeAll();
                    exclusionInstanceResources.clear();
                    LinkedHashMap oldExclusionInstanceStrings = new LinkedHashMap(exclusionInstanceStrings);
                    exclusionInstanceStrings.clear();
                    int i = 0;
                    while (i < selection.length) {
                        Object selected = selection[i];
                        if (selected instanceof IFolder) {
                            IPath path = ((IFolder)selected).getFullPath();
                            IPath relativePath = path.makeRelativeTo(ResourceExclusionContributor.this.getResourceRoot(exclusion).getFullPath());
                            exceptionsList.add(relativePath.toString());
                            ExclusionInstance instance = (ExclusionInstance)((HashMap)oldExclusionInstanceStrings).get(relativePath.toString());
                            if (instance == null) {
                                instance = new ExclusionInstance();
                                instance.setExclusionType(ExclusionType.FOLDER);
                                instance.setParentExclusion(exclusion);
                                instance.setResource((IResource)selected);
                                instance.setDisplayString(relativePath.toString());
                                exclusion.addExclusionInstance(instance);
                            } else {
                                oldExclusionInstanceStrings.remove(relativePath.toString());
                            }
                            exclusionInstanceStrings.put(instance.getDisplayString(), instance);
                            exclusionInstanceResources.put(instance.getDisplayString(), selected);
                        }
                        ++i;
                    }
                    ((HashMap)oldExclusionInstanceStrings).keySet();
                    Iterator iterator = ((HashMap)oldExclusionInstanceStrings).keySet().iterator();
                    while (iterator.hasNext()) {
                        String toRemove = (String)iterator.next();
                        ExclusionInstance instanceToRemove = (ExclusionInstance)((HashMap)oldExclusionInstanceStrings).get(toRemove);
                        exclusion.removeExclusionInstance(instanceToRemove);
                        iterator.remove();
                    }
                }
            }
        });
        Button deleteButton = new Button(buttonComp, 0);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        deleteButton.setLayoutData((Object)gridData);
        deleteButton.setText(Messages.RefreshPolicyExceptionDialog_deleteButtonLabel);
        deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String[] selected = exceptionsList.getSelection();
                if (selected.length < 1) {
                    return;
                }
                int i = 0;
                while (i < selected.length) {
                    String folderToRemove = selected[i];
                    ExclusionInstance instanceToRemove = (ExclusionInstance)exclusionInstanceStrings.get(folderToRemove);
                    exclusion.removeExclusionInstance(instanceToRemove);
                    exclusionInstanceStrings.remove(folderToRemove);
                    exclusionInstanceResources.remove(folderToRemove);
                    ++i;
                }
                exceptionsList.remove(exceptionsList.getSelectionIndices());
            }
        });
    }

    private IResource getResourceRoot(RefreshExclusion exclusion) {
        if (exclusion.getParentExclusion() != null) {
            return this.getResourceRoot(exclusion.getParentExclusion());
        }
        return exclusion.getParentResource();
    }
}

