/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.ui.CHelpProviderManager;
import org.eclipse.cdt.internal.ui.CUIMessages;
import org.eclipse.cdt.internal.ui.text.CHelpBookDescriptor;
import org.eclipse.cdt.internal.ui.util.ImageDescriptorRegistry;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.CheckedListDialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.cdt.ui.CDTSharedImages;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.text.ICHelpInvocationContext;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.dialogs.PropertyPage;

public class CHelpConfigurationPropertyPage
extends PropertyPage
implements IWorkbenchPreferencePage {
    private CHelpSettingsDisplay fCHelpSettingsDisplay;

    protected Control createContents(Composite parent) {
        this.fCHelpSettingsDisplay = new CHelpSettingsDisplay();
        this.fCHelpSettingsDisplay.init(this.getResource());
        return this.fCHelpSettingsDisplay.createControl(parent);
    }

    private IResource getResource() {
        IAdaptable element = this.getElement();
        if (element instanceof IResource) {
            return (IResource)element;
        }
        return (IResource)element.getAdapter(IResource.class);
    }

    public boolean performOk() {
        this.fCHelpSettingsDisplay.performOk();
        super.performOk();
        return true;
    }

    public void init(IWorkbench workbench) {
    }

    private class CHelpBookListLabelProvider
    extends LabelProvider {
        private ImageDescriptor fHelpProviderIcon;
        private ImageDescriptorRegistry fRegistry = CUIPlugin.getImageDescriptorRegistry();

        public CHelpBookListLabelProvider() {
            this.fHelpProviderIcon = CDTSharedImages.getImageDescriptor("icons/obj16/lib_obj.gif");
        }

        public String getText(Object element) {
            if (element instanceof CHelpBookDescriptor) {
                return ((CHelpBookDescriptor)element).getCHelpBook().getTitle();
            }
            return super.getText(element);
        }

        public Image getImage(Object element) {
            if (element instanceof CHelpBookDescriptor) {
                return this.fRegistry.get(this.fHelpProviderIcon);
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CHelpSettingsDisplay {
        private CheckedListDialogField<CHelpBookDescriptor> fCHelpBookList;
        private IProject fProject;
        private CHelpBookDescriptor[] fCHelpBookDescriptors;

        public CHelpSettingsDisplay() {
            String[] buttonLabels = new String[]{CUIMessages.CHelpConfigurationPropertyPage_buttonLabels_CheckAll, CUIMessages.CHelpConfigurationPropertyPage_buttonLabels_UncheckAll};
            this.fCHelpBookList = new CheckedListDialogField(null, buttonLabels, (IBaseLabelProvider)new CHelpBookListLabelProvider());
            this.fCHelpBookList.setLabelText(CUIMessages.CHelpConfigurationPropertyPage_HelpBooks);
            this.fCHelpBookList.setCheckAllButtonIndex(0);
            this.fCHelpBookList.setUncheckAllButtonIndex(1);
        }

        public Control createControl(Composite parent) {
            PixelConverter converter = new PixelConverter((Control)parent);
            Composite composite = new Composite(parent, 0);
            LayoutUtil.doDefaultLayout(composite, new DialogField[]{this.fCHelpBookList}, true);
            LayoutUtil.setHorizontalGrabbing(this.fCHelpBookList.getListControl(null), true);
            int buttonBarWidth = converter.convertWidthInCharsToPixels(24);
            this.fCHelpBookList.setButtonsMinWidth(buttonBarWidth);
            return composite;
        }

        public void init(final IResource resource) {
            if (!(resource instanceof IProject)) {
                return;
            }
            this.fProject = (IProject)resource;
            this.fCHelpBookDescriptors = CHelpProviderManager.getDefault().getCHelpBookDescriptors(new ICHelpInvocationContext(){

                public IProject getProject() {
                    return (IProject)resource;
                }

                public ITranslationUnit getTranslationUnit() {
                    return null;
                }
            });
            List<CHelpBookDescriptor> allTopicsList = Arrays.asList(this.fCHelpBookDescriptors);
            List<CHelpBookDescriptor> enabledTopicsList = this.getEnabledEntries(allTopicsList);
            this.fCHelpBookList.setElements(allTopicsList);
            this.fCHelpBookList.setCheckedElements(enabledTopicsList);
        }

        private List<CHelpBookDescriptor> getEnabledEntries(List<CHelpBookDescriptor> list) {
            int size = list.size();
            ArrayList<CHelpBookDescriptor> desList = new ArrayList<CHelpBookDescriptor>();
            int i = 0;
            while (i < size) {
                CHelpBookDescriptor el = list.get(i);
                if (el.isEnabled()) {
                    desList.add(el);
                }
                ++i;
            }
            return desList;
        }

        public void performOk() {
            List list = this.fCHelpBookList.getElements();
            final IProject project = this.fProject;
            int i = 0;
            while (i < list.size()) {
                Object obj = list.get(i);
                if (obj != null && obj instanceof CHelpBookDescriptor) {
                    ((CHelpBookDescriptor)obj).enable(this.fCHelpBookList.isChecked(obj));
                }
                ++i;
            }
            CHelpProviderManager.getDefault().serialize(new ICHelpInvocationContext(){

                public IProject getProject() {
                    return project;
                }

                public ITranslationUnit getTranslationUnit() {
                    return null;
                }
            });
        }
    }
}

