/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.launch;

import java.io.IOException;
import java.util.HashSet;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.CoreModelUtil;
import org.eclipse.cdt.core.settings.model.ICConfigExtensionReference;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICOutputEntry;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.extension.CBuildData;
import org.eclipse.cdt.core.settings.model.extension.CConfigurationData;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.cdt.internal.core.resources.ResourceLookup;
import org.eclipse.cdt.utils.CommandLineUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.IActivityManager;
import org.eclipse.ui.activities.IWorkbenchActivitySupport;

public class LaunchUtils {
    public static String[] getProgramArgumentsArray(ILaunchConfiguration config) throws CoreException {
        return LaunchUtils.parseArguments(LaunchUtils.getProgramArguments(config));
    }

    public static String getProgramArguments(ILaunchConfiguration config) throws CoreException {
        String args = config.getAttribute("org.eclipse.cdt.launch.PROGRAM_ARGUMENTS", null);
        if (args != null) {
            args = LaunchUtils.getStringVariableManager().performStringSubstitution(args);
        }
        return args;
    }

    public static IBinaryParser.IBinaryObject getBinary(IProject project, IPath exePath) throws CoreException {
        ICConfigExtensionReference[] parserRef = CCorePlugin.getDefault().getDefaultBinaryParserExtensions(project);
        int i = 0;
        while (i < parserRef.length) {
            try {
                IBinaryParser parser = CoreModelUtil.getBinaryParser((ICConfigExtensionReference)parserRef[i]);
                IBinaryParser.IBinaryObject exe = (IBinaryParser.IBinaryObject)parser.getBinary(exePath);
                if (exe != null) {
                    return exe;
                }
            }
            catch (ClassCastException classCastException) {
            }
            catch (IOException iOException) {}
            ++i;
        }
        IBinaryParser parser = CCorePlugin.getDefault().getDefaultBinaryParser();
        try {
            IBinaryParser.IBinaryObject exe = (IBinaryParser.IBinaryObject)parser.getBinary(exePath);
            return exe;
        }
        catch (ClassCastException classCastException) {
        }
        catch (IOException iOException) {}
        return null;
    }

    public static IBinaryParser.IBinaryObject getBinary(String programName, String projectName) throws CoreException {
        if (programName != null) {
            Path exePath = new Path(programName);
            IProject project = null;
            if (projectName != null && !projectName.equals("")) {
                project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                if (project == null || project.getLocation() == null) {
                    return null;
                }
                if (!exePath.isAbsolute()) {
                    exePath = project.getLocation().append((IPath)exePath);
                }
            }
            return LaunchUtils.getBinary(project, (IPath)exePath);
        }
        return null;
    }

    public static IStringVariableManager getStringVariableManager() {
        return VariablesPlugin.getDefault().getStringVariableManager();
    }

    private static String[] parseArguments(String args) {
        return CommandLineUtil.argumentsToArray((String)args);
    }

    public static void enableActivity(final String activityID, final boolean enableit) {
        if (PlatformUI.isWorkbenchRunning()) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    IWorkbenchActivitySupport workbenchActivitySupport = PlatformUI.getWorkbench().getActivitySupport();
                    IActivityManager activityManager = workbenchActivitySupport.getActivityManager();
                    HashSet<String> enabledActivityIds = new HashSet<String>(activityManager.getEnabledActivityIds());
                    boolean changed = false;
                    changed = enableit ? enabledActivityIds.add(activityID) : enabledActivityIds.remove(activityID);
                    if (changed) {
                        workbenchActivitySupport.setEnabledActivityIds(enabledActivityIds);
                    }
                }
            });
        }
    }

    public static ICConfigurationDescription getBuildConfigByProgramPath(IProject project, String programPath) {
        if (project == null || programPath == null) {
            return null;
        }
        ICProjectDescription projectDesc = CoreModel.getDefault().getProjectDescription(project, false);
        if (projectDesc == null) {
            return null;
        }
        Path path = new Path(programPath);
        if (!path.isAbsolute()) {
            IPath projLocation = project.getLocation();
            if (projLocation == null) {
                return null;
            }
            path = projLocation.append((IPath)path);
        }
        IFile[] files = ResourceLookup.findFilesForLocation((IPath)path);
        ICConfigurationDescription buildConfig = null;
        ICConfigurationDescription[] iCConfigurationDescriptionArray = projectDesc.getConfigurations();
        int n = iCConfigurationDescriptionArray.length;
        int n2 = 0;
        block0: while (n2 < n) {
            CBuildData buildData;
            ICConfigurationDescription cfgDes = iCConfigurationDescriptionArray[n2];
            CConfigurationData cfgData = cfgDes.getConfigurationData();
            if (cfgData != null && (buildData = cfgData.getBuildData()) != null) {
                ICOutputEntry[] iCOutputEntryArray = buildData.getOutputDirectories();
                int n3 = iCOutputEntryArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IPath dirLocation;
                    ICOutputEntry dir = iCOutputEntryArray[n4];
                    ICOutputEntry absoluteDir = CDataUtil.makeAbsolute((IProject)project, (ICOutputEntry)dir);
                    if (absoluteDir != null && (dirLocation = absoluteDir.getLocation()) != null) {
                        IFile[] iFileArray = files;
                        int n5 = files.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            IFile file = iFileArray[n6];
                            if (dirLocation.isPrefixOf(file.getLocation())) {
                                if (buildConfig != null && buildConfig != cfgDes) {
                                    buildConfig = null;
                                    break block0;
                                }
                                buildConfig = cfgDes;
                            }
                            ++n6;
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return buildConfig;
    }

    static class BuildProgressMonitor
    extends SubProgressMonitor {
        private boolean cancelled;

        public BuildProgressMonitor(IProgressMonitor monitor, int ticks, int style) {
            super(monitor, ticks, style);
        }

        public BuildProgressMonitor(IProgressMonitor monitor, int ticks) {
            this(monitor, ticks, 0);
        }

        public void setCanceled(boolean b) {
            this.cancelled = b;
        }

        public boolean isCanceled() {
            return this.cancelled || super.isCanceled();
        }
    }
}

