/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.buildmodel;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.cdt.managedbuilder.buildmodel.IBuildDescription;
import org.eclipse.cdt.managedbuilder.buildmodel.IBuildIOType;
import org.eclipse.cdt.managedbuilder.buildmodel.IBuildResource;
import org.eclipse.cdt.managedbuilder.buildmodel.IBuildStep;
import org.eclipse.cdt.managedbuilder.buildmodel.IStepVisitor;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.internal.buildmodel.BuildMultiStatus;
import org.eclipse.cdt.managedbuilder.internal.buildmodel.BuildStatus;
import org.eclipse.cdt.managedbuilder.internal.buildmodel.DbgUtil;
import org.eclipse.cdt.managedbuilder.internal.buildmodel.DefaultBuildDescriptionFactory;
import org.eclipse.cdt.managedbuilder.internal.buildmodel.IConfigurationBuildState;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildDescriptionManager {
    public static final int REMOVED = 1;
    public static final int REBUILD = 2;
    public static final int DEPS = 4;
    public static final int DEPFILES = 8;
    private Set<IBuildStep> fVisitedSteps = new HashSet<IBuildStep>();
    private boolean fUp;
    private IBuildDescription fInfo;

    private BuildDescriptionManager(boolean up, IBuildDescription info) {
        this.fUp = up;
        this.fInfo = info;
    }

    public static IBuildDescription createBuildDescription(IConfiguration cfg, IResourceDelta delta, int flags) throws CoreException {
        return DefaultBuildDescriptionFactory.getInstance().createBuildDescription(cfg, delta, flags);
    }

    public static IBuildDescription createBuildDescription(IConfiguration cfg, IConfigurationBuildState bs, IResourceDelta delta, int flags) throws CoreException {
        return DefaultBuildDescriptionFactory.getInstance().createBuildDescription(cfg, bs, delta, flags);
    }

    public static void accept(IStepVisitor visitor, IBuildDescription des, boolean up) throws CoreException {
        BuildDescriptionManager util = new BuildDescriptionManager(up, des);
        util.doAccept(visitor);
    }

    private void doAccept(IStepVisitor visitor) throws CoreException {
        IBuildStep action = this.fUp ? this.fInfo.getInputStep() : this.fInfo.getOutputStep();
        this.doAccept(visitor, action, true);
    }

    private boolean doAccept(IStepVisitor visitor, IBuildStep action, boolean doNext) throws CoreException {
        IBuildStep[] actions = BuildDescriptionManager.getSteps(action, this.fUp);
        boolean proceed = true;
        int i = 0;
        while (i < actions.length) {
            if (!this.fVisitedSteps.contains(actions[i]) && !this.doAccept(visitor, actions[i], false)) {
                proceed = false;
                break;
            }
            ++i;
        }
        if (proceed && !this.fVisitedSteps.contains(action)) {
            proceed = visitor.visit(action) == 1;
            this.fVisitedSteps.add(action);
        }
        if (doNext && proceed) {
            IBuildStep[] nextActions = BuildDescriptionManager.getSteps(action, !this.fUp);
            int i2 = 0;
            while (i2 < nextActions.length) {
                if (!this.fVisitedSteps.contains(nextActions[i2]) && !this.doAccept(visitor, nextActions[i2], true)) {
                    proceed = false;
                    break;
                }
                ++i2;
            }
        }
        return proceed;
    }

    public static IBuildStep[] getSteps(IBuildStep step, boolean input) {
        HashSet<IBuildStep> set = new HashSet<IBuildStep>();
        IBuildIOType[] args = input ? step.getInputIOTypes() : step.getOutputIOTypes();
        int i = 0;
        while (i < args.length) {
            IBuildResource[] rcs = args[i].getResources();
            int j = 0;
            while (j < rcs.length) {
                if (input) {
                    IBuildIOType arg = rcs[j].getProducerIOType();
                    if (arg != null && arg.getStep() != null) {
                        set.add(arg.getStep());
                    }
                } else {
                    IBuildIOType[] depArgs = rcs[j].getDependentIOTypes();
                    int k = 0;
                    while (k < depArgs.length) {
                        IBuildIOType arg = depArgs[k];
                        if (arg != null && arg.getStep() != null) {
                            set.add(arg.getStep());
                        }
                        ++k;
                    }
                }
                ++j;
            }
            ++i;
        }
        return set.toArray(new IBuildStep[set.size()]);
    }

    public static IBuildResource[] filterGeneratedBuildResources(IBuildResource[] rc, int rcState) {
        ArrayList<IBuildResource> list = new ArrayList<IBuildResource>();
        BuildDescriptionManager.addBuildResources(rc, list, rcState);
        return list.toArray(new IBuildResource[list.size()]);
    }

    private static void addBuildResources(IBuildResource[] rcs, List<IBuildResource> list, int rcState) {
        if (rcs.length == 0) {
            return;
        }
        IBuildStep inputAction = rcs[0].getBuildDescription().getInputStep();
        if (DbgUtil.DEBUG) {
            DbgUtil.trace(">>found resources to clean:");
        }
        int i = 0;
        while (i < rcs.length) {
            IBuildResource buildRc = rcs[i];
            IPath path = buildRc.getFullPath();
            if (path != null && (BuildDescriptionManager.checkFlags(rcState, 2) && buildRc.needsRebuild() || BuildDescriptionManager.checkFlags(rcState, 1) && buildRc.isRemoved()) && buildRc.getProducerIOType() != null && buildRc.getProducerIOType().getStep() != inputAction && buildRc.isProjectResource()) {
                if (DbgUtil.DEBUG) {
                    DbgUtil.trace(path.toString());
                }
                list.add(buildRc);
            }
            ++i;
        }
        if (DbgUtil.DEBUG) {
            DbgUtil.trace("<<");
        }
    }

    private static boolean checkFlags(int var, int flags) {
        return (var & flags) == flags;
    }

    public static IResource findResourceForBuildResource(IBuildResource bRc) {
        IPath path = bRc.getFullPath();
        if (path != null) {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            return root.findMember(path);
        }
        return null;
    }

    public static void cleanGeneratedRebuildResources(IBuildDescription des) throws CoreException {
        IBuildResource[] bRcs = BuildDescriptionManager.filterGeneratedBuildResources(des.getResources(), 3);
        ArrayList<Object[]> failList = new ArrayList<Object[]>();
        int i = 0;
        while (i < bRcs.length) {
            IResource rc;
            if (bRcs[i].isProjectResource() && (rc = BuildDescriptionManager.findResourceForBuildResource(bRcs[i])) != null) {
                try {
                    rc.delete(true, null);
                }
                catch (CoreException e) {
                    failList.add(new Object[]{rc, e});
                }
            }
            ++i;
        }
        if (failList.size() != 0) {
            BuildMultiStatus status = new BuildMultiStatus("failed to remove resources", null);
            for (Object[] err : failList) {
                IResource rc = (IResource)err[0];
                CoreException e = (CoreException)((Object)err[1]);
                status.add((IStatus)new BuildStatus(rc.getFullPath().toString(), e));
            }
            throw new CoreException((IStatus)status);
        }
    }

    public static IPath getRelPath(IPath cwd, IPath location) {
        if (!location.isAbsolute()) {
            return location;
        }
        IPath tmp = cwd;
        StringBuffer buf = null;
        while (tmp.segmentCount() != 0) {
            if (tmp.isPrefixOf(location)) {
                IPath p = location.removeFirstSegments(tmp.segmentCount()).setDevice(null);
                if (buf == null) {
                    return p;
                }
                buf.append(p.makeRelative().toString());
                return new Path(buf.toString());
            }
            if (buf == null) {
                buf = new StringBuffer();
                buf.append("../");
            } else {
                buf.append("../");
            }
            tmp = tmp.removeLastSegments(1);
        }
        return location;
    }
}

