/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.core;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.cdt.core.AbstractCExtension;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.CoreModelUtil;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.IScannerInfoChangeListener;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICMultiConfigDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.XmlStorageUtil;
import org.eclipse.cdt.core.settings.model.extension.CConfigurationData;
import org.eclipse.cdt.managedbuilder.buildproperties.IBuildProperty;
import org.eclipse.cdt.managedbuilder.buildproperties.IBuildPropertyManager;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IBuildObjectProperties;
import org.eclipse.cdt.managedbuilder.core.IBuilder;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IConvertManagedBuildObject;
import org.eclipse.cdt.managedbuilder.core.IFileInfo;
import org.eclipse.cdt.managedbuilder.core.IFolderInfo;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IInputType;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildDefinitionsStartup;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedCommandLineGenerator;
import org.eclipse.cdt.managedbuilder.core.IManagedConfigElement;
import org.eclipse.cdt.managedbuilder.core.IManagedConfigElementProvider;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IOptionCategory;
import org.eclipse.cdt.managedbuilder.core.IOutputType;
import org.eclipse.cdt.managedbuilder.core.IProjectType;
import org.eclipse.cdt.managedbuilder.core.IResourceConfiguration;
import org.eclipse.cdt.managedbuilder.core.IResourceInfo;
import org.eclipse.cdt.managedbuilder.core.ITarget;
import org.eclipse.cdt.managedbuilder.core.ITargetPlatform;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.IToolReference;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.managedbuilder.core.OptionStringValue;
import org.eclipse.cdt.managedbuilder.envvar.IEnvironmentBuildPathsChangeListener;
import org.eclipse.cdt.managedbuilder.envvar.IEnvironmentVariableProvider;
import org.eclipse.cdt.managedbuilder.internal.buildproperties.BuildPropertyManager;
import org.eclipse.cdt.managedbuilder.internal.core.BooleanExpressionApplicabilityCalculator;
import org.eclipse.cdt.managedbuilder.internal.core.BuildDbgUtil;
import org.eclipse.cdt.managedbuilder.internal.core.BuildObject;
import org.eclipse.cdt.managedbuilder.internal.core.BuildSettingsUtil;
import org.eclipse.cdt.managedbuilder.internal.core.Builder;
import org.eclipse.cdt.managedbuilder.internal.core.BuilderFactory;
import org.eclipse.cdt.managedbuilder.internal.core.CommonBuilder;
import org.eclipse.cdt.managedbuilder.internal.core.Configuration;
import org.eclipse.cdt.managedbuilder.internal.core.DefaultManagedConfigElement;
import org.eclipse.cdt.managedbuilder.internal.core.FolderInfo;
import org.eclipse.cdt.managedbuilder.internal.core.IMatchKeyProvider;
import org.eclipse.cdt.managedbuilder.internal.core.InputType;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedCommandLineGenerator;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedMakeMessages;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedProject;
import org.eclipse.cdt.managedbuilder.internal.core.MatchKey;
import org.eclipse.cdt.managedbuilder.internal.core.MultiConfiguration;
import org.eclipse.cdt.managedbuilder.internal.core.MultiFolderInfo;
import org.eclipse.cdt.managedbuilder.internal.core.MultiResourceInfo;
import org.eclipse.cdt.managedbuilder.internal.core.Option;
import org.eclipse.cdt.managedbuilder.internal.core.OptionCategory;
import org.eclipse.cdt.managedbuilder.internal.core.OutputType;
import org.eclipse.cdt.managedbuilder.internal.core.ProjectType;
import org.eclipse.cdt.managedbuilder.internal.core.ResourceConfiguration;
import org.eclipse.cdt.managedbuilder.internal.core.Target;
import org.eclipse.cdt.managedbuilder.internal.core.TargetPlatform;
import org.eclipse.cdt.managedbuilder.internal.core.Tool;
import org.eclipse.cdt.managedbuilder.internal.core.ToolChain;
import org.eclipse.cdt.managedbuilder.internal.dataprovider.BuildConfigurationData;
import org.eclipse.cdt.managedbuilder.internal.dataprovider.ConfigurationDataProvider;
import org.eclipse.cdt.managedbuilder.internal.envvar.EnvironmentVariableProvider;
import org.eclipse.cdt.managedbuilder.internal.macros.BuildMacroProvider;
import org.eclipse.cdt.managedbuilder.internal.tcmodification.ToolChainModificationManager;
import org.eclipse.cdt.managedbuilder.macros.IBuildMacroProvider;
import org.eclipse.cdt.managedbuilder.makegen.IManagedBuilderMakefileGenerator;
import org.eclipse.cdt.managedbuilder.makegen.gnu.GnuMakefileGenerator;
import org.eclipse.cdt.managedbuilder.projectconverter.UpdateManagedProjectManager;
import org.eclipse.cdt.managedbuilder.tcmodification.IToolChainModificationManager;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagedBuildManager
extends AbstractCExtension {
    private static final String ROOT_NODE_NAME = "ManagedProjectBuildInfo";
    public static final String SETTINGS_FILE_NAME = ".cdtbuild";
    private static final ITarget[] emptyTargets = new ITarget[0];
    public static final String INTERFACE_IDENTITY = String.valueOf(ManagedBuilderCorePlugin.getUniqueIdentifier()) + ".ManagedBuildManager";
    public static final String EXTENSION_POINT_ID = String.valueOf(ManagedBuilderCorePlugin.getUniqueIdentifier()) + ".buildDefinitions";
    public static final String EXTENSION_POINT_ID_V2 = String.valueOf(ManagedBuilderCorePlugin.getUniqueIdentifier()) + ".ManagedBuildInfo";
    private static final String REVISION_ELEMENT_NAME = "managedBuildRevision";
    private static final String VERSION_ELEMENT_NAME = "fileVersion";
    private static final String MANIFEST_VERSION_ERROR = "ManagedBuildManager.error.manifest.version.error";
    private static final String PROJECT_VERSION_ERROR = "ManagedBuildManager.error.project.version.error";
    private static final String PROJECT_FILE_ERROR = "ManagedBuildManager.error.project.file.missing";
    private static final String MANIFEST_ERROR_HEADER = "ManagedBuildManager.error.manifest.header";
    public static final String MANIFEST_ERROR_RESOLVING = "ManagedBuildManager.error.manifest.resolving";
    public static final String MANIFEST_ERROR_DUPLICATE = "ManagedBuildManager.error.manifest.duplicate";
    public static final String MANIFEST_ERROR_ICON = "ManagedBuildManager.error.manifest.icon";
    private static final String MANIFEST_ERROR_OPTION_CATEGORY = "ManagedBuildManager.error.manifest.option.category";
    private static final String MANIFEST_ERROR_OPTION_FILTER = "ManagedBuildManager.error.manifest.option.filter";
    private static final String MANIFEST_ERROR_OPTION_VALUEHANDLER = "ManagedBuildManager.error.manifest.option.valuehandler";
    private static final String MANIFEST_ERROR_READ_ONLY = "ManagedBuildManager.error.read_only";
    private static final String MANIFEST_ERROR_WRITE_FAILED = "ManagedBuildManager.error.write_failed";
    public static final int ERROR_CATEGORY = 0;
    public static final int ERROR_FILTER = 1;
    public static final String BUILD_TYPE_PROPERTY_ID = "org.eclipse.cdt.build.core.buildType";
    public static final String BUILD_ARTEFACT_TYPE_PROPERTY_ID = "org.eclipse.cdt.build.core.buildArtefactType";
    public static final String BUILD_TYPE_PROPERTY_DEBUG = "org.eclipse.cdt.build.core.buildType.debug";
    public static final String BUILD_TYPE_PROPERTY_RELEASE = "org.eclipse.cdt.build.core.buildType.release";
    public static final String BUILD_ARTEFACT_TYPE_PROPERTY_EXE = "org.eclipse.cdt.build.core.buildArtefactType.exe";
    public static final String BUILD_ARTEFACT_TYPE_PROPERTY_STATICLIB = "org.eclipse.cdt.build.core.buildArtefactType.staticLib";
    public static final String BUILD_ARTEFACT_TYPE_PROPERTY_SHAREDLIB = "org.eclipse.cdt.build.core.buildArtefactType.sharedLib";
    public static final String CFG_DATA_PROVIDER_ID = String.valueOf(ManagedBuilderCorePlugin.getUniqueIdentifier()) + ".configurationDataProvider";
    private static final String NEWLINE = System.getProperty("line.separator");
    public static final String INTERNAL_BUILDER_ID = "org.eclipse.cdt.build.core.internal.builder";
    private static final String os = Platform.getOS();
    private static final String arch = Platform.getOSArch();
    private static final String ALL = "all";
    private static final Version buildInfoVersion = new Version(4, 0, 0);
    private static final Version version = new Version(4, 0, 0);
    private static boolean projectTypesLoaded = false;
    private static boolean projectTypesLoading = false;
    public static SortedMap<String, IProjectType> projectTypeMap;
    private static List<IProjectType> projectTypes;
    private static List<IManagedConfigElement> startUpConfigElements;
    private static Map<String, IConfiguration> extensionConfigurationMap;
    private static Map<String, IResourceConfiguration> extensionResourceConfigurationMap;
    private static SortedMap<String, ToolChain> extensionToolChainMap;
    private static SortedMap<String, Tool> extensionToolMap;
    private static Map<String, ITargetPlatform> extensionTargetPlatformMap;
    private static SortedMap<String, Builder> extensionBuilderMap;
    private static Map<String, IOption> extensionOptionMap;
    private static Map<String, IOptionCategory> extensionOptionCategoryMap;
    private static Map<String, IInputType> extensionInputTypeMap;
    private static Map<String, IOutputType> extensionOutputTypeMap;
    private static Map<String, ITarget> extensionTargetMap;
    private static Map<IBuildObject, IManagedConfigElement> configElementMap;
    private static Map<IResource, List<IScannerInfoChangeListener>> buildModelListeners;
    private static Random randomNumber;
    private static IEnvironmentBuildPathsChangeListener fEnvironmentBuildPathsChangeListener;
    private static HashMap<MatchKey<ToolChain>, List<ToolChain>> fSortedToolChains;
    private static HashMap<MatchKey<Tool>, List<Tool>> fSortedTools;
    private static HashMap<MatchKey<Builder>, List<Builder>> fSortedBuilders;
    private static Map<IProject, IManagedBuildInfo> fInfoMap;
    private static ISorter fToolChainSorter;
    private static ISorter fToolSorter;
    private static ISorter fBuilderSorter;
    private static final boolean TEST_CONSISTENCE = false;

    static {
        fInfoMap = new HashMap<IProject, IManagedBuildInfo>();
        fToolChainSorter = new ISorter(){

            public void sort() {
                ManagedBuildManager.resortToolChains();
            }
        };
        fToolSorter = new ISorter(){

            public void sort() {
                ManagedBuildManager.resortTools();
            }
        };
        fBuilderSorter = new ISorter(){

            public void sort() {
                ManagedBuildManager.resortBuilders();
            }
        };
        fEnvironmentBuildPathsChangeListener = new IEnvironmentBuildPathsChangeListener(){

            public void buildPathsChanged(IConfiguration configuration, int buildPathType) {
            }
        };
        ManagedBuildManager.getEnvironmentVariableProvider().subscribe(fEnvironmentBuildPathsChangeListener);
    }

    public static int getRandomNumber() {
        int i;
        if (randomNumber == null) {
            randomNumber = new Random();
            randomNumber.setSeed(System.currentTimeMillis());
        }
        if ((i = randomNumber.nextInt()) < 0) {
            i *= -1;
        }
        return i;
    }

    public static IProjectType[] getDefinedProjectTypes() {
        try {
            ManagedBuildManager.loadExtensions();
        }
        catch (BuildException e) {
            e.printStackTrace();
        }
        List definedTypes = null;
        int size = projectTypes != null ? projectTypes.size() : 0;
        IProjectType[] types = new IProjectType[size += definedTypes != null ? definedTypes.size() : 0];
        if (size > 0) {
            int n = 0;
            int i = 0;
            while (i < projectTypes.size()) {
                types[n++] = projectTypes.get(i);
                ++i;
            }
            if (definedTypes != null) {
                i = 0;
                while (i < definedTypes.size()) {
                    types[n++] = (IProjectType)definedTypes.get(i);
                    ++i;
                }
            }
        }
        return types;
    }

    public static IProjectType getProjectType(String id) {
        try {
            ManagedBuildManager.loadExtensions();
        }
        catch (BuildException e) {
            e.printStackTrace();
        }
        return (IProjectType)ManagedBuildManager.getExtensionProjectTypeMap().get(id);
    }

    public static Version getVersion() {
        return version;
    }

    public static SortedMap<String, IProjectType> getExtensionProjectTypeMap() {
        try {
            ManagedBuildManager.loadExtensions();
        }
        catch (BuildException buildException) {}
        if (projectTypeMap == null) {
            projectTypeMap = new TreeMap<String, IProjectType>();
        }
        return projectTypeMap;
    }

    protected static Map<String, IConfiguration> getExtensionConfigurationMap() {
        if (extensionConfigurationMap == null) {
            extensionConfigurationMap = new HashMap<String, IConfiguration>();
        }
        return extensionConfigurationMap;
    }

    protected static Map<String, IResourceConfiguration> getExtensionResourceConfigurationMap() {
        if (extensionResourceConfigurationMap == null) {
            extensionResourceConfigurationMap = new HashMap<String, IResourceConfiguration>();
        }
        return extensionResourceConfigurationMap;
    }

    private static SortedMap<String, ToolChain> getExtensionToolChainMapInternal() {
        try {
            ManagedBuildManager.loadExtensions();
        }
        catch (BuildException buildException) {}
        if (extensionToolChainMap == null) {
            extensionToolChainMap = new TreeMap<String, ToolChain>();
        }
        return extensionToolChainMap;
    }

    public static SortedMap<String, ? extends IToolChain> getExtensionToolChainMap() {
        return ManagedBuildManager.getExtensionToolChainMapInternal();
    }

    public static IToolChain[] getExtensionToolChains() {
        return ManagedBuildManager.getExtensionToolChainMapInternal().values().toArray(new ToolChain[extensionToolChainMap.size()]);
    }

    private static SortedMap<String, Tool> getExtensionToolMapInternal() {
        try {
            ManagedBuildManager.loadExtensions();
        }
        catch (BuildException buildException) {}
        if (extensionToolMap == null) {
            extensionToolMap = new TreeMap<String, Tool>();
        }
        return extensionToolMap;
    }

    public static SortedMap<String, ? extends ITool> getExtensionToolMap() {
        return ManagedBuildManager.getExtensionToolMapInternal();
    }

    public static ITool[] getExtensionTools() {
        return ManagedBuildManager.getExtensionToolMapInternal().values().toArray(new Tool[extensionToolMap.size()]);
    }

    protected static Map<String, ITargetPlatform> getExtensionTargetPlatformMap() {
        if (extensionTargetPlatformMap == null) {
            extensionTargetPlatformMap = new HashMap<String, ITargetPlatform>();
        }
        return extensionTargetPlatformMap;
    }

    private static SortedMap<String, Builder> getExtensionBuilderMapInternal() {
        try {
            ManagedBuildManager.loadExtensions();
        }
        catch (BuildException buildException) {}
        if (extensionBuilderMap == null) {
            extensionBuilderMap = new TreeMap<String, Builder>();
        }
        return extensionBuilderMap;
    }

    public static SortedMap<String, ? extends IBuilder> getExtensionBuilderMap() {
        return ManagedBuildManager.getExtensionBuilderMapInternal();
    }

    public static IBuilder[] getExtensionBuilders() {
        return ManagedBuildManager.getExtensionBuilderMapInternal().values().toArray(new Builder[extensionBuilderMap.size()]);
    }

    protected static Map<String, IOption> getExtensionOptionMap() {
        if (extensionOptionMap == null) {
            extensionOptionMap = new HashMap<String, IOption>();
        }
        return extensionOptionMap;
    }

    protected static Map<String, IOptionCategory> getExtensionOptionCategoryMap() {
        if (extensionOptionCategoryMap == null) {
            extensionOptionCategoryMap = new HashMap<String, IOptionCategory>();
        }
        return extensionOptionCategoryMap;
    }

    protected static Map<String, IInputType> getExtensionInputTypeMap() {
        if (extensionInputTypeMap == null) {
            extensionInputTypeMap = new HashMap<String, IInputType>();
        }
        return extensionInputTypeMap;
    }

    protected static Map<String, IOutputType> getExtensionOutputTypeMap() {
        if (extensionOutputTypeMap == null) {
            extensionOutputTypeMap = new HashMap<String, IOutputType>();
        }
        return extensionOutputTypeMap;
    }

    protected static Map<String, ITarget> getExtensionTargetMap() {
        if (extensionTargetMap == null) {
            extensionTargetMap = new HashMap<String, ITarget>();
        }
        return extensionTargetMap;
    }

    public static ITarget[] getTargets(IResource resource) {
        IManagedBuildInfo buildInfo = ManagedBuildManager.getBuildInfo(resource);
        if (buildInfo != null) {
            List<ITarget> targets = buildInfo.getTargets();
            return targets.toArray(new ITarget[targets.size()]);
        }
        return emptyTargets;
    }

    public static IProjectType getExtensionProjectType(String id) {
        try {
            ManagedBuildManager.loadExtensions();
        }
        catch (BuildException e) {
            e.printStackTrace();
        }
        return (IProjectType)ManagedBuildManager.getExtensionProjectTypeMap().get(id);
    }

    public static IConfiguration getExtensionConfiguration(IConfiguration cfg) {
        while (cfg != null && !cfg.isExtensionElement()) {
            cfg = cfg.getParent();
        }
        return cfg;
    }

    public static IConfiguration getExtensionConfiguration(String id) {
        try {
            ManagedBuildManager.loadExtensions();
        }
        catch (BuildException e) {
            e.printStackTrace();
        }
        return ManagedBuildManager.getExtensionConfigurationMap().get(id);
    }

    public static IConfiguration[] getExtensionConfigurations() {
        try {
            ManagedBuildManager.loadExtensions();
        }
        catch (BuildException e) {
            e.printStackTrace();
        }
        return ManagedBuildManager.getExtensionConfigurationMap().values().toArray(new Configuration[ManagedBuildManager.getExtensionConfigurationMap().size()]);
    }

    public static IResourceConfiguration getExtensionResourceConfiguration(String id) {
        try {
            ManagedBuildManager.loadExtensions();
        }
        catch (BuildException e) {
            e.printStackTrace();
        }
        return ManagedBuildManager.getExtensionResourceConfigurationMap().get(id);
    }

    public static IToolChain getExtensionToolChain(String id) {
        return (IToolChain)ManagedBuildManager.getExtensionToolChainMapInternal().get(id);
    }

    public static ITool getExtensionTool(String id) {
        return (ITool)ManagedBuildManager.getExtensionToolMapInternal().get(id);
    }

    public static ITargetPlatform getExtensionTargetPlatform(String id) {
        try {
            ManagedBuildManager.loadExtensions();
        }
        catch (BuildException e) {
            e.printStackTrace();
        }
        return ManagedBuildManager.getExtensionTargetPlatformMap().get(id);
    }

    public static IBuilder getExtensionBuilder(String id) {
        return (IBuilder)ManagedBuildManager.getExtensionBuilderMapInternal().get(id);
    }

    public static IBuilder getExtensionBuilder(IBuilder builder) {
        while (builder != null && !builder.isExtensionElement()) {
            builder = builder.getSuperClass();
        }
        return builder;
    }

    public static IOption getExtensionOption(String id) {
        try {
            ManagedBuildManager.loadExtensions();
        }
        catch (BuildException e) {
            e.printStackTrace();
        }
        return ManagedBuildManager.getExtensionOptionMap().get(id);
    }

    public static IInputType getExtensionInputType(String id) {
        try {
            ManagedBuildManager.loadExtensions();
        }
        catch (BuildException e) {
            e.printStackTrace();
        }
        return ManagedBuildManager.getExtensionInputTypeMap().get(id);
    }

    public static IOutputType getExtensionOutputType(String id) {
        try {
            ManagedBuildManager.loadExtensions();
        }
        catch (BuildException e) {
            e.printStackTrace();
        }
        return ManagedBuildManager.getExtensionOutputTypeMap().get(id);
    }

    public static ITarget getExtensionTarget(String id) {
        try {
            ManagedBuildManager.loadExtensions();
        }
        catch (BuildException e) {
            e.printStackTrace();
        }
        return ManagedBuildManager.getExtensionTargetMap().get(id);
    }

    public static ITarget getTarget(IResource resource, String id) {
        IManagedBuildInfo buildInfo;
        ITarget target = null;
        if (resource != null && (buildInfo = ManagedBuildManager.getBuildInfo(resource)) != null) {
            target = buildInfo.getTarget(id);
        }
        if (target == null) {
            target = ManagedBuildManager.getExtensionTargetMap().get(id);
        }
        return target;
    }

    public static void setDefaultConfiguration(IProject project, IConfiguration newDefault) {
        if (project == null || newDefault == null) {
            return;
        }
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
        if (info != null) {
            info.setDefaultConfiguration(newDefault);
        }
    }

    public static void setSelectedConfiguration(IProject project, IConfiguration config) {
        if (project == null) {
            return;
        }
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
        if (info != null) {
            info.setSelectedConfiguration(config);
        }
    }

    public static IManagedBuilderMakefileGenerator getBuildfileGenerator(IConfiguration config) {
        IBuilder builder;
        IToolChain toolChain = config.getToolChain();
        if (toolChain != null && (builder = toolChain.getBuilder()) != null) {
            return builder.getBuildFileGenerator();
        }
        return new GnuMakefileGenerator();
    }

    public static IManagedCommandLineGenerator getCommandLineGenerator(IConfiguration config, String toolId) {
        ITool tool = config.getTool(toolId);
        if (tool != null) {
            return tool.getCommandLineGenerator();
        }
        return ManagedCommandLineGenerator.getCommandLineGenerator();
    }

    public static String getScannerInfoProfileId(IConfiguration config) {
        IToolChain toolChain = config.getToolChain();
        return toolChain.getScannerConfigDiscoveryProfileId();
    }

    public static IConfiguration getSelectedConfiguration(IProject project) {
        if (project == null) {
            return null;
        }
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
        if (info != null) {
            return info.getSelectedConfiguration();
        }
        return null;
    }

    public static void initializePathEntries(IConfiguration config, IOption option) {
        try {
            if (config.isTemporary() || option != null && option.getValueType() != 4 && option.getValueType() != 5 && option.getValueType() != 8 && option.getValueType() != 9 && option.getValueType() != 10 && option.getValueType() != 11 && option.getValueType() != -4 && option.getValueType() != -5 && option.getValueType() != -8 && option.getValueType() != -9 && option.getValueType() != -10 && option.getValueType() != -11) {
                return;
            }
        }
        catch (BuildException buildException) {
            return;
        }
        try {
            ManagedBuildManager.updateCoreSettings(config);
        }
        catch (CoreException coreException) {}
    }

    public static void initializePathEntries(IResourceConfiguration resConfig, IOption option) {
        IConfiguration cfg = resConfig.getParent();
        if (cfg != null) {
            ManagedBuildManager.initializePathEntries(cfg, option);
        }
    }

    private static void notifyListeners(IResourceInfo resConfig, IOption option) {
        try {
            if (resConfig.getParent().isTemporary() || option != null && option.getValueType() != 4 && option.getValueType() != 5 && option.getValueType() != 8 && option.getValueType() != 9 && option.getValueType() != 10 && option.getValueType() != 11 && option.getValueType() != -4 && option.getValueType() != -5 && option.getValueType() != -8 && option.getValueType() != -9 && option.getValueType() != -10 && option.getValueType() != -11) {
                return;
            }
        }
        catch (BuildException buildException) {
            return;
        }
        IResource resource = resConfig.getParent().getOwner();
        List<IScannerInfoChangeListener> listeners = ManagedBuildManager.getBuildModelListeners().get(resource);
        if (listeners == null) {
            return;
        }
        ListIterator<IScannerInfoChangeListener> iter = listeners.listIterator();
        while (iter.hasNext()) {
            iter.next().changeNotification(resource, (IScannerInfo)ManagedBuildManager.getBuildInfo(resource));
        }
    }

    public static void setNewProjectVersion(IProject newProject) {
        ManagedBuildInfo info = ManagedBuildManager.findBuildInfo((IResource)newProject, true);
        if (info != null) {
            info.setVersion(buildInfoVersion.toString());
        }
    }

    public static IOption setOption(IConfiguration config, IHoldsOptions holder, IOption option, boolean value) {
        IOption retOpt;
        try {
            retOpt = config.setOption(holder, option, value);
            retOpt.getValueHandler().handleValue(config, holder, retOpt, retOpt.getValueHandlerExtraArgument(), 4);
        }
        catch (BuildException buildException) {
            return null;
        }
        return retOpt;
    }

    public static IOption setOption(IResourceInfo resConfig, IHoldsOptions holder, IOption option, boolean value) {
        IOption retOpt;
        try {
            retOpt = resConfig.setOption(holder, option, value);
            if (retOpt != null) {
                retOpt.getValueHandler().handleValue(resConfig, holder, retOpt, retOpt.getValueHandlerExtraArgument(), 4);
            }
            ManagedBuildManager.notifyListeners(resConfig, retOpt);
        }
        catch (BuildException buildException) {
            return null;
        }
        return retOpt;
    }

    public static IOption setOption(IConfiguration config, IHoldsOptions holder, IOption option, String value) {
        IOption retOpt;
        try {
            retOpt = config.setOption(holder, option, value);
            retOpt.getValueHandler().handleValue(config, holder, retOpt, retOpt.getValueHandlerExtraArgument(), 4);
        }
        catch (BuildException buildException) {
            return null;
        }
        return retOpt;
    }

    public static IOption setOption(IResourceInfo resConfig, IHoldsOptions holder, IOption option, String value) {
        IOption retOpt;
        try {
            retOpt = resConfig.setOption(holder, option, value);
            retOpt.getValueHandler().handleValue(resConfig, holder, retOpt, retOpt.getValueHandlerExtraArgument(), 4);
            ManagedBuildManager.notifyListeners(resConfig, retOpt);
        }
        catch (BuildException buildException) {
            return null;
        }
        return retOpt;
    }

    public static IOption setOption(IConfiguration config, IHoldsOptions holder, IOption option, String[] value) {
        IOption retOpt;
        try {
            retOpt = config.setOption(holder, option, value);
            retOpt.getValueHandler().handleValue(config, holder, retOpt, retOpt.getValueHandlerExtraArgument(), 4);
        }
        catch (BuildException buildException) {
            return null;
        }
        return retOpt;
    }

    public static IOption setOption(IResourceInfo resConfig, IHoldsOptions holder, IOption option, String[] value) {
        IOption retOpt;
        try {
            retOpt = resConfig.setOption(holder, option, value);
            retOpt.getValueHandler().handleValue(resConfig, holder, retOpt, retOpt.getValueHandlerExtraArgument(), 4);
            ManagedBuildManager.notifyListeners(resConfig, retOpt);
        }
        catch (BuildException buildException) {
            return null;
        }
        return retOpt;
    }

    public static IOption setOption(IResourceInfo resConfig, IHoldsOptions holder, IOption option, OptionStringValue[] value) {
        IOption retOpt;
        try {
            retOpt = resConfig.setOption(holder, option, value);
            retOpt.getValueHandler().handleValue(resConfig, holder, retOpt, retOpt.getValueHandlerExtraArgument(), 4);
            ManagedBuildManager.notifyListeners(resConfig, retOpt);
        }
        catch (BuildException buildException) {
            return null;
        }
        return retOpt;
    }

    public static void setToolCommand(IConfiguration config, ITool tool, String command) {
        if (tool instanceof IToolReference) {
            ((IToolReference)tool).setToolCommand(command);
        } else {
            config.setToolCommand(tool, command);
        }
    }

    public static void setToolCommand(IResourceConfiguration resConfig, ITool tool, String command) {
        if (tool instanceof IToolReference) {
            ((IToolReference)tool).setToolCommand(command);
        } else {
            resConfig.setToolCommand(tool, command);
        }
    }

    public static boolean saveBuildInfoLegacy(IProject project, boolean force) {
        Throwable err = null;
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = builder.newDocument();
            ManagedBuildInfo buildInfo = (ManagedBuildInfo)ManagedBuildManager.getBuildInfo((IResource)project);
            if (buildInfo != null && !buildInfo.isReadOnly() && buildInfo.isValid() && (force || buildInfo.isDirty())) {
                String projectVersion = buildInfo.getVersion();
                if (projectVersion != null) {
                    ProcessingInstruction instruction = doc.createProcessingInstruction(VERSION_ELEMENT_NAME, projectVersion);
                    doc.appendChild(instruction);
                }
                Element rootElement = doc.createElement(ROOT_NODE_NAME);
                doc.appendChild(rootElement);
                buildInfo.serializeLegacy(doc, rootElement);
                ByteArrayOutputStream stream = new ByteArrayOutputStream();
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                transformer.setOutputProperty("method", "xml");
                transformer.setOutputProperty("encoding", "UTF-8");
                transformer.setOutputProperty("indent", "yes");
                DOMSource source = new DOMSource(doc);
                StreamResult result = new StreamResult(stream);
                transformer.transform(source, result);
                IFile projectFile = project.getFile(SETTINGS_FILE_NAME);
                String utfString = stream.toString("UTF-8");
                if (projectFile.exists()) {
                    if (projectFile.isReadOnly()) {
                        IStatus status;
                        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                        if (window == null) {
                            IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
                            window = windows[0];
                        }
                        Shell shell = null;
                        if (window != null) {
                            shell = window.getShell();
                        }
                        if (!(status = projectFile.getWorkspace().validateEdit(new IFile[]{projectFile}, (Object)shell)).isOK() && status.getCode() == 279) {
                            stream.close();
                            throw new IOException(ManagedMakeMessages.getFormattedString(MANIFEST_ERROR_READ_ONLY, projectFile.getFullPath().toString()));
                        }
                    }
                    projectFile.setContents((InputStream)new ByteArrayInputStream(utfString.getBytes("UTF-8")), 1, (IProgressMonitor)new NullProgressMonitor());
                } else {
                    projectFile.create((InputStream)new ByteArrayInputStream(utfString.getBytes("UTF-8")), 1, (IProgressMonitor)new NullProgressMonitor());
                }
                stream.close();
            }
        }
        catch (ParserConfigurationException e) {
            err = e;
        }
        catch (FactoryConfigurationError e) {
            err = e.getException();
        }
        catch (TransformerConfigurationException e) {
            err = e;
        }
        catch (TransformerFactoryConfigurationError e) {
            err = e.getException();
        }
        catch (TransformerException e) {
            err = e;
        }
        catch (IOException e) {
            err = e;
        }
        catch (CoreException e) {
            err = e;
        }
        if (err != null) {
            Shell shell;
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (window == null) {
                IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
                window = windows[0];
            }
            if ((shell = window.getShell()) != null) {
                final String exceptionMsg = err.getMessage();
                shell.getDisplay().syncExec(new Runnable(){

                    public void run() {
                        MessageDialog.openError((Shell)shell, (String)ManagedMakeMessages.getResourceString("ManagedBuildManager.error.write_failed_title"), (String)ManagedMakeMessages.getFormattedString(ManagedBuildManager.MANIFEST_ERROR_WRITE_FAILED, exceptionMsg));
                    }
                });
            }
        }
        return true;
    }

    public static boolean saveBuildInfo(final IProject project, final boolean force) {
        try {
            return ManagedBuildManager.updateBuildInfo(project, force);
        }
        catch (CoreException e) {
            Throwable cause = e.getStatus().getException();
            if (cause instanceof IllegalArgumentException) {
                Job j = new Job("save build info job"){

                    protected IStatus run(IProgressMonitor monitor) {
                        try {
                            ManagedBuildManager.updateBuildInfo(project, force);
                        }
                        catch (CoreException e) {
                            return e.getStatus();
                        }
                        return Status.OK_STATUS;
                    }
                };
                j.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
                j.setSystem(true);
                j.schedule();
                return true;
            }
            ManagedBuilderCorePlugin.log(e);
            return false;
        }
    }

    private static boolean updateBuildInfo(IProject project, boolean force) throws CoreException {
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project, false);
        if (info == null) {
            return true;
        }
        ICProjectDescription projDes = CoreModel.getDefault().getProjectDescription(project);
        projDes = BuildSettingsUtil.synchBuildInfo(info, projDes, force);
        BuildSettingsUtil.checkApplyDescription(project, projDes);
        return true;
    }

    public static void updateCoreSettings(IProject project) throws CoreException {
        ManagedBuildManager.updateBuildInfo(project, true);
    }

    public static void updateCoreSettings(IConfiguration cfg) throws CoreException {
        IProject project = cfg.getOwner().getProject();
        ICProjectDescription projDes = CoreModel.getDefault().getProjectDescription(project);
        if (projDes != null && BuildSettingsUtil.applyConfiguration(cfg, projDes, true)) {
            BuildSettingsUtil.checkApplyDescription(project, projDes);
        }
    }

    public static void updateCoreSettings(IProject project, IConfiguration[] cfgs) throws CoreException {
        ManagedBuildManager.updateCoreSettings(project, cfgs, false);
    }

    public static void updateCoreSettings(IProject project, IConfiguration[] cfgs, boolean avoidSerialization) throws CoreException {
        IManagedBuildInfo info;
        if (cfgs == null && (info = ManagedBuildManager.getBuildInfo((IResource)project)) != null && info.isValid() && info.getManagedProject() != null) {
            cfgs = info.getManagedProject().getConfigurations();
        }
        if (cfgs == null || cfgs.length == 0) {
            return;
        }
        ICProjectDescription projDes = CoreModel.getDefault().getProjectDescription(project);
        boolean updated = false;
        if (projDes != null) {
            IConfiguration[] iConfigurationArray = cfgs;
            int n = cfgs.length;
            int n2 = 0;
            while (n2 < n) {
                IConfiguration cfg = iConfigurationArray[n2];
                if (BuildSettingsUtil.applyConfiguration(cfg, projDes, true)) {
                    updated = true;
                }
                ++n2;
            }
            if (updated) {
                BuildSettingsUtil.checkApplyDescription(project, projDes, avoidSerialization);
            }
        }
    }

    public static void removeBuildInfo(IResource resource) {
    }

    public static void resetConfiguration(IProject project, IConfiguration configuration) {
        if (configuration instanceof MultiConfiguration) {
            IConfiguration[] cfs;
            IConfiguration[] iConfigurationArray = cfs = (IConfiguration[])((MultiConfiguration)configuration).getItems();
            int n = cfs.length;
            int n2 = 0;
            while (n2 < n) {
                IConfiguration c = iConfigurationArray[n2];
                ((Configuration)c).reset();
                ManagedBuildManager.performValueHandlerEvent(c, 3, false);
                ++n2;
            }
        } else {
            ((Configuration)configuration).reset();
            ManagedBuildManager.performValueHandlerEvent(configuration, 3, false);
        }
    }

    public static void resetResourceConfiguration(IProject project, IResourceConfiguration resConfig) {
        ((ResourceConfiguration)resConfig).reset();
        ManagedBuildManager.performValueHandlerEvent(resConfig, 3);
    }

    public static void resetOptionSettings(IResourceInfo rcInfo) {
        if (rcInfo instanceof IFileInfo) {
            IConfiguration c = rcInfo.getParent();
            Configuration cfg = null;
            IProject project = null;
            if (c instanceof Configuration) {
                cfg = (Configuration)c;
            } else if (c instanceof MultiConfiguration) {
                MultiConfiguration mc = (MultiConfiguration)c;
                IConfiguration[] cfs = (IConfiguration[])mc.getItems();
                cfg = (Configuration)cfs[0];
            }
            if (cfg != null && !cfg.isExtensionElement() && !cfg.isPreference()) {
                project = cfg.getOwner().getProject();
            }
            if (rcInfo instanceof MultiResourceInfo) {
                IResourceInfo[] iResourceInfoArray = (IResourceInfo[])((MultiResourceInfo)rcInfo).getItems();
                int n = iResourceInfoArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IResourceInfo ri = iResourceInfoArray[n2];
                    ManagedBuildManager.resetResourceConfiguration(project, (IFileInfo)ri);
                    ++n2;
                }
            } else {
                ManagedBuildManager.resetResourceConfiguration(project, (IFileInfo)rcInfo);
            }
        } else if (rcInfo instanceof MultiFolderInfo) {
            IFolderInfo[] iFolderInfoArray = (IFolderInfo[])((MultiFolderInfo)rcInfo).getItems();
            int n = iFolderInfoArray.length;
            int n3 = 0;
            while (n3 < n) {
                IFolderInfo fi = iFolderInfoArray[n3];
                ((FolderInfo)fi).resetOptionSettings();
                ++n3;
            }
        } else {
            FolderInfo fo = (FolderInfo)rcInfo;
            fo.resetOptionSettings();
        }
    }

    public static void addExtensionProjectType(ProjectType projectType) {
        if (projectTypes == null) {
            projectTypes = new ArrayList<IProjectType>();
        }
        projectTypes.add(projectType);
        IProjectType previous = ManagedBuildManager.getExtensionProjectTypeMap().put(projectType.getId(), projectType);
        if (previous != null) {
            ManagedBuildManager.outputDuplicateIdError("ProjectType", projectType.getId());
        }
    }

    public static void addExtensionConfiguration(Configuration configuration) {
        IConfiguration previous = ManagedBuildManager.getExtensionConfigurationMap().put(configuration.getId(), configuration);
        if (previous != null) {
            ManagedBuildManager.outputDuplicateIdError("Configuration", configuration.getId());
        }
    }

    public static void addExtensionResourceConfiguration(ResourceConfiguration resourceConfiguration) {
        IResourceConfiguration previous = ManagedBuildManager.getExtensionResourceConfigurationMap().put(resourceConfiguration.getId(), resourceConfiguration);
        if (previous != null) {
            ManagedBuildManager.outputDuplicateIdError("ResourceConfiguration", resourceConfiguration.getId());
        }
    }

    public static void addExtensionToolChain(ToolChain toolChain) {
        IToolChain previous = ManagedBuildManager.getExtensionToolChainMapInternal().put(toolChain.getId(), toolChain);
        if (previous != null) {
            ManagedBuildManager.outputDuplicateIdError("ToolChain", toolChain.getId());
        }
    }

    public static void addExtensionTool(Tool tool) {
        ITool previous = ManagedBuildManager.getExtensionToolMapInternal().put(tool.getId(), tool);
        if (previous != null) {
            ManagedBuildManager.outputDuplicateIdError("Tool", tool.getId());
        }
    }

    public static void addExtensionTargetPlatform(TargetPlatform targetPlatform) {
        ITargetPlatform previous = ManagedBuildManager.getExtensionTargetPlatformMap().put(targetPlatform.getId(), targetPlatform);
        if (previous != null) {
            ManagedBuildManager.outputDuplicateIdError("TargetPlatform", targetPlatform.getId());
        }
    }

    public static void addExtensionBuilder(Builder builder) {
        IBuilder previous = ManagedBuildManager.getExtensionBuilderMapInternal().put(builder.getId(), builder);
        if (previous != null) {
            ManagedBuildManager.outputDuplicateIdError("Builder", builder.getId());
        }
    }

    public static void addExtensionOption(Option option) {
        IOption previous = ManagedBuildManager.getExtensionOptionMap().put(option.getId(), option);
        if (previous != null) {
            ManagedBuildManager.outputDuplicateIdError("Option", option.getId());
        }
    }

    public static void addExtensionOptionCategory(OptionCategory optionCategory) {
        IOptionCategory previous = ManagedBuildManager.getExtensionOptionCategoryMap().put(optionCategory.getId(), optionCategory);
        if (previous != null) {
            ManagedBuildManager.outputDuplicateIdError("OptionCategory", optionCategory.getId());
        }
    }

    public static void addExtensionInputType(InputType inputType) {
        IInputType previous = ManagedBuildManager.getExtensionInputTypeMap().put(inputType.getId(), inputType);
        if (previous != null) {
            ManagedBuildManager.outputDuplicateIdError("InputType", inputType.getId());
        }
    }

    public static void addExtensionOutputType(OutputType outputType) {
        IOutputType previous = ManagedBuildManager.getExtensionOutputTypeMap().put(outputType.getId(), outputType);
        if (previous != null) {
            ManagedBuildManager.outputDuplicateIdError("OutputType", outputType.getId());
        }
    }

    public static void addExtensionTarget(Target target) {
        ManagedBuildManager.getExtensionTargetMap().put(target.getId(), target);
    }

    public static IManagedProject createManagedProject(IResource resource, IProjectType parent) throws BuildException {
        return new ManagedProject(resource, parent);
    }

    public static ITarget createTarget(IResource resource, ITarget parentTarget) throws BuildException {
        IResource owner = parentTarget.getOwner();
        if (owner != null && owner.equals((Object)resource)) {
            return parentTarget;
        }
        if (resource instanceof IProject) {
            if (owner != null) {
                throw new BuildException(ManagedMakeMessages.getResourceString("ManagedBuildManager.error.owner_not_null"));
            }
        } else {
            if (owner == null) {
                throw new BuildException(ManagedMakeMessages.getResourceString("ManagedBuildManager.error.null_owner"));
            }
            if (!owner.equals((Object)resource.getProject())) {
                throw new BuildException(ManagedMakeMessages.getResourceString("ManagedBuildManager.error.owner_not_project"));
            }
        }
        return new Target(resource, parentTarget);
    }

    public static IStatus initBuildInfoContainer(IResource resource) {
        return Status.OK_STATUS;
    }

    private static boolean isVersionCompatible(IExtension extension) {
        IConfigurationElement[] elements;
        Version version = null;
        IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (element.getName().equals(REVISION_ELEMENT_NAME)) {
                version = new Version(element.getAttribute(VERSION_ELEMENT_NAME));
                break;
            }
            ++n2;
        }
        if (version == null) {
            return true;
        }
        return buildInfoVersion.compareTo(version) >= 0;
    }

    private static boolean canLoadBuildInfo(IProject project) {
        IFile file = project.getFile(SETTINGS_FILE_NAME);
        if (file == null) {
            return false;
        }
        File cdtbuild = file.getLocation().toFile();
        if (cdtbuild == null) {
            return false;
        }
        return cdtbuild.exists();
    }

    private static ManagedBuildInfo loadOldStyleBuildInfo(IProject project) throws Exception {
        NodeList nodes;
        Version version;
        ManagedBuildInfo buildInfo = null;
        IFile file = project.getFile(SETTINGS_FILE_NAME);
        File cdtbuild = file.getLocation().toFile();
        if (!cdtbuild.exists()) {
            throw new BuildException(ManagedMakeMessages.getFormattedString(PROJECT_FILE_ERROR, project.getName()));
        }
        FileInputStream stream = new FileInputStream(cdtbuild);
        DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document document = parser.parse(stream);
        String fileVersion = null;
        Node rootElement = document.getFirstChild();
        if (rootElement.getNodeType() == 7 && buildInfoVersion.compareTo(version = new Version(fileVersion = rootElement.getNodeValue())) <= 0) {
            boolean compatible = false;
            if (version == null) {
                compatible = false;
            }
            if (buildInfoVersion.getMajor() != version.getMajor()) {
                compatible = false;
            }
            if (buildInfoVersion.getMinor() > version.getMinor()) {
                compatible = true;
            }
            if (buildInfoVersion.getMinor() < version.getMinor()) {
                compatible = false;
            }
            if (buildInfoVersion.getMicro() > version.getMicro()) {
                compatible = true;
            }
            if (buildInfoVersion.getMicro() < version.getMicro()) {
                compatible = false;
            }
            if (buildInfoVersion.getQualifier().compareTo(version.getQualifier()) >= 0) {
                compatible = true;
            }
            if (!compatible) {
                throw new BuildException(ManagedMakeMessages.getFormattedString(PROJECT_VERSION_ERROR, project.getName()));
            }
        }
        if ((nodes = document.getElementsByTagName(ROOT_NODE_NAME)).getLength() > 0) {
            IConfiguration[] configs;
            Version version21;
            Version version2;
            Node node = nodes.item(0);
            buildInfo = new ManagedBuildInfo((IResource)project, XmlStorageUtil.createCStorageTree((Element)((Element)node)), true, fileVersion);
            if (fileVersion != null && (version2 = new Version(fileVersion)).compareTo(version21 = new Version("2.1")) >= 0) {
                if (buildInfo.getManagedProject() == null || !buildInfo.getManagedProject().isValid()) {
                    throw new Exception(ManagedMakeMessages.getFormattedString("ManagedBuildManager.error.id.nomatch", project.getName()));
                }
                if (!(ManagedBuildManager.checkForMigrationSupport(buildInfo, false) || buildInfo.getManagedProject() != null && buildInfo.getManagedProject().isValid())) {
                    throw new Exception(ManagedMakeMessages.getFormattedString("ManagedBuildManager.error.id.nomatch", project.getName()));
                }
            }
            if (!UpdateManagedProjectManager.isCompatibleProject(buildInfo)) {
                UpdateManagedProjectManager.updateProject(project, buildInfo);
            }
            if (buildInfo.getManagedProject() == null || !buildInfo.getManagedProject().isValid()) {
                throw new Exception(ManagedMakeMessages.getFormattedString("ManagedBuildManager.error.id.nomatch", project.getName()));
            }
            if (!(ManagedBuildManager.checkForMigrationSupport(buildInfo, true) || buildInfo.getManagedProject() != null && buildInfo.getManagedProject().isValid())) {
                throw new Exception(ManagedMakeMessages.getFormattedString("ManagedBuildManager.error.id.nomatch", project.getName()));
            }
            IConfiguration[] iConfigurationArray = configs = buildInfo.getManagedProject().getConfigurations();
            int n = configs.length;
            int n2 = 0;
            while (n2 < n) {
                IConfiguration cfg = iConfigurationArray[n2];
                ManagedBuildManager.performValueHandlerEvent(cfg, 1);
                ++n2;
            }
            ManagedBuildManager.setLoaddedBuildInfo(project, buildInfo);
        }
        buildInfo.setValid(true);
        return buildInfo;
    }

    private static void loadExtensions() throws BuildException {
        if (projectTypesLoaded) {
            return;
        }
        ManagedBuildManager.loadExtensionsSynchronized();
    }

    private static synchronized void loadExtensionsSynchronized() throws BuildException {
        if (projectTypesLoaded) {
            return;
        }
        if (projectTypesLoading) {
            return;
        }
        projectTypesLoading = true;
        try {
            Object tools;
            IConfigurationElement element;
            IConfigurationElement[] iConfigurationElementArray;
            IExtension[] extensions;
            ArrayList<IManagedBuildDefinitionsStartup> buildDefStartupList = null;
            IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(EXTENSION_POINT_ID);
            if (extensionPoint != null && (extensions = extensionPoint.getExtensions()) != null) {
                IExtension[] iExtensionArray = extensions;
                int n = extensions.length;
                int n2 = 0;
                while (n2 < n) {
                    IExtension extension = iExtensionArray[n2];
                    if (!ManagedBuildManager.isVersionCompatible(extension)) {
                        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                        if (window == null) {
                            IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
                            window = windows[0];
                        }
                        final Shell shell = window.getShell();
                        final String errMsg = ManagedMakeMessages.getFormattedString(MANIFEST_VERSION_ERROR, extension.getUniqueIdentifier());
                        shell.getDisplay().asyncExec(new Runnable(){

                            public void run() {
                                MessageDialog.openError((Shell)shell, (String)ManagedMakeMessages.getResourceString("ManagedBuildManager.error.manifest_load_failed_title"), (String)errMsg);
                            }
                        });
                    } else {
                        IConfigurationElement[] elements = extension.getConfigurationElements();
                        String revision = null;
                        iConfigurationElementArray = elements;
                        int n3 = elements.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            element = iConfigurationElementArray[n4];
                            if (element.getName().equals(REVISION_ELEMENT_NAME)) {
                                revision = element.getAttribute(VERSION_ELEMENT_NAME);
                                break;
                            }
                            ++n4;
                        }
                        ManagedBuildManager.loadConfigElements(DefaultManagedConfigElement.convertArray(elements, extension), revision);
                    }
                    ++n2;
                }
                if (startUpConfigElements != null) {
                    buildDefStartupList = new ArrayList<IManagedBuildDefinitionsStartup>(startUpConfigElements.size());
                    for (IManagedConfigElement startUpConfigElement : startUpConfigElements) {
                        try {
                            IManagedBuildDefinitionsStartup customConfigLoader = ManagedBuildManager.createStartUpConfigLoader((DefaultManagedConfigElement)startUpConfigElement);
                            buildDefStartupList.add(customConfigLoader);
                            customConfigLoader.buildDefsLoaded();
                        }
                        catch (CoreException coreException) {}
                    }
                }
                Collection<IProjectType> prjTypes = ManagedBuildManager.getExtensionProjectTypeMap().values();
                for (IProjectType projectType : prjTypes) {
                    try {
                        ((ProjectType)projectType).resolveReferences();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                Collection<IConfiguration> configurations = ManagedBuildManager.getExtensionConfigurationMap().values();
                for (IConfiguration configuration : configurations) {
                    try {
                        ((Configuration)configuration).resolveReferences();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                Collection<IResourceConfiguration> resConfigs = ManagedBuildManager.getExtensionResourceConfigurationMap().values();
                for (IResourceConfiguration resConfig : resConfigs) {
                    try {
                        ((ResourceConfiguration)resConfig).resolveReferences();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                Collection<ToolChain> toolChains = ManagedBuildManager.getExtensionToolChainMapInternal().values();
                Iterator ex = toolChains.iterator();
                while (ex.hasNext()) {
                    ToolChain toolChain = (ToolChain)ex.next();
                    try {
                        toolChain.resolveReferences();
                    }
                    catch (Exception ex2) {
                        ex2.printStackTrace();
                    }
                }
                tools = ManagedBuildManager.getExtensionToolMapInternal().values();
                Iterator ex2 = tools.iterator();
                while (ex2.hasNext()) {
                    Tool tool = (Tool)ex2.next();
                    try {
                        tool.resolveReferences();
                    }
                    catch (Exception ex3) {
                        ex3.printStackTrace();
                    }
                }
                Collection<ITargetPlatform> targetPlatforms = ManagedBuildManager.getExtensionTargetPlatformMap().values();
                for (ITargetPlatform targetPlatform : targetPlatforms) {
                    try {
                        ((TargetPlatform)targetPlatform).resolveReferences();
                    }
                    catch (Exception ex4) {
                        ex4.printStackTrace();
                    }
                }
                Collection<Builder> builders = ManagedBuildManager.getExtensionBuilderMapInternal().values();
                for (Builder builder : builders) {
                    try {
                        builder.resolveReferences();
                    }
                    catch (Exception ex5) {
                        ex5.printStackTrace();
                    }
                }
                Collection<IOption> options = ManagedBuildManager.getExtensionOptionMap().values();
                for (IOption option : options) {
                    try {
                        ((Option)option).resolveReferences();
                    }
                    catch (Exception ex6) {
                        ex6.printStackTrace();
                    }
                }
                Collection<IOptionCategory> optionCategories = ManagedBuildManager.getExtensionOptionCategoryMap().values();
                for (IOptionCategory optionCat : optionCategories) {
                    try {
                        ((OptionCategory)optionCat).resolveReferences();
                    }
                    catch (Exception ex7) {
                        ex7.printStackTrace();
                    }
                }
            }
            if ((extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(EXTENSION_POINT_ID_V2)) != null) {
                extensions = extensionPoint.getExtensions();
                String revision = null;
                if (extensions != null && extensions.length > 0) {
                    tools = extensions;
                    int toolChains = extensions.length;
                    int resConfigs = 0;
                    while (resConfigs < toolChains) {
                        IConfigurationElement[] elements;
                        IExtension extension = tools[resConfigs];
                        if (!ManagedBuildManager.isVersionCompatible(extension)) {
                            throw new BuildException(ManagedMakeMessages.getResourceString(MANIFEST_VERSION_ERROR));
                        }
                        iConfigurationElementArray = elements = extension.getConfigurationElements();
                        int n = elements.length;
                        int n5 = 0;
                        while (n5 < n) {
                            element = iConfigurationElementArray[n5];
                            if (element.getName().equals(REVISION_ELEMENT_NAME)) {
                                revision = element.getAttribute(VERSION_ELEMENT_NAME);
                                break;
                            }
                            ++n5;
                        }
                        if (revision == null) {
                            revision = "1.2.0";
                        }
                        ManagedBuildManager.loadConfigElementsV2(DefaultManagedConfigElement.convertArray(elements, extension), revision);
                        ++resConfigs;
                    }
                    Collection<ITarget> targets = ManagedBuildManager.getExtensionTargetMap().values();
                    for (ITarget target : targets) {
                        try {
                            ((Target)target).resolveReferences();
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                    Collection<Tool> tools2 = ManagedBuildManager.getExtensionToolMapInternal().values();
                    for (Tool tool : tools2) {
                        try {
                            tool.resolveReferences();
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                    targets = ManagedBuildManager.getExtensionTargetMap().values();
                    for (ITarget target : targets) {
                        try {
                            if (target.getCreatedProjectType() != null) continue;
                            target.convertToProjectType(revision);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                    Collection<IProjectType> prjTypes = ManagedBuildManager.getExtensionProjectTypeMap().values();
                    for (IProjectType prjType : prjTypes) {
                        try {
                            ((ProjectType)prjType).resolveReferences();
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                }
            }
            if (buildDefStartupList != null) {
                for (IManagedBuildDefinitionsStartup customConfigLoader : buildDefStartupList) {
                    customConfigLoader.buildDefsResolved();
                }
            }
            ManagedBuildManager.performAdjustments();
            projectTypesLoading = false;
            projectTypesLoaded = true;
            ToolChainModificationManager.getInstance().start();
        }
        finally {
            configElementMap = null;
        }
    }

    private static void performAdjustments() {
        IConfiguration cfg;
        int n;
        int n2;
        IConfiguration[] iConfigurationArray;
        IConfiguration[] cfgs;
        IProjectType type;
        IProjectType[] types;
        IProjectType[] iProjectTypeArray = types = ManagedBuildManager.getDefinedProjectTypes();
        int n3 = types.length;
        int n4 = 0;
        while (n4 < n3) {
            type = iProjectTypeArray[n4];
            iConfigurationArray = cfgs = type.getConfigurations();
            n2 = cfgs.length;
            n = 0;
            while (n < n2) {
                cfg = iConfigurationArray[n];
                ManagedBuildManager.adjustConfig(cfg);
                ++n;
            }
            ++n4;
        }
        iProjectTypeArray = types;
        n3 = types.length;
        n4 = 0;
        while (n4 < n3) {
            type = iProjectTypeArray[n4];
            iConfigurationArray = cfgs = type.getConfigurations();
            n2 = cfgs.length;
            n = 0;
            while (n < n2) {
                cfg = iConfigurationArray[n];
                ManagedBuildManager.performValueHandlerEvent(cfg, 5);
                ++n;
            }
            ++n4;
        }
    }

    private static void adjustConfig(IConfiguration cfg) {
        IResourceInfo[] rcInfos;
        IResourceInfo[] iResourceInfoArray = rcInfos = cfg.getResourceInfos();
        int n = rcInfos.length;
        int n2 = 0;
        while (n2 < n) {
            int n3;
            IResourceInfo info;
            IResourceInfo rcInfo = iResourceInfoArray[n2];
            if (rcInfo instanceof IFolderInfo) {
                ITool[] tools;
                info = (IFolderInfo)rcInfo;
                IToolChain tc = info.getToolChain();
                ManagedBuildManager.adjustHolder(info, tc);
                ITool[] iToolArray = tools = tc.getTools();
                int n4 = tools.length;
                n3 = 0;
                while (n3 < n4) {
                    ITool tool = iToolArray[n3];
                    ManagedBuildManager.adjustHolder(info, tool);
                    ++n3;
                }
            } else if (rcInfo instanceof IFileInfo) {
                ITool[] rcTools;
                info = (IFileInfo)rcInfo;
                ITool[] iToolArray = rcTools = info.getTools();
                n3 = rcTools.length;
                int n5 = 0;
                while (n5 < n3) {
                    ITool rcTool = iToolArray[n5];
                    ManagedBuildManager.adjustHolder(info, rcTool);
                    ++n5;
                }
            }
            ++n2;
        }
        cfg.getResourceConfigurations();
    }

    private static void adjustHolder(IResourceInfo rcInfo, IHoldsOptions holder) {
        IOption[] options;
        IOption[] iOptionArray = options = holder.getOptions();
        int n = options.length;
        int n2 = 0;
        while (n2 < n) {
            IOption opt = iOptionArray[n2];
            Option option = (Option)opt;
            BooleanExpressionApplicabilityCalculator calc = option.getBooleanExpressionCalculator(true);
            if (calc != null) {
                calc.adjustOption(rcInfo, holder, option, true);
            }
            ++n2;
        }
    }

    private static void loadConfigElements(IManagedConfigElement[] elements, String revision) {
        IManagedConfigElement[] iManagedConfigElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IManagedConfigElement element = iManagedConfigElementArray[n2];
            try {
                if (element.getName().equals("projectType")) {
                    new ProjectType(element, revision);
                } else if (element.getName().equals("configuration")) {
                    new Configuration(null, element, revision);
                } else if (element.getName().equals("toolChain")) {
                    new ToolChain(null, element, revision);
                } else if (element.getName().equals("tool")) {
                    new Tool(null, element, revision);
                } else if (element.getName().equals("targetPlatform")) {
                    new TargetPlatform(null, element, revision);
                } else if (element.getName().equals("builder")) {
                    new Builder(null, element, revision);
                } else if (element.getName().equals("dynamicElementProvider")) {
                    if (element instanceof DefaultManagedConfigElement) {
                        IManagedConfigElementProvider provider = ManagedBuildManager.createConfigProvider((DefaultManagedConfigElement)element);
                        IManagedConfigElement[] providedConfigs = provider.getConfigElements();
                        ManagedBuildManager.loadConfigElements(providedConfigs, revision);
                    }
                } else if (element.getName().equals("buildDefinitionStartup") && element instanceof DefaultManagedConfigElement) {
                    if (startUpConfigElements == null) {
                        startUpConfigElements = new ArrayList<IManagedConfigElement>();
                    }
                    startUpConfigElements.add(element);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            ++n2;
        }
    }

    private static void loadConfigElementsV2(IManagedConfigElement[] elements, String revision) {
        IManagedConfigElement[] iManagedConfigElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IManagedConfigElement element = iManagedConfigElementArray[n2];
            try {
                if (element.getName().equals("tool")) {
                    new Tool(element, revision);
                } else if (element.getName().equals("target")) {
                    new Target(element, revision);
                } else if (element.getName().equals("dynamicElementProvider") && element instanceof DefaultManagedConfigElement) {
                    IManagedConfigElementProvider provider = ManagedBuildManager.createConfigProvider((DefaultManagedConfigElement)element);
                    IManagedConfigElement[] providedConfigs = provider.getConfigElements();
                    ManagedBuildManager.loadConfigElementsV2(providedConfigs, revision);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            ++n2;
        }
    }

    public static ManagedBuildInfo createBuildInfo(IResource resource) {
        IProject proj = resource.getProject();
        ManagedBuildInfo buildInfo = new ManagedBuildInfo((IResource)proj);
        try {
            ManagedBuildManager.setLoaddedBuildInfo(proj, buildInfo);
        }
        catch (CoreException e) {
            ManagedBuilderCorePlugin.log(e);
            buildInfo = null;
        }
        return buildInfo;
    }

    public static void setLoaddedBuildInfo(IProject project, IManagedBuildInfo info) throws CoreException {
        ManagedBuildManager.doSetLoaddedInfo(project, info, true);
    }

    private static synchronized void doSetLoaddedInfo(IProject project, IManagedBuildInfo info, boolean overwrite) {
        if (!overwrite && fInfoMap.get(project) != null) {
            return;
        }
        if (info != null) {
            fInfoMap.put(project, info);
            if (BuildDbgUtil.DEBUG) {
                BuildDbgUtil.getInstance().traceln(1, "build info load: build info set for project " + project.getName());
            }
        } else {
            fInfoMap.remove(project);
            if (BuildDbgUtil.DEBUG) {
                BuildDbgUtil.getInstance().traceln(1, "build info load: build info CLEARED for project " + project.getName());
            }
        }
    }

    private static IManagedConfigElementProvider createConfigProvider(DefaultManagedConfigElement element) throws CoreException {
        return (IManagedConfigElementProvider)element.getConfigurationElement().createExecutableExtension("class");
    }

    private static IManagedBuildDefinitionsStartup createStartUpConfigLoader(DefaultManagedConfigElement element) throws CoreException {
        return (IManagedBuildDefinitionsStartup)element.getConfigurationElement().createExecutableExtension("class");
    }

    public static boolean manages(IResource resource) {
        ICProjectDescription des = CoreModel.getDefault().getProjectDescription(resource.getProject(), false);
        if (des == null) {
            return false;
        }
        ICConfigurationDescription cfgDes = des.getActiveConfiguration();
        IConfiguration cfg = ManagedBuildManager.getConfigurationForDescription(cfgDes);
        return cfg != null;
    }

    private static ManagedBuildInfo findBuildInfo(IResource rc, boolean forceLoad) {
        if (rc == null) {
            if (BuildDbgUtil.DEBUG) {
                BuildDbgUtil.getInstance().traceln(1, "build info load: null resource");
            }
            return null;
        }
        ManagedBuildInfo buildInfo = null;
        IProject proj = rc.getProject();
        if (BuildDbgUtil.DEBUG) {
            BuildDbgUtil.getInstance().traceln(1, "build info load: info is null, querying the update mngr");
        }
        if ((buildInfo = UpdateManagedProjectManager.getConvertedManagedBuildInfo(proj)) != null) {
            return buildInfo;
        }
        try {
            buildInfo = ManagedBuildManager.getLoadedBuildInfo(proj);
        }
        catch (CoreException e) {
            if (BuildDbgUtil.DEBUG) {
                BuildDbgUtil.getInstance().traceln(1, "build info load: core exception while getting the loaded info: " + e.getLocalizedMessage());
            }
            return null;
        }
        if (buildInfo == null) {
            ICProjectDescription projDes;
            int flags;
            int n = flags = forceLoad ? 0 : 8;
            if (BuildDbgUtil.DEBUG) {
                BuildDbgUtil.getInstance().traceln(1, "build info load: build info is NOT loaded" + (forceLoad ? " forceload" : ""));
            }
            if ((projDes = CoreModel.getDefault().getProjectDescriptionManager().getProjectDescription(proj, flags)) != null) {
                if (BuildDbgUtil.DEBUG) {
                    BuildDbgUtil.getInstance().traceln(1, "build info load: project description is obtained, qwerying the loaded build info");
                }
                try {
                    buildInfo = ManagedBuildManager.getLoadedBuildInfo(proj);
                }
                catch (CoreException e) {
                    if (BuildDbgUtil.DEBUG) {
                        BuildDbgUtil.getInstance().traceln(1, "build info load: core exception while getting the loaded info (2): " + e.getLocalizedMessage());
                    }
                    return null;
                }
                if (buildInfo == null) {
                    if (BuildDbgUtil.DEBUG) {
                        BuildDbgUtil.getInstance().traceln(1, "build info load: info is null, trying the cfg data provider");
                    }
                    if ((buildInfo = ConfigurationDataProvider.getLoaddedBuildInfo(projDes)) != null) {
                        if (BuildDbgUtil.DEBUG) {
                            BuildDbgUtil.getInstance().traceln(1, "build info load: info found, setting as loaded");
                        }
                        try {
                            ManagedBuildManager.setLoaddedBuildInfo(proj, buildInfo);
                        }
                        catch (CoreException e) {
                            if (BuildDbgUtil.DEBUG) {
                                BuildDbgUtil.getInstance().traceln(1, "build info load: core exception while setting loaded description, ignoring; : " + e.getLocalizedMessage());
                            }
                        }
                    }
                }
            } else if (BuildDbgUtil.DEBUG) {
                BuildDbgUtil.getInstance().traceln(1, "build info load: project description in null");
            }
        }
        if (buildInfo != null) {
            buildInfo.updateOwner((IResource)proj);
        }
        if (BuildDbgUtil.DEBUG && buildInfo == null) {
            BuildDbgUtil.getInstance().traceln(1, "build info load: build info is null");
        }
        return buildInfo;
    }

    static synchronized ManagedBuildInfo getLoadedBuildInfo(IProject project) throws CoreException {
        ManagedBuildInfo buildInfo = (ManagedBuildInfo)fInfoMap.get(project);
        if (buildInfo != null) {
            buildInfo.updateOwner((IResource)project);
        }
        return buildInfo;
    }

    private static boolean canFindBuildInfo(IResource resource) {
        if (resource == null) {
            return false;
        }
        try {
            ManagedBuildManager.loadExtensions();
        }
        catch (BuildException e) {
            e.printStackTrace();
            return false;
        }
        ManagedBuildInfo buildInfo = null;
        try {
            buildInfo = ManagedBuildManager.getLoadedBuildInfo(resource.getProject());
        }
        catch (CoreException coreException) {}
        if (buildInfo == null && resource instanceof IProject) {
            buildInfo = UpdateManagedProjectManager.getConvertedManagedBuildInfo((IProject)resource);
            if (buildInfo != null) {
                return true;
            }
            return ManagedBuildManager.canLoadBuildInfo((IProject)resource);
        }
        return buildInfo != null;
    }

    public static IManagedBuildInfo getBuildInfo(IResource resource) {
        return ManagedBuildManager.getBuildInfo(resource, true);
    }

    public static IManagedBuildInfo getOldStyleBuildInfo(IProject project) throws CoreException {
        ManagedBuildInfo info = null;
        try {
            info = ManagedBuildManager.getLoadedBuildInfo(project);
        }
        catch (CoreException coreException) {}
        if (info == null) {
            try {
                info = ManagedBuildManager.loadOldStyleBuildInfo(project);
                if (info != null) {
                    ManagedBuildManager.doSetLoaddedInfo(project, info, false);
                }
            }
            catch (Exception e) {
                throw new CoreException((IStatus)new Status(4, ManagedBuilderCorePlugin.getUniqueIdentifier(), e.getLocalizedMessage(), (Throwable)e));
            }
        }
        return info;
    }

    public static synchronized IManagedBuildInfo getBuildInfoLegacy(IProject project) {
        try {
            return ManagedBuildManager.getOldStyleBuildInfo(project);
        }
        catch (CoreException e) {
            ManagedBuilderCorePlugin.log(e);
            return null;
        }
    }

    public static IManagedBuildInfo getBuildInfo(IResource resource, boolean forceLoad) {
        return ManagedBuildManager.findBuildInfo((IResource)resource.getProject(), forceLoad);
    }

    public static boolean canGetBuildInfo(IResource resource) {
        return ManagedBuildManager.canFindBuildInfo((IResource)resource.getProject());
    }

    public static Version getBuildInfoVersion() {
        return buildInfoVersion;
    }

    public static URL getURLInBuildDefinitions(DefaultManagedConfigElement element, IPath path) {
        IExtension[] extensions;
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(EXTENSION_POINT_ID);
        if (extensionPoint != null && (extensions = extensionPoint.getExtensions()) != null) {
            IExtension[] iExtensionArray = extensions;
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                if (element.getExtension().getExtensionPointUniqueIdentifier() == extension.getExtensionPointUniqueIdentifier()) {
                    Bundle bundle = Platform.getBundle((String)extension.getNamespace());
                    URL url = Platform.find((Bundle)bundle, (IPath)path);
                    if (url != null) {
                        try {
                            return Platform.asLocalURL((URL)url);
                        }
                        catch (IOException iOException) {
                            return null;
                        }
                    }
                    ManagedBuildManager.outputIconError(path.toString());
                }
                ++n2;
            }
        }
        return null;
    }

    private static Map<IResource, List<IScannerInfoChangeListener>> getBuildModelListeners() {
        if (buildModelListeners == null) {
            buildModelListeners = new HashMap<IResource, List<IScannerInfoChangeListener>>();
        }
        return buildModelListeners;
    }

    private static Map<IBuildObject, IManagedConfigElement> getConfigElementMap() {
        if (!projectTypesLoading) {
            throw new IllegalStateException();
        }
        if (configElementMap == null) {
            configElementMap = new HashMap<IBuildObject, IManagedConfigElement>();
        }
        return configElementMap;
    }

    public static void putConfigElement(IBuildObject buildObj, IManagedConfigElement configElement) {
        ManagedBuildManager.getConfigElementMap().put(buildObj, configElement);
    }

    private static void removeConfigElement(IBuildObject buildObj) {
        ManagedBuildManager.getConfigElementMap().remove(buildObj);
    }

    public static IManagedConfigElement getConfigElement(IBuildObject buildObj) {
        return ManagedBuildManager.getConfigElementMap().get(buildObj);
    }

    public static void optionValidError(int errorId, String id) {
        String[] msgs = new String[]{id};
        switch (errorId) {
            case 0: {
                ManagedBuildManager.outputManifestError(ManagedMakeMessages.getFormattedString(MANIFEST_ERROR_OPTION_CATEGORY, msgs));
                break;
            }
            case 1: {
                ManagedBuildManager.outputManifestError(ManagedMakeMessages.getFormattedString(MANIFEST_ERROR_OPTION_FILTER, msgs));
            }
        }
    }

    public static void optionValueHandlerError(String attribute, String id) {
        String[] msgs = new String[]{attribute, id};
        ManagedBuildManager.outputManifestError(ManagedMakeMessages.getFormattedString(MANIFEST_ERROR_OPTION_VALUEHANDLER, msgs));
    }

    public static void outputResolveError(String attribute, String lookupId, String type, String id) {
        String[] msgs = new String[]{attribute, lookupId, type, id};
        ManagedBuildManager.outputManifestError(ManagedMakeMessages.getFormattedString(MANIFEST_ERROR_RESOLVING, msgs));
    }

    public static void outputDuplicateIdError(String type, String id) {
        String[] msgs = new String[]{type, id};
        ManagedBuildManager.outputManifestError(ManagedMakeMessages.getFormattedString(MANIFEST_ERROR_DUPLICATE, msgs));
    }

    public static void outputManifestError(String message) {
        System.err.println(String.valueOf(ManagedMakeMessages.getResourceString(MANIFEST_ERROR_HEADER)) + message + NEWLINE);
    }

    public static void outputIconError(String iconLocation) {
        String[] msgs = new String[]{iconLocation};
        ManagedBuildManager.outputManifestError(ManagedMakeMessages.getFormattedString(MANIFEST_ERROR_ICON, msgs));
    }

    public static IEnvironmentVariableProvider getEnvironmentVariableProvider() {
        return EnvironmentVariableProvider.getDefault();
    }

    public static String getVersionFromIdAndVersion(String idAndVersion) {
        int index = idAndVersion.lastIndexOf(95);
        if (index != -1) {
            String version = idAndVersion.substring(index + 1);
            try {
                Version.parseVersion((String)version);
                return version;
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return null;
    }

    public static String getIdFromIdAndVersion(String idAndVersion) {
        if (ManagedBuildManager.getVersionFromIdAndVersion(idAndVersion) != null) {
            int index = idAndVersion.lastIndexOf(95);
            return idAndVersion.substring(0, index);
        }
        return idAndVersion;
    }

    public static IBuildMacroProvider getBuildMacroProvider() {
        return BuildMacroProvider.getDefault();
    }

    public static void performValueHandlerEvent(IConfiguration config, int event) {
        ManagedBuildManager.performValueHandlerEvent(config, event, true);
    }

    public static void performValueHandlerEvent(IConfiguration config, int event, boolean doChildren) {
        ITool[] tools;
        IOption[] options;
        IToolChain toolChain = config.getToolChain();
        if (toolChain == null) {
            return;
        }
        IOption[] iOptionArray = options = toolChain.getOptions();
        int n = options.length;
        int n2 = 0;
        while (n2 < n) {
            IOption option = iOptionArray[n2];
            if (option.isValid()) {
                option.getValueHandler().handleValue(config, toolChain, option, option.getValueHandlerExtraArgument(), event);
            }
            ++n2;
        }
        ITool[] iToolArray = tools = config.getFilteredTools();
        int n3 = tools.length;
        n = 0;
        while (n < n3) {
            IOption[] toolOptions;
            ITool tool = iToolArray[n];
            IOption[] iOptionArray2 = toolOptions = tool.getOptions();
            int n4 = toolOptions.length;
            int n5 = 0;
            while (n5 < n4) {
                IOption toolOption = iOptionArray2[n5];
                if (toolOption.isValid()) {
                    toolOption.getValueHandler().handleValue(config, tool, toolOption, toolOption.getValueHandlerExtraArgument(), event);
                }
                ++n5;
            }
            ++n;
        }
        if (doChildren) {
            IResourceConfiguration[] resConfigs;
            IResourceConfiguration[] iResourceConfigurationArray = resConfigs = config.getResourceConfigurations();
            int n6 = resConfigs.length;
            n3 = 0;
            while (n3 < n6) {
                IResourceConfiguration resConfig = iResourceConfigurationArray[n3];
                ManagedBuildManager.performValueHandlerEvent(resConfig, event);
                ++n3;
            }
        }
    }

    public static void performValueHandlerEvent(IResourceInfo config, int event) {
        ITool[] tools;
        ITool[] iToolArray = tools = config instanceof IFileInfo ? ((IFileInfo)config).getToolsToInvoke() : ((IFolderInfo)config).getFilteredTools();
        int n = tools.length;
        int n2 = 0;
        while (n2 < n) {
            IOption[] toolOptions;
            ITool tool = iToolArray[n2];
            IOption[] iOptionArray = toolOptions = tool.getOptions();
            int n3 = toolOptions.length;
            int n4 = 0;
            while (n4 < n3) {
                IOption toolOption = iOptionArray[n4];
                if (toolOption.isValid()) {
                    toolOption.getValueHandler().handleValue(config, tool, toolOption, toolOption.getValueHandlerExtraArgument(), event);
                }
                ++n4;
            }
            ++n2;
        }
    }

    private static boolean checkForMigrationSupport(ManagedBuildInfo buildInfo, boolean forCurrentMbsVersion) {
        IConfigurationElement element = null;
        IManagedProject managedProject = buildInfo.getManagedProject();
        IProjectType projectType = managedProject.getProjectType();
        element = forCurrentMbsVersion ? ((ProjectType)projectType).getCurrentMbsVersionConversionElement() : ((ProjectType)projectType).getPreviousMbsVersionConversionElement();
        if (element != null) {
            if (ManagedBuildManager.invokeConverter(buildInfo, managedProject, element) == null) {
                buildInfo.getManagedProject().setValid(false);
                return false;
            }
        } else {
            IConfiguration[] configs;
            IConfiguration[] iConfigurationArray = configs = managedProject.getConfigurations();
            int n = configs.length;
            int n2 = 0;
            while (n2 < n) {
                IResourceConfiguration[] resourceConfigs;
                int n3;
                int n4;
                IBuildObject[] iBuildObjectArray;
                IConfiguration configuration = iConfigurationArray[n2];
                IToolChain toolChain = configuration.getToolChain();
                element = forCurrentMbsVersion ? ((ToolChain)toolChain).getCurrentMbsVersionConversionElement() : ((ToolChain)toolChain).getPreviousMbsVersionConversionElement();
                if (element != null) {
                    if (ManagedBuildManager.invokeConverter(buildInfo, toolChain, element) == null) {
                        buildInfo.getManagedProject().setValid(false);
                        return false;
                    }
                } else {
                    ITool[] tools = toolChain.getTools();
                    iBuildObjectArray = tools;
                    n4 = tools.length;
                    n3 = 0;
                    while (n3 < n4) {
                        ITool tool = iBuildObjectArray[n3];
                        element = forCurrentMbsVersion ? ((Tool)tool).getCurrentMbsVersionConversionElement() : ((Tool)tool).getPreviousMbsVersionConversionElement();
                        if (element != null && ManagedBuildManager.invokeConverter(buildInfo, tool, element) == null) {
                            buildInfo.getManagedProject().setValid(false);
                            return false;
                        }
                        ++n3;
                    }
                    IBuilder builder = toolChain.getBuilder();
                    if (builder != null && (element = forCurrentMbsVersion ? ((Builder)builder).getCurrentMbsVersionConversionElement() : ((Builder)builder).getPreviousMbsVersionConversionElement()) != null && ManagedBuildManager.invokeConverter(buildInfo, builder, element) == null) {
                        buildInfo.getManagedProject().setValid(false);
                        return false;
                    }
                }
                if ((resourceConfigs = configuration.getResourceConfigurations()) != null && resourceConfigs.length > 0) {
                    iBuildObjectArray = resourceConfigs;
                    n4 = resourceConfigs.length;
                    n3 = 0;
                    while (n3 < n4) {
                        ITool[] resTools;
                        IBuildObject resConfig = iBuildObjectArray[n3];
                        ITool[] iToolArray = resTools = resConfig.getTools();
                        int n5 = resTools.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            ITool resTool = iToolArray[n6];
                            element = forCurrentMbsVersion ? ((Tool)resTool).getCurrentMbsVersionConversionElement() : ((Tool)resTool).getPreviousMbsVersionConversionElement();
                            if (element != null && ManagedBuildManager.invokeConverter(buildInfo, resTool, element) == null) {
                                buildInfo.getManagedProject().setValid(false);
                                return false;
                            }
                            ++n6;
                        }
                        ++n3;
                    }
                }
                ++n2;
            }
        }
        return true;
    }

    private static IBuildObject invokeConverter(ManagedBuildInfo bi, IBuildObject buildObject, IConfigurationElement element) {
        if (element != null) {
            IConvertManagedBuildObject convertBuildObject = null;
            String toId = element.getAttribute("toId");
            String fromId = element.getAttribute("fromId");
            try {
                convertBuildObject = (IConvertManagedBuildObject)element.createExecutableExtension("class");
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            if (convertBuildObject != null) {
                IProject prj = null;
                IBuildObject result = null;
                try {
                    if (bi != null) {
                        prj = (IProject)bi.getManagedProject().getOwner();
                        UpdateManagedProjectManager.addInfo(prj, bi);
                    }
                    result = convertBuildObject.convert(buildObject, fromId, toId, false);
                }
                catch (Throwable throwable) {
                    if (bi != null) {
                        UpdateManagedProjectManager.delInfo(prj);
                    }
                    throw throwable;
                }
                if (bi != null) {
                    UpdateManagedProjectManager.delInfo(prj);
                }
                return result;
            }
        }
        return null;
    }

    public static IBuildObject convert(IBuildObject buildObj, String toId, boolean userhasConfirmed) {
        String tmpToId = null;
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.cdt.managedbuilder.core", "projectConverter");
        if (extensionPoint != null) {
            IExtension[] extensions;
            IExtension[] iExtensionArray = extensions = extensionPoint.getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] configElements;
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = configElements = extension.getConfigurationElements();
                int n3 = configElements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    if (element.getName().equals("converter") && ManagedBuildManager.isBuildObjectApplicableForConversion(buildObj, element) && (tmpToId = element.getAttribute("toId")).equals(toId)) {
                        return ManagedBuildManager.invokeConverter(null, buildObj, element);
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return null;
    }

    public static boolean hasTargetConversionElements(IBuildObject buildObj) {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.cdt.managedbuilder.core", "projectConverter");
        if (extensionPoint != null) {
            IExtension[] extensions;
            IExtension[] iExtensionArray = extensions = extensionPoint.getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] configElements;
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = configElements = extension.getConfigurationElements();
                int n3 = configElements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    if (element.getName().equals("converter") && ManagedBuildManager.isBuildObjectApplicableForConversion(buildObj, element)) {
                        return true;
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return false;
    }

    public static Map<String, IConfigurationElement> getConversionElements(IBuildObject buildObj) {
        HashMap<String, IConfigurationElement> conversionTargets = new HashMap<String, IConfigurationElement>();
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.cdt.managedbuilder.core", "projectConverter");
        if (extensionPoint != null) {
            IExtension[] extensions;
            IExtension[] iExtensionArray = extensions = extensionPoint.getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] configElements;
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = configElements = extension.getConfigurationElements();
                int n3 = configElements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    if (element.getName().equals("converter") && ManagedBuildManager.isBuildObjectApplicableForConversion(buildObj, element)) {
                        conversionTargets.put(element.getAttribute("name"), element);
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return conversionTargets;
    }

    private static boolean isBuildObjectApplicableForConversion(IBuildObject buildObj, IConfigurationElement element) {
        block9: {
            String fromId;
            String id;
            block11: {
                block10: {
                    block8: {
                        id = null;
                        fromId = element.getAttribute("fromId");
                        if (!(buildObj instanceof IProjectType)) break block8;
                        IProjectType projType = (IProjectType)buildObj;
                        while (projType != null) {
                            id = projType.getId();
                            if (fromId.equals(id)) {
                                return true;
                            }
                            projType = projType.getSuperClass();
                        }
                        break block9;
                    }
                    if (!(buildObj instanceof IToolChain)) break block10;
                    IToolChain toolChain = (IToolChain)buildObj;
                    while (toolChain != null) {
                        id = toolChain.getId();
                        if (fromId.equals(id)) {
                            return true;
                        }
                        toolChain = toolChain.getSuperClass();
                    }
                    break block9;
                }
                if (!(buildObj instanceof ITool)) break block11;
                ITool tool = (ITool)buildObj;
                while (tool != null) {
                    id = tool.getId();
                    if (fromId.equals(id)) {
                        return true;
                    }
                    tool = tool.getSuperClass();
                }
                break block9;
            }
            if (!(buildObj instanceof IBuilder)) break block9;
            IBuilder builder = (IBuilder)buildObj;
            while (builder != null) {
                id = builder.getId();
                if (fromId.equals(id)) {
                    return true;
                }
                builder = builder.getSuperClass();
            }
        }
        return false;
    }

    public static String calculateChildId(String superId, String suffix) {
        String version;
        if (suffix == null) {
            suffix = new Integer(ManagedBuildManager.getRandomNumber()).toString();
        }
        if ((version = ManagedBuildManager.getVersionFromIdAndVersion(superId)) != null) {
            return String.valueOf(ManagedBuildManager.getIdFromIdAndVersion(superId)) + "." + suffix + "_" + version;
        }
        return String.valueOf(superId) + "." + suffix;
    }

    private static int isInt(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public static String calculateBaseId(String id) {
        int index = id.lastIndexOf(46);
        if (index < 0) {
            return id;
        }
        String lastSeg = id.substring(index + 1, id.length());
        if (ManagedBuildManager.isInt(lastSeg) > 0) {
            String baseId = id.substring(0, index);
            return baseId;
        }
        return ManagedBuildManager.getIdFromIdAndVersion(id);
    }

    public static IPath calculateRelativePath(IPath container, IPath contents) {
        IPath path = contents;
        if (container.isPrefixOf(contents)) {
            path = contents.setDevice(null).removeFirstSegments(container.segmentCount());
        } else {
            String file = null;
            container = container.addTrailingSeparator();
            if (!contents.hasTrailingSeparator()) {
                file = contents.lastSegment();
                contents = contents.removeLastSegments(1);
                contents = contents.addTrailingSeparator();
            }
            IPath prefix = contents;
            while (prefix.segmentCount() > 0 && !prefix.isPrefixOf(container)) {
                prefix = prefix.removeLastSegments(1);
            }
            if (prefix.segmentCount() > 0) {
                int diff = container.segmentCount() - prefix.segmentCount();
                StringBuffer buff = new StringBuffer();
                while (diff-- > 0) {
                    buff.append("../");
                }
                path = new Path(buff.toString()).append(contents.removeFirstSegments(prefix.segmentCount()));
                if (file != null) {
                    path = path.append(file);
                }
            }
        }
        return path;
    }

    public static IConfiguration getConfigurationForDescription(ICConfigurationDescription cfgDes) {
        return ManagedBuildManager.getConfigurationForDescription(cfgDes, false);
    }

    private static IConfiguration getConfigurationForDescription(ICConfigurationDescription cfgDes, boolean checkConsistance) {
        if (cfgDes == null) {
            return null;
        }
        if (cfgDes instanceof ICMultiConfigDescription) {
            ICMultiConfigDescription mcd = (ICMultiConfigDescription)cfgDes;
            ICConfigurationDescription[] cfds = (ICConfigurationDescription[])mcd.getItems();
            return new MultiConfiguration(cfds);
        }
        CConfigurationData cfgData = cfgDes.getConfigurationData();
        if (cfgData instanceof BuildConfigurationData) {
            IConfiguration cfg = ((BuildConfigurationData)cfgData).getConfiguration();
            if (checkConsistance && cfgDes != ManagedBuildManager.getDescriptionForConfiguration(cfg, false)) {
                throw new IllegalStateException();
            }
            return cfg;
        }
        return null;
    }

    public static int optionTypeToEntryKind(int type) {
        switch (type) {
            case 4: {
                return 1;
            }
            case 5: {
                return 4;
            }
            case 8: {
                return 2;
            }
            case 9: {
                return 16;
            }
            case 6: 
            case 10: {
                return 32;
            }
            case 11: {
                return 8;
            }
        }
        return 0;
    }

    public static int optionUndefTypeToEntryKind(int type) {
        switch (type) {
            case -4: {
                return 1;
            }
            case -5: {
                return 4;
            }
            case -8: {
                return 2;
            }
            case -9: {
                return 16;
            }
            case -10: {
                return 32;
            }
            case -11: {
                return 8;
            }
        }
        return 0;
    }

    public static int entryKindToOptionType(int kind) {
        switch (kind) {
            case 1: {
                return 4;
            }
            case 2: {
                return 8;
            }
            case 4: {
                return 5;
            }
            case 8: {
                return 11;
            }
            case 16: {
                return 9;
            }
            case 32: {
                return 10;
            }
        }
        return 0;
    }

    public static int entryKindToUndefOptionType(int kind) {
        switch (kind) {
            case 1: {
                return -4;
            }
            case 2: {
                return -8;
            }
            case 4: {
                return -5;
            }
            case 8: {
                return -11;
            }
            case 16: {
                return -9;
            }
            case 32: {
                return -10;
            }
        }
        return 0;
    }

    public static ICConfigurationDescription getDescriptionForConfiguration(IConfiguration cfg) {
        return ManagedBuildManager.getDescriptionForConfiguration(cfg, false);
    }

    private static ICConfigurationDescription getDescriptionForConfiguration(IConfiguration cfg, boolean checkConsistance) {
        if (cfg.isExtensionElement()) {
            return null;
        }
        ICConfigurationDescription des = ((Configuration)cfg).getConfigurationDescription();
        if (des == null) {
            if (checkConsistance) {
                throw new IllegalStateException();
            }
            if (((Configuration)cfg).isPreference()) {
                try {
                    des = CCorePlugin.getDefault().getPreferenceConfiguration(CFG_DATA_PROVIDER_ID);
                }
                catch (CoreException e) {
                    ManagedBuilderCorePlugin.log(e);
                }
            } else {
                IProject project = cfg.getOwner().getProject();
                ICProjectDescription projDes = CoreModel.getDefault().getProjectDescription(project, false);
                if (projDes != null) {
                    des = projDes.getConfigurationById(cfg.getId());
                }
            }
        }
        if (checkConsistance && cfg != ManagedBuildManager.getConfigurationForDescription(des, false)) {
            throw new IllegalStateException();
        }
        return des;
    }

    public static IPath getBuildFullPath(IConfiguration cfg, IBuilder builder) {
        IProject project = cfg.getOwner().getProject();
        IPath buildDirectory = builder.getBuildLocation();
        IPath fullPath = null;
        if (buildDirectory != null && !buildDirectory.isEmpty()) {
            IResource res = project.getParent().findMember(buildDirectory);
            if (res instanceof IContainer && res.exists()) {
                fullPath = res.getFullPath();
            } else {
                IContainer[] crs = ((IWorkspaceRoot)project.getParent()).findContainersForLocation(buildDirectory);
                if (crs.length != 0) {
                    String projName = project.getName();
                    IContainer[] iContainerArray = crs;
                    int n = crs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IContainer cr = iContainerArray[n2];
                        IPath path = cr.getFullPath();
                        if (path.segmentCount() != 0 && path.segment(0).equals(projName)) {
                            fullPath = path;
                            break;
                        }
                        ++n2;
                    }
                    if (fullPath == null) {
                        fullPath = crs[0].getFullPath();
                    }
                }
            }
        } else {
            fullPath = cfg.getOwner().getProject().getFullPath();
            if (builder.isManagedBuildOn()) {
                fullPath = fullPath.append(cfg.getName());
            }
        }
        return fullPath;
    }

    public static String locationToFullPath(String path) {
        if (!(path = path.trim()).startsWith("${")) {
            return null;
        }
        int index = path.lastIndexOf(125);
        if (index == -1) {
            return null;
        }
        String varName = "workspace_loc";
        String str1 = path.substring(2, index);
        String result = null;
        if (str1.startsWith(varName)) {
            if ((str1 = str1.substring(varName.length())).length() != 0) {
                if (str1.startsWith(":")) {
                    result = str1.substring(1);
                }
            } else {
                result = "/";
            }
            if (index < path.length() - 1) {
                result = String.valueOf(result) + path.substring(index + 1);
            }
        }
        return result;
    }

    public static String fullPathToLocation(String path) {
        StringBuffer buf = new StringBuffer();
        return buf.append("${").append("workspace_loc:").append(path).append("}").toString();
    }

    public static IPath getBuildLocation(IConfiguration cfg, IBuilder builder) {
        if (cfg.getOwner() == null) {
            return Path.EMPTY;
        }
        IProject project = cfg.getOwner().getProject();
        IPath buildDirectory = builder.getBuildLocation();
        if (buildDirectory != null && !buildDirectory.isEmpty()) {
            IResource res = project.getParent().findMember(buildDirectory);
            if (res instanceof IContainer && res.exists()) {
                buildDirectory = res.getLocation();
            }
        } else {
            buildDirectory = ManagedBuildManager.getPathForResource((IResource)project);
            if (buildDirectory != null && builder.isManagedBuildOn()) {
                buildDirectory = buildDirectory.append(cfg.getName());
            }
        }
        return buildDirectory;
    }

    public static URI getBuildLocationURI(IConfiguration cfg, IBuilder builder) {
        if (cfg.getOwner() == null) {
            return null;
        }
        IProject project = cfg.getOwner().getProject();
        IPath buildDirectory = builder.getBuildLocation();
        if (buildDirectory != null && !buildDirectory.isEmpty()) {
            IResource res = project.getParent().findMember(buildDirectory);
            if (res instanceof IContainer && res.exists()) {
                return res.getLocationURI();
            }
        } else {
            URI uri = project.getLocationURI();
            if (buildDirectory != null && builder.isManagedBuildOn()) {
                return org.eclipse.core.runtime.URIUtil.append((URI)uri, (String)cfg.getName());
            }
            return uri;
        }
        return URIUtil.toURI((IPath)buildDirectory);
    }

    private static IPath getPathForResource(IResource resource) {
        URI uri = resource.getLocationURI();
        return new Path(uri.getPath());
    }

    public static IBuilder[] createBuilders(IProject project, Map<String, String> args) {
        return ManagedBuilderCorePlugin.createBuilders(project, args);
    }

    public static IBuilder createCustomBuilder(IConfiguration cfg, String builderId) throws CoreException {
        return ManagedBuilderCorePlugin.createCustomBuilder(cfg, builderId);
    }

    public static IBuilder createCustomBuilder(IConfiguration cfg, IBuilder base) {
        return ManagedBuilderCorePlugin.createCustomBuilder(cfg, base);
    }

    public static IBuilder createBuilderForEclipseBuilder(IConfiguration cfg, String eclipseBuilderID) throws CoreException {
        return ManagedBuilderCorePlugin.createBuilderForEclipseBuilder(cfg, eclipseBuilderID);
    }

    public static IToolChain[] getExtensionToolChains(IProjectType type) {
        IConfiguration[] cfgs;
        ArrayList<IToolChain> result = new ArrayList<IToolChain>();
        IConfiguration[] iConfigurationArray = cfgs = type.getConfigurations();
        int n = cfgs.length;
        int n2 = 0;
        while (n2 < n) {
            IConfiguration cfg = iConfigurationArray[n2];
            IToolChain tc = cfg.getToolChain();
            if (tc != null) {
                List<ToolChain> list = ManagedBuildManager.findIdenticalElements((ToolChain)tc, fToolChainSorter);
                int k = 0;
                while (k < result.size()) {
                    if (ManagedBuildManager.findIdenticalElements((ToolChain)result.get(k), fToolChainSorter) == list) break;
                    ++k;
                }
                if (k == result.size()) {
                    result.add(tc);
                }
            }
            ++n2;
        }
        return result.toArray(new IToolChain[result.size()]);
    }

    public static IConfiguration[] getExtensionConfigurations(IToolChain tChain, IProjectType type) {
        IConfiguration[] cfgs;
        ArrayList<IConfiguration> list = new ArrayList<IConfiguration>();
        IConfiguration[] iConfigurationArray = cfgs = type.getConfigurations();
        int n = cfgs.length;
        int n2 = 0;
        while (n2 < n) {
            IConfiguration cfg = iConfigurationArray[n2];
            IToolChain cur = cfg.getToolChain();
            if (cur != null && ManagedBuildManager.findIdenticalElements((ToolChain)cur, fToolChainSorter) == ManagedBuildManager.findIdenticalElements((ToolChain)tChain, fToolChainSorter)) {
                list.add(cfg);
            }
            ++n2;
        }
        return list.toArray(new Configuration[list.size()]);
    }

    public static IConfiguration getFirstExtensionConfiguration(IToolChain tChain) {
        if (tChain.getParent() != null) {
            return tChain.getParent();
        }
        List<ToolChain> list = ManagedBuildManager.findIdenticalElements((ToolChain)tChain, fToolChainSorter);
        if (list != null) {
            int i = 0;
            while (i < list.size()) {
                ToolChain cur = list.get(i);
                if (cur.getParent() != null) {
                    return cur.getParent();
                }
                ++i;
            }
        }
        return null;
    }

    public static IConfiguration[] getExtensionConfigurations(IToolChain tChain, String propertyType, String propertyValue) {
        IBuildObjectProperties props;
        IConfiguration cfg;
        List<ToolChain> list = ManagedBuildManager.findIdenticalElements((ToolChain)tChain, fToolChainSorter);
        LinkedHashSet<IConfiguration> result = new LinkedHashSet<IConfiguration>();
        boolean tcFound = false;
        if (list != null) {
            int i = 0;
            while (i < list.size()) {
                IBuildObjectProperties props2;
                IConfiguration cfg2;
                ToolChain cur = list.get(i);
                if (cur == tChain) {
                    tcFound = true;
                }
                if ((cfg2 = cur.getParent()) != null && (props2 = cfg2.getBuildProperties()).containsValue(propertyType, propertyValue)) {
                    result.add(cfg2);
                }
                ++i;
            }
        }
        if (!tcFound && (cfg = tChain.getParent()) != null && (props = cfg.getBuildProperties()).containsValue(propertyType, propertyValue)) {
            result.add(cfg);
        }
        return result.toArray(new IConfiguration[result.size()]);
    }

    private static HashMap<MatchKey<ToolChain>, List<ToolChain>> getSortedToolChains() {
        if (fSortedToolChains == null) {
            Collection<ToolChain> toolChains = ManagedBuildManager.getExtensionToolChainMapInternal().values();
            fSortedToolChains = ManagedBuildManager.getSortedElements(toolChains);
        }
        return fSortedToolChains;
    }

    private static HashMap<MatchKey<Tool>, List<Tool>> getSortedTools() {
        if (fSortedTools == null) {
            Collection<Tool> tools = ManagedBuildManager.getExtensionToolMapInternal().values();
            fSortedTools = ManagedBuildManager.getSortedElements(tools);
        }
        return fSortedTools;
    }

    private static HashMap<MatchKey<Builder>, List<Builder>> getSortedBuilders() {
        if (fSortedBuilders == null) {
            Collection<Builder> builders = ManagedBuildManager.getExtensionBuilderMapInternal().values();
            fSortedBuilders = ManagedBuildManager.getSortedElements(builders);
        }
        return fSortedBuilders;
    }

    private static <T extends BuildObject> HashMap<MatchKey<T>, List<T>> getSortedElements(Collection<T> elements) {
        HashMap<MatchKey<T>, List<T>> map = new HashMap<MatchKey<T>, List<T>>();
        for (BuildObject p : elements) {
            MatchKey key = ((IMatchKeyProvider)((Object)p)).getMatchKey();
            if (key == null) continue;
            List<T> list = map.get(key);
            if (list == null) {
                list = new ArrayList<T>();
                map.put(key, list);
            }
            list.add(p);
            ((IMatchKeyProvider)((Object)p)).setIdenticalList(list);
        }
        Collection values = map.values();
        for (List list : values) {
            Collections.sort(list);
        }
        return map;
    }

    public static IToolChain[] getRealToolChains() {
        HashMap<MatchKey<ToolChain>, List<ToolChain>> map = ManagedBuildManager.getSortedToolChains();
        IToolChain[] tcs = new ToolChain[map.size()];
        int i = 0;
        for (List<ToolChain> list : map.values()) {
            tcs[i++] = list.get(0);
        }
        return tcs;
    }

    public static ITool[] getRealTools() {
        HashMap<MatchKey<Tool>, List<Tool>> map = ManagedBuildManager.getSortedTools();
        ITool[] ts = new Tool[map.size()];
        int i = 0;
        for (List<Tool> list : map.values()) {
            ts[i++] = list.get(0);
        }
        return ts;
    }

    public static IBuilder[] getRealBuilders() {
        HashMap<MatchKey<Builder>, List<Builder>> map = ManagedBuildManager.getSortedBuilders();
        IBuilder[] bs = new Builder[map.size()];
        int i = 0;
        for (List<Builder> list : map.values()) {
            bs[i++] = list.get(0);
        }
        return bs;
    }

    public static IBuilder getRealBuilder(IBuilder builder) {
        IBuilder extBuilder = builder;
        IBuilder realBuilder = null;
        while (extBuilder != null && !extBuilder.isExtensionElement()) {
            extBuilder = extBuilder.getSuperClass();
        }
        if (extBuilder != null) {
            List<Builder> list = ManagedBuildManager.findIdenticalElements((Builder)extBuilder, fBuilderSorter);
            if (list.size() == 0) {
                realBuilder = extBuilder;
            } else {
                IBuilder[] iBuilderArray = ManagedBuildManager.getRealBuilders();
                int n = iBuilderArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IBuilder realBldr = iBuilderArray[n2];
                    List<Builder> rList = ManagedBuildManager.findIdenticalElements((Builder)realBldr, fBuilderSorter);
                    if (rList == list) {
                        realBuilder = realBldr;
                        break;
                    }
                    ++n2;
                }
            }
        }
        return realBuilder;
    }

    public static ITool getRealTool(ITool tool) {
        if (tool == null) {
            return null;
        }
        ITool extTool = tool;
        ITool realTool = null;
        while (extTool != null && !extTool.isExtensionElement()) {
            extTool = extTool.getSuperClass();
        }
        if (extTool != null) {
            List<Tool> list = ManagedBuildManager.findIdenticalElements((Tool)extTool, fToolSorter);
            if (list.size() == 0) {
                realTool = extTool;
            } else {
                ITool[] iToolArray = ManagedBuildManager.getRealTools();
                int n = iToolArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ITool realT = iToolArray[n2];
                    List<Tool> rList = ManagedBuildManager.findIdenticalElements((Tool)realT, fToolSorter);
                    if (rList == list) {
                        realTool = realT;
                        break;
                    }
                    ++n2;
                }
            }
        } else {
            realTool = ManagedBuildManager.getExtensionTool("org.eclipse.cdt.build.core.default.tool");
        }
        return realTool;
    }

    public static IToolChain getExtensionToolChain(IToolChain tc) {
        IToolChain extTc = tc;
        while (extTc != null && !extTc.isExtensionElement()) {
            extTc = extTc.getSuperClass();
        }
        return extTc;
    }

    public static IToolChain getRealToolChain(IToolChain tc) {
        IToolChain extTc = tc;
        IToolChain realToolChain = null;
        while (extTc != null && !extTc.isExtensionElement()) {
            extTc = extTc.getSuperClass();
        }
        if (extTc != null) {
            List<ToolChain> list = ManagedBuildManager.findIdenticalElements((ToolChain)extTc, fToolChainSorter);
            if (list.size() == 0) {
                realToolChain = extTc;
            } else {
                IToolChain[] iToolChainArray = ManagedBuildManager.getRealToolChains();
                int n = iToolChainArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IToolChain realTc = iToolChainArray[n2];
                    List<ToolChain> rList = ManagedBuildManager.findIdenticalElements((ToolChain)realTc, fToolChainSorter);
                    if (rList == list) {
                        realToolChain = realTc;
                        break;
                    }
                    ++n2;
                }
            }
        }
        return realToolChain;
    }

    public static IToolChain[] findIdenticalToolChains(IToolChain tc) {
        List<ToolChain> list = ManagedBuildManager.findIdenticalElements((ToolChain)tc, fToolChainSorter);
        return list.toArray(new ToolChain[list.size()]);
    }

    public static ITool[] findIdenticalTools(ITool tool) {
        List<Tool> list = ManagedBuildManager.findIdenticalElements((Tool)tool, fToolSorter);
        return list.toArray(new Tool[list.size()]);
    }

    public static IBuilder[] findIdenticalBuilders(IBuilder b) {
        List<Builder> list = ManagedBuildManager.findIdenticalElements((Builder)b, fBuilderSorter);
        return list.toArray(new Builder[list.size()]);
    }

    public static IToolChain[] getExtensionsToolChains(String propertyType, String propertyValue) {
        return ManagedBuildManager.getExtensionsToolChains(propertyType, propertyValue, true);
    }

    public static IToolChain[] getExtensionsToolChains(String propertyType, String propertyValue, boolean supportedPropsOnly) {
        HashMap<MatchKey<ToolChain>, List<ToolChain>> all = ManagedBuildManager.getSortedToolChains();
        ArrayList<IToolChain> result = new ArrayList<IToolChain>();
        for (List<ToolChain> list : all.values()) {
            IToolChain tc = ManagedBuildManager.findToolChain(list, propertyType, propertyValue, supportedPropsOnly);
            if (tc == null) continue;
            result.add(tc);
        }
        return result.toArray(new ToolChain[result.size()]);
    }

    public static void resortToolChains() {
        fSortedToolChains = null;
        ManagedBuildManager.getSortedToolChains();
    }

    public static void resortTools() {
        fSortedTools = null;
        ManagedBuildManager.getSortedTools();
    }

    public static void resortBuilders() {
        fSortedBuilders = null;
        ManagedBuildManager.getSortedBuilders();
    }

    private static IToolChain findToolChain(List<ToolChain> list, String propertyType, String propertyValue, boolean supportedOnly) {
        ToolChain bestMatch = null;
        IConfiguration cfg = null;
        IProjectType type = null;
        boolean valueSupported = false;
        int i = 0;
        while (i < list.size()) {
            block16: {
                IConfiguration tcCfg;
                ToolChain tc;
                block15: {
                    block14: {
                        tc = list.get(i);
                        if (!tc.supportsValue(propertyType, propertyValue)) break block14;
                        valueSupported = true;
                        break block15;
                    }
                    if (valueSupported) break block16;
                }
                if (!tc.supportsBuild(true)) {
                    return null;
                }
                if (bestMatch == null && valueSupported) {
                    bestMatch = tc;
                }
                if ((tcCfg = tc.getParent()) != null) {
                    IProjectType tcType;
                    if (cfg == null && valueSupported) {
                        bestMatch = tc;
                        cfg = tcCfg;
                    }
                    IBuildObjectProperties props = tcCfg.getBuildProperties();
                    IBuildProperty prop = props.getProperty(propertyType);
                    if (valueSupported && prop != null && propertyValue.equals(prop.getValue().getId())) {
                        bestMatch = tc;
                        cfg = tcCfg;
                    }
                    if ((tcType = tcCfg.getProjectType()) != null) {
                        if (type == null && valueSupported) {
                            type = tcType;
                            bestMatch = tc;
                        }
                        if ((prop = (props = tcType.getBuildProperties()).getProperty(propertyType)) != null && propertyValue.equals(prop.getValue().getId())) {
                            bestMatch = tc;
                            if (valueSupported) {
                                type = tcType;
                                break;
                            }
                        }
                    }
                }
            }
            ++i;
        }
        if (valueSupported || !supportedOnly) {
            return bestMatch;
        }
        return null;
    }

    private static <T extends BuildObject> List<T> findIdenticalElements(T p, ISorter sorter) {
        List list = ((IMatchKeyProvider)((Object)p)).getIdenticalList();
        if (list == null) {
            sorter.sort();
            list = ((IMatchKeyProvider)((Object)p)).getIdenticalList();
            if (list == null) {
                list = new ArrayList(0);
                ((IMatchKeyProvider)((Object)p)).setIdenticalList(list);
            }
        }
        return list;
    }

    public static IBuildPropertyManager getBuildPropertyManager() {
        return BuildPropertyManager.getInstance();
    }

    public static IConfiguration[] getReferencedConfigurations(IConfiguration config) {
        ICConfigurationDescription cfgDes = ManagedBuildManager.getDescriptionForConfiguration(config);
        if (cfgDes != null) {
            ICConfigurationDescription[] descs = CoreModelUtil.getReferencedConfigurationDescriptions((ICConfigurationDescription)cfgDes, (boolean)false);
            ArrayList<IConfiguration> result = new ArrayList<IConfiguration>();
            ICConfigurationDescription[] iCConfigurationDescriptionArray = descs;
            int n = descs.length;
            int n2 = 0;
            while (n2 < n) {
                ICConfigurationDescription desc = iCConfigurationDescriptionArray[n2];
                IConfiguration cfg = ManagedBuildManager.getConfigurationForDescription(desc);
                if (cfg != null) {
                    result.add(cfg);
                }
                ++n2;
            }
            return result.toArray(new IConfiguration[result.size()]);
        }
        return new Configuration[0];
    }

    public static void buildConfigurations(IConfiguration[] configs, IProgressMonitor monitor) throws CoreException {
        ManagedBuildManager.buildConfigurations(configs, null, monitor);
    }

    public static void buildConfigurations(IConfiguration[] configs, IBuilder builder, IProgressMonitor monitor) throws CoreException {
        ManagedBuildManager.buildConfigurations(configs, builder, monitor, true);
    }

    public static void buildConfigurations(IConfiguration[] configs, IBuilder builder, IProgressMonitor monitor, boolean allBuilders) throws CoreException {
        ManagedBuildManager.buildConfigurations(configs, builder, monitor, allBuilders, 6);
    }

    public static void buildConfigurations(IConfiguration[] configs, IBuilder builder, IProgressMonitor monitor, boolean allBuilders, int buildKind) throws CoreException {
        Map<IProject, IConfiguration[]> map = ManagedBuildManager.sortConfigs(configs);
        for (Map.Entry<IProject, IConfiguration[]> entry : map.entrySet()) {
            IProject proj = entry.getKey();
            IConfiguration[] cfgs = entry.getValue();
            ManagedBuildManager.buildConfigurations(proj, cfgs, builder, monitor, allBuilders, buildKind);
        }
    }

    private static Map<IProject, IConfiguration[]> sortConfigs(IConfiguration[] cfgs) {
        Set set;
        HashMap<IProject, HashSet<IConfiguration>> cfgSetMap = new HashMap<IProject, HashSet<IConfiguration>>();
        IConfiguration[] iConfigurationArray = cfgs;
        int n = cfgs.length;
        int n2 = 0;
        while (n2 < n) {
            IConfiguration cfg = iConfigurationArray[n2];
            IProject proj = cfg.getOwner().getProject();
            set = (HashSet<IConfiguration>)cfgSetMap.get(proj);
            if (set == null) {
                set = new HashSet<IConfiguration>();
                cfgSetMap.put(proj, (HashSet<IConfiguration>)set);
            }
            set.add(cfg);
            ++n2;
        }
        HashMap<IProject, IConfiguration[]> cfgArrayMap = new HashMap<IProject, IConfiguration[]>();
        if (cfgSetMap.size() != 0) {
            Set entrySet = cfgSetMap.entrySet();
            for (Map.Entry entry : entrySet) {
                IProject key = (IProject)entry.getKey();
                set = (Set)entry.getValue();
                cfgArrayMap.put(key, set.toArray(new Configuration[set.size()]));
            }
        }
        return cfgArrayMap;
    }

    private static void buildConfigurations(final IProject project, final IConfiguration[] configs, final IBuilder builder, IProgressMonitor monitor, final boolean allBuilders, final int buildKind) throws CoreException {
        IWorkspaceRunnable op = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                int ticks = 1;
                if (buildKind == 15) {
                    if (allBuilders) {
                        ICommand[] commands = project.getDescription().getBuildSpec();
                        ticks = commands.length;
                    }
                    ticks *= configs.length;
                }
                monitor.beginTask(project.getName(), ticks);
                if (buildKind == 15) {
                    IManagedBuildInfo buildInfo = ManagedBuildManager.getBuildInfo((IResource)project);
                    IConfiguration savedCfg = buildInfo.getDefaultConfiguration();
                    try {
                        IConfiguration[] iConfigurationArray = configs;
                        int n = configs.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IConfiguration config = iConfigurationArray[n2];
                            if (monitor.isCanceled()) {
                            }
                            buildInfo.setDefaultConfiguration(config);
                            this.buildProject(project, null, allBuilders, buildKind, monitor);
                            ++n2;
                        }
                    }
                    finally {
                        buildInfo.setDefaultConfiguration(savedCfg);
                    }
                } else {
                    Map<String, String> args = builder != null ? BuilderFactory.createBuildArgs(configs, builder) : BuilderFactory.createBuildArgs(configs);
                    this.buildProject(project, args, allBuilders, buildKind, monitor);
                }
                monitor.done();
            }

            private void buildProject(IProject project2, Map<String, String> args, boolean allBuilders2, int buildKind2, IProgressMonitor monitor) throws CoreException {
                if (allBuilders2) {
                    ICommand[] commands;
                    ICommand[] iCommandArray = commands = project2.getDescription().getBuildSpec();
                    int n = commands.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ICommand command = iCommandArray[n2];
                        if (!monitor.isCanceled()) {
                            String builderName = command.getBuilderName();
                            HashMap<String, String> newArgs = null;
                            if (buildKind2 != 15) {
                                newArgs = new HashMap<String, String>(args);
                                if (!builderName.equals(CommonBuilder.BUILDER_ID)) {
                                    newArgs.putAll(command.getArguments());
                                }
                            }
                            project2.build(buildKind2, builderName, newArgs, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                            ++n2;
                            continue;
                        }
                        break;
                    }
                } else {
                    project2.build(buildKind2, CommonBuilder.BUILDER_ID, args, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                }
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(op, monitor);
        }
        finally {
            monitor.done();
        }
    }

    public static IBuilder getInternalBuilder() {
        return ManagedBuildManager.getExtensionBuilder(INTERNAL_BUILDER_ID);
    }

    public static ITool getExtensionTool(ITool tool) {
        ITool extTool = tool;
        while (extTool != null && !extTool.isExtensionElement()) {
            extTool = extTool.getSuperClass();
        }
        return extTool;
    }

    public static IInputType getExtensionInputType(IInputType inType) {
        IInputType extIT = inType;
        while (extIT != null && !extIT.isExtensionElement()) {
            extIT = extIT.getSuperClass();
        }
        return extIT;
    }

    public static IConfiguration getPreferenceConfiguration(boolean write) {
        try {
            ICConfigurationDescription des = CCorePlugin.getDefault().getPreferenceConfiguration(CFG_DATA_PROVIDER_ID, write);
            if (des != null) {
                return ManagedBuildManager.getConfigurationForDescription(des);
            }
        }
        catch (CoreException e) {
            ManagedBuilderCorePlugin.log(e);
        }
        return null;
    }

    public static void setPreferenceConfiguration(IConfiguration cfg) throws CoreException {
        ICConfigurationDescription des = ManagedBuildManager.getDescriptionForConfiguration(cfg);
        if (des != null) {
            CCorePlugin.getDefault().setPreferenceConfiguration(CFG_DATA_PROVIDER_ID, des);
        }
    }

    static synchronized void updateLoaddedInfo(IProject fromProject, IProject toProject, IManagedBuildInfo info) {
        try {
            ManagedBuildManager.setLoaddedBuildInfo(fromProject, null);
            ManagedBuildManager.setLoaddedBuildInfo(toProject, info);
        }
        catch (CoreException coreException) {}
    }

    public static IToolChainModificationManager getToolChainModificationManager() {
        return ToolChainModificationManager.getInstance();
    }

    public static boolean isPlatformOk(IToolChain tc) {
        ITargetPlatform tp = tc.getTargetPlatform();
        if (tp != null) {
            List<String> archList;
            List<String> osList = Arrays.asList(tc.getOSList());
            return !(!osList.contains(ALL) && !osList.contains(os) || !(archList = Arrays.asList(tc.getArchList())).contains(ALL) && !archList.contains(arch));
        }
        return true;
    }

    private static interface ISorter {
        public void sort();
    }
}

