/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.dialogs;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.egit.core.internal.Utils;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.UIUtils;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.SubMenuManager;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPainter;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.MarginPainter;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.quickassist.IQuickAssistInvocationContext;
import org.eclipse.jface.text.quickassist.IQuickAssistProcessor;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.ActiveShellExpression;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.DefaultMarkerAnnotationAccess;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.ui.texteditor.MarkerAnnotationPreferences;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpellcheckableMessageArea
extends Composite {
    static final int MAX_LINE_WIDTH = 72;
    private final SourceViewer sourceViewer;
    private ModifyListener hardWrapModifyListener;

    public SpellcheckableMessageArea(Composite parent, String initialText) {
        this(parent, initialText, 2048);
    }

    public SpellcheckableMessageArea(Composite parent, String initialText, int styles) {
        this(parent, initialText, false, styles);
    }

    public SpellcheckableMessageArea(Composite parent, String initialText, boolean readOnly, int styles) {
        super(parent, styles);
        this.setLayout((Layout)new FillLayout());
        AnnotationModel annotationModel = new AnnotationModel();
        this.sourceViewer = new SourceViewer((Composite)this, null, null, true, 578);
        this.getTextWidget().setFont(UIUtils.getFont("org.eclipse.egit.ui.CommitMessageEditorFont"));
        int endSpacing = 2;
        int textWidth = this.getCharWidth() * 72 + endSpacing;
        int textHeight = this.getLineHeight() * 7;
        Point size = this.getTextWidget().computeSize(textWidth, textHeight);
        this.getTextWidget().setSize(size);
        this.getTextWidget().setEditable(!readOnly);
        this.createMarginPainter();
        this.configureHardWrap();
        final SourceViewerDecorationSupport support = this.configureAnnotationPreferences();
        final IHandlerActivation handlerActivation = this.installQuickFixActionHandler();
        Document document = new Document(initialText);
        this.sourceViewer.configure((SourceViewerConfiguration)new TextSourceViewerConfiguration(EditorsUI.getPreferenceStore()){

            protected Map getHyperlinkDetectorTargets(ISourceViewer targetViewer) {
                return SpellcheckableMessageArea.this.getHyperlinkTargets();
            }

            public IReconciler getReconciler(ISourceViewer viewer) {
                if (!SpellcheckableMessageArea.this.isEditable(viewer)) {
                    return null;
                }
                return super.getReconciler((ISourceViewer)SpellcheckableMessageArea.this.sourceViewer);
            }

            public IContentAssistant getContentAssistant(ISourceViewer viewer) {
                if (!viewer.isEditable()) {
                    return null;
                }
                IContentAssistant assistant = SpellcheckableMessageArea.this.createContentAssistant(viewer);
                if (assistant != null) {
                    final IHandlerActivation activation = SpellcheckableMessageArea.this.installContentAssistActionHandler();
                    viewer.getTextWidget().addDisposeListener(new DisposeListener(){

                        public void widgetDisposed(DisposeEvent e) {
                            SpellcheckableMessageArea.this.getHandlerService().deactivateHandler(activation);
                        }
                    });
                }
                return assistant;
            }
        });
        this.sourceViewer.setDocument((IDocument)document, (IAnnotationModel)annotationModel);
        this.configureContextMenu();
        this.getTextWidget().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                support.uninstall();
                SpellcheckableMessageArea.this.getHandlerService().deactivateHandler(handlerActivation);
            }
        });
    }

    private boolean isEditable(ISourceViewer viewer) {
        return viewer != null && viewer.getTextWidget().getEditable();
    }

    private void configureHardWrap() {
        if (SpellcheckableMessageArea.shouldHardWrap()) {
            if (this.hardWrapModifyListener == null) {
                final StyledText textWidget = this.getTextWidget();
                this.hardWrapModifyListener = new ModifyListener(){
                    private boolean active = true;

                    public void modifyText(ModifyEvent e) {
                        if (!this.active) {
                            return;
                        }
                        String lineDelimiter = textWidget.getLineDelimiter();
                        List<WrapEdit> wrapEdits = SpellcheckableMessageArea.calculateWrapEdits(textWidget.getText(), 72, lineDelimiter);
                        this.active = false;
                        for (WrapEdit wrapEdit : wrapEdits) {
                            textWidget.replaceTextRange(wrapEdit.getStart(), wrapEdit.getLength(), lineDelimiter);
                        }
                        this.active = true;
                    }
                };
                textWidget.addModifyListener(this.hardWrapModifyListener);
            }
        } else if (this.hardWrapModifyListener != null) {
            this.getTextWidget().removeModifyListener(this.hardWrapModifyListener);
            this.hardWrapModifyListener = null;
        }
    }

    private void configureContextMenu() {
        final TextViewerAction cutAction = new TextViewerAction((ITextViewer)this.sourceViewer, 3);
        cutAction.setText(UIText.SpellCheckingMessageArea_cut);
        cutAction.setActionDefinitionId("org.eclipse.ui.edit.cut");
        final TextViewerAction copyAction = new TextViewerAction((ITextViewer)this.sourceViewer, 4);
        copyAction.setText(UIText.SpellCheckingMessageArea_copy);
        copyAction.setActionDefinitionId("org.eclipse.ui.edit.copy");
        final TextViewerAction pasteAction = new TextViewerAction((ITextViewer)this.sourceViewer, 5);
        pasteAction.setText(UIText.SpellCheckingMessageArea_paste);
        pasteAction.setActionDefinitionId("org.eclipse.ui.edit.paste");
        final TextViewerAction selectAllAction = new TextViewerAction((ITextViewer)this.sourceViewer, 7);
        selectAllAction.setText(UIText.SpellCheckingMessageArea_selectAll);
        selectAllAction.setActionDefinitionId("org.eclipse.ui.edit.selectAll");
        final TextViewerAction undoAction = new TextViewerAction((ITextViewer)this.sourceViewer, 1);
        undoAction.setText(UIText.SpellcheckableMessageArea_undo);
        undoAction.setActionDefinitionId("org.eclipse.ui.edit.undo");
        final TextViewerAction redoAction = new TextViewerAction((ITextViewer)this.sourceViewer, 2);
        redoAction.setText(UIText.SpellcheckableMessageArea_redo);
        redoAction.setActionDefinitionId("org.eclipse.ui.edit.redo");
        MenuManager contextMenu = new MenuManager();
        contextMenu.add((IAction)cutAction);
        contextMenu.add((IAction)copyAction);
        contextMenu.add((IAction)pasteAction);
        contextMenu.add((IAction)selectAllAction);
        contextMenu.add((IAction)undoAction);
        contextMenu.add((IAction)redoAction);
        contextMenu.add((IContributionItem)new Separator());
        if (this.isEditable((ISourceViewer)this.sourceViewer)) {
            final SubMenuManager quickFixMenu = new SubMenuManager((IMenuManager)contextMenu);
            quickFixMenu.setVisible(true);
            quickFixMenu.addMenuListener(new IMenuListener(){

                public void menuAboutToShow(IMenuManager manager) {
                    quickFixMenu.removeAll();
                    SpellcheckableMessageArea.this.addProposals(quickFixMenu);
                }
            });
        }
        StyledText textWidget = this.getTextWidget();
        this.getTextWidget().setMenu(contextMenu.createContextMenu((Control)textWidget));
        this.getTextWidget().addFocusListener(new FocusListener(){
            private IHandlerActivation cutHandlerActivation;
            private IHandlerActivation copyHandlerActivation;
            private IHandlerActivation pasteHandlerActivation;
            private IHandlerActivation selectAllHandlerActivation;
            private IHandlerActivation undoHandlerActivation;
            private IHandlerActivation redoHandlerActivation;

            public void focusGained(FocusEvent e) {
                cutAction.update();
                copyAction.update();
                IHandlerService service = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
                this.cutHandlerActivation = service.activateHandler("org.eclipse.ui.edit.cut", (IHandler)new ActionHandler((IAction)cutAction), (Expression)new ActiveShellExpression(SpellcheckableMessageArea.this.getParent().getShell()));
                this.copyHandlerActivation = service.activateHandler("org.eclipse.ui.edit.copy", (IHandler)new ActionHandler((IAction)copyAction), (Expression)new ActiveShellExpression(SpellcheckableMessageArea.this.getParent().getShell()));
                this.pasteHandlerActivation = service.activateHandler("org.eclipse.ui.edit.paste", (IHandler)new ActionHandler((IAction)pasteAction), (Expression)new ActiveShellExpression(SpellcheckableMessageArea.this.getParent().getShell()));
                this.selectAllHandlerActivation = service.activateHandler("org.eclipse.ui.edit.selectAll", (IHandler)new ActionHandler((IAction)selectAllAction), (Expression)new ActiveShellExpression(SpellcheckableMessageArea.this.getParent().getShell()));
                this.undoHandlerActivation = service.activateHandler("org.eclipse.ui.edit.undo", (IHandler)new ActionHandler((IAction)undoAction), (Expression)new ActiveShellExpression(SpellcheckableMessageArea.this.getParent().getShell()));
                this.redoHandlerActivation = service.activateHandler("org.eclipse.ui.edit.redo", (IHandler)new ActionHandler((IAction)redoAction), (Expression)new ActiveShellExpression(SpellcheckableMessageArea.this.getParent().getShell()));
            }

            public void focusLost(FocusEvent e) {
                IHandlerService service = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
                if (this.cutHandlerActivation != null) {
                    service.deactivateHandler(this.cutHandlerActivation);
                }
                if (this.copyHandlerActivation != null) {
                    service.deactivateHandler(this.copyHandlerActivation);
                }
                if (this.pasteHandlerActivation != null) {
                    service.deactivateHandler(this.pasteHandlerActivation);
                }
                if (this.selectAllHandlerActivation != null) {
                    service.deactivateHandler(this.selectAllHandlerActivation);
                }
                if (this.undoHandlerActivation != null) {
                    service.deactivateHandler(this.undoHandlerActivation);
                }
                if (this.redoHandlerActivation != null) {
                    service.deactivateHandler(this.redoHandlerActivation);
                }
            }
        });
        this.sourceViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                cutAction.update();
                copyAction.update();
            }
        });
        this.sourceViewer.addTextListener(new ITextListener(){

            public void textChanged(TextEvent event) {
                undoAction.update();
                redoAction.update();
            }
        });
    }

    private void addProposals(SubMenuManager quickFixMenu) {
        IAnnotationModel sourceModel = this.sourceViewer.getAnnotationModel();
        Iterator annotationIterator = sourceModel.getAnnotationIterator();
        while (annotationIterator.hasNext()) {
            ICompletionProposal[] proposals;
            Annotation annotation = (Annotation)annotationIterator.next();
            boolean isDeleted = annotation.isMarkedDeleted();
            boolean isIncluded = this.includes(sourceModel.getPosition(annotation), this.getTextWidget().getCaretOffset());
            boolean isFixable = this.sourceViewer.getQuickAssistAssistant().canFix(annotation);
            if (isDeleted || !isIncluded || !isFixable) continue;
            IQuickAssistProcessor processor = this.sourceViewer.getQuickAssistAssistant().getQuickAssistProcessor();
            IQuickAssistInvocationContext context = this.sourceViewer.getQuickAssistInvocationContext();
            ICompletionProposal[] iCompletionProposalArray = proposals = processor.computeQuickAssistProposals(context);
            int n = proposals.length;
            int n2 = 0;
            while (n2 < n) {
                ICompletionProposal proposal = iCompletionProposalArray[n2];
                quickFixMenu.add(this.createQuickFixAction(proposal));
                ++n2;
            }
        }
    }

    private boolean includes(Position position, int caretOffset) {
        return position.includes(caretOffset) || position.offset + position.length == caretOffset;
    }

    private IAction createQuickFixAction(final ICompletionProposal proposal) {
        return new Action(proposal.getDisplayString()){

            public void run() {
                proposal.apply(SpellcheckableMessageArea.this.sourceViewer.getDocument());
            }

            public ImageDescriptor getImageDescriptor() {
                Image image = proposal.getImage();
                if (image != null) {
                    return ImageDescriptor.createFromImage((Image)image);
                }
                return null;
            }
        };
    }

    private IHandlerService getHandlerService() {
        IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
        return handlerService;
    }

    private SourceViewerDecorationSupport configureAnnotationPreferences() {
        ISharedTextColors textColors = EditorsUI.getSharedTextColors();
        DefaultMarkerAnnotationAccess annotationAccess = new DefaultMarkerAnnotationAccess();
        SourceViewerDecorationSupport support = new SourceViewerDecorationSupport((ISourceViewer)this.sourceViewer, null, (IAnnotationAccess)annotationAccess, textColors);
        List annotationPreferences = new MarkerAnnotationPreferences().getAnnotationPreferences();
        Iterator e = annotationPreferences.iterator();
        while (e.hasNext()) {
            support.setAnnotationPreference((AnnotationPreference)e.next());
        }
        support.install(EditorsUI.getPreferenceStore());
        return support;
    }

    protected void createMarginPainter() {
        MarginPainter marginPainter = new MarginPainter((ITextViewer)this.sourceViewer);
        marginPainter.setMarginRulerColumn(72);
        marginPainter.setMarginRulerColor(Display.getDefault().getSystemColor(15));
        this.sourceViewer.addPainter((IPainter)marginPainter);
    }

    private int getCharWidth() {
        GC gc = new GC((Drawable)this.getTextWidget());
        int charWidth = gc.getFontMetrics().getAverageCharWidth();
        gc.dispose();
        return charWidth;
    }

    private int getLineHeight() {
        return this.getTextWidget().getLineHeight();
    }

    private static boolean shouldHardWrap() {
        return Activator.getDefault().getPreferenceStore().getBoolean("commit_dialog_hard_wrap_message");
    }

    public StyledText getTextWidget() {
        return this.sourceViewer.getTextWidget();
    }

    private IHandlerActivation installQuickFixActionHandler() {
        ActionHandler handler = this.createQuickFixActionHandler((ITextOperationTarget)this.sourceViewer);
        return this.addHandler(handler);
    }

    private IHandlerActivation installContentAssistActionHandler() {
        ActionHandler handler = this.createContentAssistActionHandler((ITextOperationTarget)this.sourceViewer);
        return this.addHandler(handler);
    }

    private IHandlerActivation addHandler(ActionHandler handler) {
        ActiveShellExpression expression = new ActiveShellExpression(this.sourceViewer.getTextWidget().getShell());
        return this.getHandlerService().activateHandler(handler.getAction().getActionDefinitionId(), (IHandler)handler, (Expression)expression);
    }

    private ActionHandler createQuickFixActionHandler(final ITextOperationTarget textOperationTarget) {
        Action quickFixAction = new Action(){

            public void run() {
                textOperationTarget.doOperation(22);
            }
        };
        quickFixAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.correction.assist.proposals");
        return new ActionHandler((IAction)quickFixAction);
    }

    private ActionHandler createContentAssistActionHandler(final ITextOperationTarget textOperationTarget) {
        Action proposalAction = new Action(){

            public void run() {
                if (textOperationTarget.canDoOperation(13) && SpellcheckableMessageArea.this.getTextWidget().isFocusControl()) {
                    textOperationTarget.doOperation(13);
                }
            }
        };
        proposalAction.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        return new ActionHandler((IAction)proposalAction);
    }

    public String getCommitMessage() {
        String text = this.getText();
        return Utils.normalizeLineEndings((String)text);
    }

    public void reconfigure() {
        this.configureHardWrap();
    }

    protected Map<String, IAdaptable> getHyperlinkTargets() {
        return Collections.singletonMap("org.eclipse.ui.DefaultTextEditor", this.getDefaultTarget());
    }

    protected IContentAssistant createContentAssistant(ISourceViewer viewer) {
        return null;
    }

    protected IAdaptable getDefaultTarget() {
        return null;
    }

    public String getText() {
        return this.getTextWidget().getText();
    }

    public IDocument getDocument() {
        return this.sourceViewer.getDocument();
    }

    public void setText(String text) {
        if (text != null) {
            this.getTextWidget().setText(text);
        }
    }

    public boolean setFocus() {
        return this.getTextWidget().setFocus();
    }

    public static List<WrapEdit> calculateWrapEdits(String text, int maxLineLength, String lineDelimiter) {
        LinkedList<WrapEdit> wrapEdits = new LinkedList<WrapEdit>();
        int offset = 0;
        int lineDelimiterLength = lineDelimiter.length();
        String[] chunks = text.split(lineDelimiter, -1);
        int chunkIndex = 0;
        while (chunkIndex < chunks.length) {
            String chunk = chunks[chunkIndex];
            String[] words = chunk.split(" ", -1);
            int lineLength = 0;
            int wordIndex = 0;
            while (wordIndex < words.length) {
                String word = words[wordIndex];
                int wordLength = word.length();
                int newLineLength = lineLength + wordLength + 1;
                if (newLineLength > maxLineLength) {
                    if (lineLength != 0) {
                        wrapEdits.add(new WrapEdit(offset, 1));
                        offset += lineDelimiterLength;
                    }
                    lineLength = 0;
                } else if (wordIndex != 0) {
                    ++lineLength;
                    ++offset;
                }
                offset += wordLength;
                lineLength += wordLength;
                ++wordIndex;
            }
            if (chunkIndex != chunks.length - 1) {
                offset += lineDelimiterLength;
            }
            ++chunkIndex;
        }
        return wrapEdits;
    }

    private static class TextViewerAction
    extends Action
    implements IUpdate {
        private int fOperationCode = -1;
        private ITextOperationTarget fOperationTarget;

        public TextViewerAction(ITextViewer viewer, int operationCode) {
            this.fOperationCode = operationCode;
            this.fOperationTarget = viewer.getTextOperationTarget();
            this.update();
        }

        public void update() {
            if (this.fOperationCode == 2) {
                return;
            }
            boolean wasEnabled = this.isEnabled();
            boolean isEnabled = this.fOperationTarget != null && this.fOperationTarget.canDoOperation(this.fOperationCode);
            this.setEnabled(isEnabled);
            if (wasEnabled != isEnabled) {
                this.firePropertyChange("enabled", wasEnabled ? Boolean.TRUE : Boolean.FALSE, isEnabled ? Boolean.TRUE : Boolean.FALSE);
            }
        }

        public void run() {
            if (this.fOperationCode != -1 && this.fOperationTarget != null) {
                this.fOperationTarget.doOperation(this.fOperationCode);
            }
        }
    }

    public static class WrapEdit {
        private int start;
        private int length;

        public WrapEdit(int start, int length) {
            this.start = start;
            this.length = length;
        }

        public int getStart() {
            return this.start;
        }

        public int getLength() {
            return this.length;
        }
    }
}

