/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.history;

import org.eclipse.egit.ui.internal.history.FindResults;
import org.eclipse.egit.ui.internal.history.FindToolbar;
import org.eclipse.egit.ui.internal.history.SWTCommit;
import org.eclipse.jgit.revwalk.RevObject;

public class FindToolbarThread
extends Thread {
    private static final Object EXEC_LOCK = new Object();
    private static final int MAX_RESULTS = 20000;
    String pattern;
    SWTCommit[] fileRevisions;
    FindToolbar toolbar;
    boolean ignoreCase;
    boolean findInCommitId;
    boolean findInComments;
    boolean findInAuthor;
    boolean findInCommitter;
    private static volatile int globalThreadIx = 0;
    private int currentThreadIx = globalThreadIx;

    public FindToolbarThread() {
        super("history_find_thread" + ++globalThreadIx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object object = EXEC_LOCK;
        synchronized (object) {
            this.execFind();
        }
    }

    private void execFind() {
        if (this.currentThreadIx < globalThreadIx) {
            return;
        }
        FindResults findResults = this.toolbar.findResults;
        findResults.clear();
        boolean maxResultsOverflow = false;
        if (this.pattern.length() > 0 && this.fileRevisions != null) {
            String findPattern = this.pattern;
            if (this.ignoreCase) {
                findPattern = this.pattern.toLowerCase();
            }
            long lastUIUpdate = System.currentTimeMillis();
            int totalRevisions = this.fileRevisions.length;
            int totalMatches = 0;
            boolean notFound = true;
            int i = 0;
            while (i < totalRevisions) {
                String email;
                String comment;
                String contentId;
                if (this.toolbar.getDisplay().isDisposed() || this.currentThreadIx < globalThreadIx) {
                    return;
                }
                if (System.currentTimeMillis() - lastUIUpdate > 500L) {
                    final int percentage = (int)(((float)i + 1.0f) / (float)totalRevisions * 100.0f);
                    this.toolbar.getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            if (FindToolbarThread.this.toolbar.isDisposed()) {
                                return;
                            }
                            FindToolbarThread.this.toolbar.progressUpdate(percentage);
                        }
                    });
                    lastUIUpdate = System.currentTimeMillis();
                }
                notFound = true;
                SWTCommit revision = this.fileRevisions[i];
                if (this.findInCommitId && (contentId = revision.getId().name()) != null) {
                    if (this.ignoreCase) {
                        contentId = contentId.toLowerCase();
                    }
                    if (contentId.indexOf(findPattern) != -1) {
                        ++totalMatches;
                        findResults.add(i, (RevObject)revision);
                        notFound = false;
                    }
                }
                if (this.findInComments && notFound && (comment = revision.getFullMessage()) != null) {
                    if (this.ignoreCase) {
                        comment = comment.toLowerCase();
                    }
                    if (comment.indexOf(findPattern) != -1) {
                        ++totalMatches;
                        findResults.add(i, (RevObject)revision);
                        notFound = false;
                    }
                }
                if (this.findInAuthor && notFound) {
                    String author = revision.getAuthorIdent().getName();
                    if (author != null) {
                        if (this.ignoreCase) {
                            author = author.toLowerCase();
                        }
                        if (author.indexOf(findPattern) != -1) {
                            ++totalMatches;
                            findResults.add(i, (RevObject)revision);
                            notFound = false;
                        }
                    }
                    if (notFound && (email = revision.getAuthorIdent().getEmailAddress()) != null) {
                        if (this.ignoreCase) {
                            email = email.toLowerCase();
                        }
                        if (email.indexOf(findPattern) != -1) {
                            ++totalMatches;
                            findResults.add(i, (RevObject)revision);
                            notFound = false;
                        }
                    }
                }
                if (this.findInCommitter && notFound) {
                    String committer = revision.getCommitterIdent().getName();
                    if (committer != null) {
                        if (this.ignoreCase) {
                            committer = committer.toLowerCase();
                        }
                        if (committer.indexOf(findPattern) != -1) {
                            ++totalMatches;
                            findResults.add(i, (RevObject)revision);
                            notFound = false;
                        }
                    }
                    if (notFound && (email = revision.getCommitterIdent().getEmailAddress()) != null) {
                        if (this.ignoreCase) {
                            email = email.toLowerCase();
                        }
                        if (email.indexOf(findPattern) != -1) {
                            ++totalMatches;
                            findResults.add(i, (RevObject)revision);
                            notFound = false;
                        }
                    }
                }
                if (totalMatches == 20000) {
                    maxResultsOverflow = true;
                    break;
                }
                ++i;
            }
        }
        final boolean overflow = maxResultsOverflow;
        this.toolbar.getDisplay().syncExec(new Runnable(){

            public void run() {
                if (FindToolbarThread.this.toolbar.isDisposed()) {
                    return;
                }
                FindToolbarThread.this.toolbar.findCompletionUpdate(FindToolbarThread.this.pattern, overflow);
            }
        });
    }

    static void updateGlobalThreadIx() {
        ++globalThreadIx;
    }
}

