/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.history;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.history.CommitGraphTable;
import org.eclipse.egit.ui.internal.history.SWTCommitList;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.revplot.AbstractPlotRenderer;
import org.eclipse.jgit.revplot.PlotCommit;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.themes.ColorUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SWTPlotRenderer
extends AbstractPlotRenderer<SWTCommitList.SWTLane, Color> {
    private static final int MAX_LABEL_LENGTH = 15;
    private final Color sys_black;
    private final Color sys_gray;
    private final Color sys_yellow;
    private final Color sys_green;
    private final Color sys_white;
    private final Color commitDotFill;
    private final Color commitDotOutline;
    private final Map<String, Point> labelCoordinates = new HashMap<String, Point>();
    private int textHeight;
    private boolean enableAntialias = true;
    GC g;
    int cellX;
    int cellY;
    Color cellFG;
    Color cellBG;
    private Ref headRef;

    SWTPlotRenderer(Display d) {
        this.sys_black = d.getSystemColor(2);
        this.sys_gray = d.getSystemColor(15);
        this.sys_yellow = d.getSystemColor(7);
        this.sys_green = d.getSystemColor(5);
        this.sys_white = d.getSystemColor(1);
        this.commitDotFill = new Color((Device)d, new RGB(220, 220, 220));
        this.commitDotOutline = new Color((Device)d, new RGB(110, 110, 110));
    }

    void dispose() {
        this.commitDotFill.dispose();
        this.commitDotOutline.dispose();
    }

    void paint(Event event, Ref actHeadRef) {
        this.g = event.gc;
        if (this.enableAntialias) {
            try {
                this.g.setAntialias(1);
            }
            catch (SWTException sWTException) {
                this.enableAntialias = false;
            }
        }
        this.headRef = actHeadRef;
        this.cellX = event.x;
        this.cellY = event.y;
        this.cellFG = this.g.getForeground();
        this.cellBG = this.g.getBackground();
        if (this.textHeight == 0) {
            this.textHeight = this.g.stringExtent((String)"/").y;
        }
        TableItem ti = (TableItem)event.item;
        this.paintCommit((PlotCommit)ti.getData(), event.height);
    }

    protected void drawLine(Color color, int x1, int y1, int x2, int y2, int width) {
        this.g.setForeground(color);
        this.g.setLineWidth(width);
        this.g.drawLine(this.cellX + x1, this.cellY + y1, this.cellX + x2, this.cellY + y2);
    }

    protected void drawDot(Color outline, Color fill, int x, int y, int w, int h) {
        int dotX = this.cellX + x + 2;
        int dotY = this.cellY + y + 1;
        int dotW = w - 2;
        int dotH = h - 2;
        this.g.setBackground(fill);
        this.g.fillOval(dotX, dotY, dotW, dotH);
        this.g.setForeground(outline);
        this.g.setLineWidth(2);
        this.g.drawOval(dotX, dotY, dotW, dotH);
    }

    protected void drawCommitDot(int x, int y, int w, int h) {
        this.drawDot(this.commitDotOutline, this.commitDotFill, x, y, w, h);
    }

    protected void drawBoundaryDot(int x, int y, int w, int h) {
        this.drawDot(this.sys_gray, this.sys_white, x, y, w, h);
    }

    protected void drawText(String msg, int x, int y) {
        Point textsz = this.g.textExtent(msg);
        int texty = (y * 2 - textsz.y) / 2;
        this.g.setForeground(this.cellFG);
        this.g.setBackground(this.cellBG);
        this.g.drawString(msg, this.cellX + x, this.cellY + texty, true);
    }

    protected int drawLabel(int x, int y, Ref ref) {
        String txt;
        String name = ref.getName();
        boolean tag = false;
        boolean branch = false;
        if (name.startsWith("refs/heads/")) {
            branch = true;
            this.g.setBackground(this.sys_green);
            txt = name.substring("refs/heads/".length());
        } else if (name.startsWith("refs/remotes/")) {
            branch = true;
            this.g.setBackground(this.sys_gray);
            txt = name.substring("refs/remotes/".length());
        } else if (name.startsWith("refs/tags/")) {
            tag = true;
            this.g.setBackground(this.sys_yellow);
            txt = name.substring("refs/tags/".length());
        } else {
            this.g.setBackground(this.sys_white);
            txt = name.startsWith("refs/") ? name.substring("refs/".length()) : name;
        }
        Color peeledColor = null;
        if (ref.getPeeledObjectId() == null || !ref.getPeeledObjectId().equals((AnyObjectId)ref.getObjectId())) {
            peeledColor = new Color(this.g.getDevice(), ColorUtil.blend((RGB)this.g.getBackground().getRGB(), (RGB)this.sys_white.getRGB()));
            this.g.setBackground(peeledColor);
        }
        int maxLength = tag ? Activator.getDefault().getPreferenceStore().getInt("HistoryView_MaxTagLength") : (branch ? Activator.getDefault().getPreferenceStore().getInt("HistoryView_MaxBranchLength") : 15);
        if (txt.length() > maxLength) {
            txt = String.valueOf(txt.substring(0, maxLength)) + "\u2026";
        }
        Font oldFont = this.g.getFont();
        boolean isHead = this.isHead(name);
        if (isHead) {
            this.g.setFont(CommitGraphTable.highlightFont());
        }
        Point textsz = this.g.stringExtent(txt);
        int arc = textsz.y / 2;
        int texty = (y * 2 - textsz.y) / 2;
        this.g.fillRoundRectangle(this.cellX + x + 1, this.cellY + texty - 1, textsz.x + 3, textsz.y + 1, arc, arc);
        this.g.setForeground(this.sys_black);
        this.g.drawString(txt, this.cellX + x + 2, this.cellY + texty, true);
        if (isHead) {
            this.g.setFont(oldFont);
        }
        this.g.setLineWidth(2);
        this.g.setAlpha(128);
        this.g.setForeground(this.sys_gray);
        this.g.drawRoundRectangle(this.cellX + x, this.cellY + texty - 2, textsz.x + 5, textsz.y + 3, arc, arc);
        this.g.setLineWidth(2);
        this.g.setForeground(this.sys_black);
        this.g.drawRoundRectangle(this.cellX + x + 1, this.cellY + texty - 1, textsz.x + 3, textsz.y + 1, arc, arc);
        this.g.setAlpha(255);
        if (peeledColor != null) {
            peeledColor.dispose();
        }
        this.labelCoordinates.put(name, new Point(x, x + textsz.x));
        return 8 + textsz.x;
    }

    private boolean isHead(String name) {
        String headRefName;
        boolean isHead = false;
        if (this.headRef != null && name.equals(headRefName = this.headRef.getLeaf().getName())) {
            isHead = true;
        }
        return isHead;
    }

    protected Color laneColor(SWTCommitList.SWTLane myLane) {
        return myLane != null ? myLane.color : this.sys_black;
    }

    public Point getRefHSpan(Ref ref) {
        return this.labelCoordinates.get(ref.getName());
    }

    public int getTextHeight() {
        return this.textHeight;
    }
}

