/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.push;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egit.core.op.ListRemoteOperation;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.UIUtils;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RefSpecDialog
extends TitleAreaDialog {
    private final boolean pushMode;
    private final Repository repo;
    private final RemoteConfig config;
    private RefSpec spec = new RefSpec();
    private Text sourceText;
    private Text destinationText;
    private Button forceButton;
    private Text specString;
    private boolean autoSuggestDestination;
    private List<Ref> sourceRefs;
    private List<Ref> destinationRefs;

    public RefSpecDialog(Shell parentShell, Repository repository, RemoteConfig config, boolean push) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x4F0);
        this.repo = repository;
        this.config = config;
        this.pushMode = push;
        this.autoSuggestDestination = !this.pushMode;
        this.setHelpAvailable(false);
    }

    public RefSpecDialog(Shell parentShell, Repository repository, RemoteConfig config, RefSpec spec, boolean push) {
        this(parentShell, repository, config, push);
        this.spec = spec;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(UIText.RefSpecDialog_WindowTitle);
    }

    public void create() {
        super.create();
        if (this.pushMode) {
            this.setTitle(UIText.RefSpecDialog_PushTitle);
            this.setMessage(UIText.RefSpecDialog_PushMessage);
        } else {
            this.setTitle(UIText.RefSpecDialog_FetchTitle);
            this.setMessage(UIText.RefSpecDialog_FetchMessage);
        }
        this.getButton(0).setEnabled(false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite main = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)main);
        main.setLayout((Layout)new GridLayout(2, false));
        Label sourceLabel = new Label(main, 0);
        if (this.pushMode) {
            sourceLabel.setText(UIText.RefSpecDialog_SourceBranchPushLabel);
        } else {
            sourceLabel.setText(UIText.RefSpecDialog_SourceBranchFetchLabel);
        }
        this.sourceText = new Text(main, 2048);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.sourceText);
        if (this.spec != null && this.spec.getSource() != null) {
            this.sourceText.setText(this.spec.getSource());
        }
        this.sourceText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (RefSpecDialog.this.sourceText.isFocusControl()) {
                    if (RefSpecDialog.this.autoSuggestDestination) {
                        String name = RefSpecDialog.this.sourceText.getText();
                        if (name.startsWith("refs/heads/")) {
                            name = name.substring("refs/heads/".length());
                        } else if (name.startsWith("refs/tags/")) {
                            name = name.substring("refs/tags/".length());
                        }
                        RefSpec sourceChanged = RefSpecDialog.this.getSpec().setSource(RefSpecDialog.this.sourceText.getText());
                        RefSpecDialog.this.setSpec(sourceChanged.setDestination("refs/remotes/" + RefSpecDialog.this.config.getName() + '/' + name));
                    } else {
                        RefSpecDialog.this.setSpec(RefSpecDialog.this.getSpec().setSource(RefSpecDialog.this.sourceText.getText()));
                    }
                }
            }
        });
        UIUtils.addRefContentProposalToText(this.sourceText, this.repo, new UIUtils.IRefListProvider(){

            @Override
            public List<Ref> getRefList() {
                return RefSpecDialog.this.getRefsForContentAssist(true);
            }
        });
        if (!this.pushMode) {
            final Button autoSuggest = new Button(main, 32);
            GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)autoSuggest);
            autoSuggest.setText(UIText.RefSpecDialog_AutoSuggestCheckbox);
            autoSuggest.setSelection(true);
            autoSuggest.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    RefSpecDialog.this.autoSuggestDestination = autoSuggest.getSelection();
                }
            });
        }
        Label destinationLabel = new Label(main, 0);
        if (this.pushMode) {
            destinationLabel.setText(UIText.RefSpecDialog_DestinationPushLabel);
        } else {
            destinationLabel.setText(UIText.RefSpecDialog_DestinationFetchLabel);
        }
        this.destinationText = new Text(main, 2048);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.destinationText);
        if (this.spec != null && this.spec.getDestination() != null) {
            this.destinationText.setText(this.spec.getDestination());
        }
        this.destinationText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (RefSpecDialog.this.destinationText.isFocusControl()) {
                    RefSpecDialog.this.setSpec(RefSpecDialog.this.getSpec().setDestination(RefSpecDialog.this.destinationText.getText()));
                }
            }
        });
        UIUtils.addRefContentProposalToText(this.destinationText, this.repo, new UIUtils.IRefListProvider(){

            @Override
            public List<Ref> getRefList() {
                return RefSpecDialog.this.getRefsForContentAssist(false);
            }
        });
        this.forceButton = new Button(main, 32);
        this.forceButton.setText(UIText.RefSpecDialog_ForceUpdateCheckbox);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)this.forceButton);
        if (this.spec != null) {
            this.forceButton.setSelection(this.spec.isForceUpdate());
        }
        this.forceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (RefSpecDialog.this.getSpec().isForceUpdate() == RefSpecDialog.this.forceButton.getSelection()) {
                    return;
                }
                RefSpecDialog.this.setSpec(RefSpecDialog.this.getSpec().setForceUpdate(RefSpecDialog.this.forceButton.getSelection()));
            }
        });
        Label stringLabel = new Label(main, 0);
        stringLabel.setText(UIText.RefSpecDialog_SpecificationLabel);
        this.specString = new Text(main, 2048);
        GridDataFactory.fillDefaults().span(2, 1).grab(true, false).applyTo((Control)this.specString);
        if (this.spec != null) {
            this.specString.setText(this.spec.toString());
        }
        this.specString.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!RefSpecDialog.this.specString.isFocusControl() || RefSpecDialog.this.getSpec().toString().equals(RefSpecDialog.this.specString.getText())) {
                    return;
                }
                RefSpecDialog.this.setSpec(new RefSpec(RefSpecDialog.this.specString.getText()));
            }
        });
        RefSpecDialog.applyDialogFont((Control)main);
        return main;
    }

    public RefSpec getSpec() {
        return this.spec;
    }

    private void setSpec(RefSpec spec) {
        this.setErrorMessage(null);
        this.spec = spec;
        String newSourceText = spec.getSource() != null ? spec.getSource() : "";
        String newDestinationText = spec.getDestination() != null ? spec.getDestination() : "";
        String newStringText = spec.toString();
        if (!this.sourceText.getText().equals(newSourceText)) {
            this.sourceText.setText(newSourceText);
        }
        if (!this.destinationText.getText().equals(newDestinationText)) {
            this.destinationText.setText(newDestinationText);
        }
        if (!this.specString.getText().equals(newStringText)) {
            this.specString.setText(newStringText);
        }
        this.forceButton.setSelection(spec.isForceUpdate());
        if (this.sourceText.getText().length() == 0 || this.destinationText.getText().length() == 0) {
            this.setErrorMessage(UIText.RefSpecDialog_MissingDataMessage);
        }
        this.getButton(0).setEnabled(this.sourceText.getText().length() > 0 && this.destinationText.getText().length() > 0);
    }

    private List<Ref> getRefsForContentAssist(boolean source) {
        if (source) {
            if (this.sourceRefs != null) {
                return this.sourceRefs;
            }
        } else if (this.destinationRefs != null) {
            return this.destinationRefs;
        }
        ArrayList<Ref> result = new ArrayList<Ref>();
        try {
            boolean local;
            boolean bl = local = this.pushMode == source;
            if (!local) {
                URIish uriToCheck = this.pushMode ? (this.config.getPushURIs().isEmpty() ? (URIish)this.config.getURIs().get(0) : (URIish)this.config.getPushURIs().get(0)) : (URIish)this.config.getURIs().get(0);
                final ListRemoteOperation lop = new ListRemoteOperation(this.repo, uriToCheck, Activator.getDefault().getPreferenceStore().getInt("remote_connection_timeout"));
                new ProgressMonitorDialog(this.getShell()).run(false, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        monitor.beginTask(UIText.RefSpecDialog_GettingRemoteRefsMonitorMessage, -1);
                        lop.run(monitor);
                        monitor.done();
                    }
                });
                for (Ref ref : lop.getRemoteRefs()) {
                    if (!ref.getName().startsWith("refs/heads/") && (this.pushMode || !ref.getName().startsWith("refs/tags/"))) continue;
                    result.add(ref);
                }
            } else if (this.pushMode) {
                for (Ref ref : this.repo.getRefDatabase().getRefs("").values()) {
                    if (ref.getName().startsWith("refs/remotes/")) continue;
                    result.add(ref);
                }
            } else {
                for (Ref ref : this.repo.getRefDatabase().getRefs("refs/remotes/").values()) {
                    result.add(ref);
                }
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            Activator.handleError(e.getMessage(), e, true);
            return result;
        }
        if (source) {
            this.sourceRefs = result;
        } else {
            this.destinationRefs = result;
        }
        return result;
    }
}

