/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.synchronize;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.compare.CompareNavigator;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ModelProvider;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.egit.core.synchronize.GitSubscriberMergeContext;
import org.eclipse.egit.core.synchronize.dto.GitSynchronizeData;
import org.eclipse.egit.core.synchronize.dto.GitSynchronizeDataSet;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.synchronize.GitActionContributor;
import org.eclipse.egit.ui.internal.synchronize.GitChangeSetModelProvider;
import org.eclipse.egit.ui.internal.synchronize.GitTreeCompareNavigator;
import org.eclipse.egit.ui.internal.synchronize.compare.ComparisonDataSource;
import org.eclipse.egit.ui.internal.synchronize.compare.GitCompareInput;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelBlob;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.team.core.mapping.provider.SynchronizationContext;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ModelSynchronizeParticipant;
import org.eclipse.team.ui.synchronize.SynchronizePageActionGroup;

public class GitModelSynchronizeParticipant
extends ModelSynchronizeParticipant {
    public static final String SYNCHRONIZATION_DATA = "GIT_SYNCHRONIZE_DATA_SET";
    public static final String ID = "org.eclipse.egit.ui.modelCompareParticipant";
    public static final String VIEWER_ID = "org.eclipse.egit.ui.compareSynchronization";
    private static final String P_NAVIGATOR = "org.eclipse.team.ui.P_NAVIGATOR";
    private static final String WORKSPACE_MODEL_PROVIDER_ID = "org.eclipse.core.resources.modelProvider";
    private final GitSynchronizeDataSet gsds;

    public GitModelSynchronizeParticipant(GitSubscriberMergeContext context) {
        super((SynchronizationContext)context);
        this.gsds = context.getSyncData();
        try {
            this.setInitializationData(TeamUI.getSynchronizeManager().getParticipantDescriptor(ID));
        }
        catch (CoreException e) {
            Activator.logError(e.getMessage(), e);
        }
        this.setSecondaryId(Long.toString(System.currentTimeMillis()));
    }

    protected void initializeConfiguration(final ISynchronizePageConfiguration configuration) {
        configuration.setProperty("org.eclipse.team.ui.P_VIEWER_ID", (Object)VIEWER_ID);
        String modelProvider = WORKSPACE_MODEL_PROVIDER_ID;
        final IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
        if (!this.gsds.containsFolderLevelSynchronizationRequest()) {
            if (preferenceStore.getBoolean("sync_view_show_changeset_model")) {
                modelProvider = "org.eclipse.egit.ui.changeSetModel";
            } else {
                String lastSelectedModel = preferenceStore.getString("sync_view_last_selected_model");
                if (!"".equals(lastSelectedModel)) {
                    modelProvider = lastSelectedModel;
                }
            }
        }
        configuration.setProperty("org.eclipse.team.ui.activeModelProvider", (Object)modelProvider);
        configuration.setProperty(SYNCHRONIZATION_DATA, (Object)this.gsds);
        super.initializeConfiguration(configuration);
        configuration.addActionContribution((SynchronizePageActionGroup)new GitActionContributor());
        configuration.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                Object oldNavigator;
                String property = event.getProperty();
                if (property.equals("org.eclipse.team.ui.activeModelProvider")) {
                    String newValue = (String)event.getNewValue();
                    preferenceStore.setValue("sync_view_last_selected_model", newValue);
                } else if (property.equals(GitModelSynchronizeParticipant.P_NAVIGATOR) && !((oldNavigator = configuration.getProperty(GitModelSynchronizeParticipant.P_NAVIGATOR)) instanceof GitTreeCompareNavigator)) {
                    configuration.setProperty(GitModelSynchronizeParticipant.P_NAVIGATOR, (Object)new GitTreeCompareNavigator((CompareNavigator)oldNavigator));
                }
            }
        });
    }

    public ModelProvider[] getEnabledModelProviders() {
        ModelProvider[] avaliableProviders;
        ModelProvider[] modelProviderArray = avaliableProviders = super.getEnabledModelProviders();
        int n = avaliableProviders.length;
        int n2 = 0;
        while (n2 < n) {
            ModelProvider provider = modelProviderArray[n2];
            if (provider.getId().equals("org.eclipse.egit.ui.changeSetModel")) {
                return avaliableProviders;
            }
            ++n2;
        }
        int capacity = avaliableProviders.length + 1;
        ArrayList<GitChangeSetModelProvider> providers = new ArrayList<GitChangeSetModelProvider>(capacity);
        providers.add(GitChangeSetModelProvider.getProvider());
        return providers.toArray(new ModelProvider[providers.size()]);
    }

    public boolean hasCompareInputFor(Object object) {
        IResource res;
        if (object instanceof GitModelBlob || object instanceof IFile) {
            return true;
        }
        if (object instanceof IAdaptable && (res = (IResource)((IAdaptable)object).getAdapter(IResource.class)) != null && res.getType() == 1) {
            return true;
        }
        return super.hasCompareInputFor(object);
    }

    public ICompareInput asCompareInput(Object object) {
        IFile file;
        GitSynchronizeData gsd;
        if (object instanceof IFile && !(gsd = this.gsds.getData((file = (IFile)object).getProject())).shouldIncludeLocal()) {
            return this.getFileFromGit(gsd, file.getLocation());
        }
        return super.asCompareInput(object);
    }

    private ICompareInput getFileFromGit(GitSynchronizeData gsd, IPath location) {
        Repository repo = gsd.getRepository();
        File workTree = repo.getWorkTree();
        String repoRelativeLocation = Repository.stripWorkDir((File)workTree, (File)location.toFile());
        TreeWalk tw = new TreeWalk(repo);
        tw.setRecursive(true);
        tw.setFilter((TreeFilter)PathFilter.create((String)repoRelativeLocation.toString()));
        RevCommit baseCommit = gsd.getSrcRevCommit();
        RevCommit remoteCommit = gsd.getDstRevCommit();
        try {
            int baseNth = tw.addTree((AnyObjectId)baseCommit.getTree());
            int remoteNth = tw.addTree((AnyObjectId)remoteCommit.getTree());
            if (tw.next()) {
                ComparisonDataSource baseData = new ComparisonDataSource(baseCommit, tw.getObjectId(baseNth));
                ComparisonDataSource remoteData = new ComparisonDataSource(remoteCommit, tw.getObjectId(remoteNth));
                return new GitCompareInput(repo, baseData, baseData, remoteData, repoRelativeLocation);
            }
        }
        catch (IOException e) {
            Activator.logError(e.getMessage(), e);
        }
        return null;
    }
}

