/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.synchronize.mapping;

import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelTree;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.TreeFilter;

class GitTreeTraversal
extends ResourceTraversal {
    private static final IWorkspaceRoot ROOT = ResourcesPlugin.getWorkspace().getRoot();
    private static Repository lastRepo;
    private static FileTreeIterator fileTreeIterator;

    public GitTreeTraversal(GitModelTree modelTree) {
        this(modelTree.getRepository(), (AnyObjectId)modelTree.getBaseId(), (AnyObjectId)modelTree.getRemoteId(), modelTree.getLocation());
    }

    public GitTreeTraversal(Repository repo, RevCommit commit) {
        this(repo, commit, (IPath)new Path(repo.getWorkTree().toString()));
    }

    private GitTreeTraversal(Repository repo, AnyObjectId baseId, AnyObjectId actualId, IPath path) {
        super(GitTreeTraversal.getResourcesImpl(repo, baseId, actualId, path), 2, 0);
    }

    private GitTreeTraversal(Repository repo, RevCommit commit, IPath path) {
        super(GitTreeTraversal.getResourcesImpl(repo, commit, path), 2, 0);
    }

    private static IResource[] getResourcesImpl(Repository repo, RevCommit commit, IPath path) {
        RevCommit[] parents = commit.getParents();
        ObjectId baseId = parents.length > 0 ? parents[0].getTree().getId() : ObjectId.zeroId();
        ObjectId remoteId = commit.getTree().getId();
        return GitTreeTraversal.getResourcesImpl(repo, (AnyObjectId)baseId, (AnyObjectId)remoteId, path);
    }

    private static IResource[] getResourcesImpl(Repository repo, AnyObjectId baseId, AnyObjectId remoteId, IPath path) {
        if (remoteId.equals((AnyObjectId)ObjectId.zeroId())) {
            return new IResource[0];
        }
        TreeWalk tw = new TreeWalk(repo);
        ArrayList<IFile> result = new ArrayList<IFile>();
        tw.reset();
        tw.setRecursive(false);
        tw.setFilter(TreeFilter.ANY_DIFF);
        try {
            if (fileTreeIterator == null || !repo.equals(lastRepo)) {
                lastRepo = repo;
                fileTreeIterator = new FileTreeIterator(repo);
            } else {
                fileTreeIterator.reset();
            }
            tw.addTree((AbstractTreeIterator)fileTreeIterator);
            if (!baseId.equals((AnyObjectId)ObjectId.zeroId())) {
                tw.addTree(baseId);
            }
            int actualNth = tw.addTree(remoteId);
            while (tw.next()) {
                int objectType = tw.getFileMode(actualNth).getObjectType();
                String name = tw.getNameString();
                IPath childPath = path.append(name);
                IFile resource = null;
                if (objectType == 3) {
                    resource = ROOT.getFileForLocation(childPath);
                } else if (objectType == 2) {
                    resource = ROOT.getContainerForLocation(childPath);
                }
                if (resource == null) continue;
                result.add(resource);
            }
        }
        catch (IOException e) {
            Activator.logError((String)e.getMessage(), (Throwable)e);
        }
        return result.toArray(new IResource[result.size()]);
    }
}

