/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.synchronize.model;

import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.core.runtime.IPath;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelCommit;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelObject;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelObjectContainer;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.treewalk.TreeWalk;

public class GitModelTree
extends GitModelCommit {
    private final ObjectId baseId;
    private final ObjectId remoteId;
    private final ObjectId ancestorId;
    private final IPath location;

    public GitModelTree(GitModelObjectContainer parent, RevCommit commit, RevCommit ancestorCommit, ObjectId ancestorId, ObjectId baseId, ObjectId remoteId, IPath location) throws IOException {
        super(parent, commit, ancestorCommit, parent.getKind() & 0xC);
        this.baseId = baseId;
        this.remoteId = remoteId;
        this.ancestorId = ancestorId;
        this.location = location;
    }

    public String getName() {
        return this.location.lastSegment();
    }

    public ObjectId getBaseId() {
        return this.baseId;
    }

    public ObjectId getRemoteId() {
        return this.remoteId;
    }

    public IPath getLocation() {
        return this.location;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        GitModelTree objTree = (GitModelTree)((Object)obj);
        return objTree.location.equals((Object)this.location) && objTree.baseCommit.equals((AnyObjectId)this.baseCommit);
    }

    public int hashCode() {
        return this.baseCommit.hashCode() ^ this.location.hashCode();
    }

    public String toString() {
        return "ModelTree[baseCommit=" + this.baseCommit.getId() + ", location=" + this.getLocation() + "]";
    }

    protected GitModelObject[] getChildrenImpl() {
        TreeWalk tw = this.createTreeWalk();
        ArrayList<GitModelObject> result = new ArrayList<GitModelObject>();
        try {
            int remoteNth = -1;
            if (!this.remoteId.equals((AnyObjectId)ObjectId.zeroId())) {
                remoteNth = tw.addTree((AnyObjectId)this.remoteId);
            }
            int baseNth = -1;
            if (!this.baseId.equals((AnyObjectId)ObjectId.zeroId())) {
                baseNth = tw.addTree((AnyObjectId)this.baseId);
            }
            int ancestorNth = -1;
            if (!this.ancestorId.equals((AnyObjectId)ObjectId.zeroId())) {
                ancestorNth = tw.addTree((AnyObjectId)this.ancestorId);
            }
            while (tw.next()) {
                GitModelObject obj = this.getModelObject(tw, this.ancestorCommit, ancestorNth, remoteNth, baseNth);
                if (obj == null) continue;
                result.add(obj);
            }
        }
        catch (IOException e) {
            Activator.logError((String)e.getMessage(), (Throwable)e);
        }
        return result.toArray(new GitModelObject[result.size()]);
    }
}

