/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.executables;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.settings.model.ICConfigExtensionReference;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.executables.Executable;
import org.eclipse.cdt.debug.core.executables.ExecutablesManager;
import org.eclipse.cdt.debug.core.executables.IExecutableImporter;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.debug.core.DebugPlugin;

public class StandardExecutableImporter
implements IExecutableImporter {
    public static final String DEBUG_PROJECT_ID = "org.eclipse.cdt.debug";

    public boolean importExecutables(String[] fileNames, IProgressMonitor monitor) {
        monitor.beginTask("Import Executables", fileNames.length);
        IProject exeProject = null;
        boolean checkProject = false;
        boolean handled = false;
        String[] stringArray = fileNames;
        int n = fileNames.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            try {
                path = new File(path).getCanonicalPath();
            }
            catch (IOException iOException) {}
            if (this.AllowImport(Path.fromOSString((String)path))) {
                if (!checkProject) {
                    String defaultProjectName = "Executables";
                    ICProject cProject = CoreModel.getDefault().getCModel().getCProject(defaultProjectName);
                    if (cProject.exists()) {
                        exeProject = cProject.getProject();
                    } else {
                        String[] ignoreList = new String[]{".project", ".cdtproject", ".cproject", ".cdtbuild", ".settings"};
                        IWorkspace workspace = ResourcesPlugin.getWorkspace();
                        IProject newProjectHandle = workspace.getRoot().getProject(defaultProjectName);
                        int projectSuffix = 2;
                        while (newProjectHandle.exists()) {
                            newProjectHandle = workspace.getRoot().getProject(String.valueOf(defaultProjectName) + projectSuffix);
                            ++projectSuffix;
                        }
                        IProjectDescription description = workspace.newProjectDescription(newProjectHandle.getName());
                        description.setLocation(null);
                        try {
                            IFileStore[] children;
                            IFileStore store = EFS.getStore((URI)workspace.getRoot().getLocationURI());
                            store = store.getChild(newProjectHandle.getName());
                            String[] stringArray2 = ignoreList;
                            int n3 = ignoreList.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                String deleteName = stringArray2[n4];
                                IFileStore projFile = store.getChild(deleteName);
                                projFile.delete(0, (IProgressMonitor)new NullProgressMonitor());
                                ++n4;
                            }
                            IFileStore[] iFileStoreArray = children = store.childStores(0, (IProgressMonitor)new NullProgressMonitor());
                            int n5 = children.length;
                            n3 = 0;
                            while (n3 < n5) {
                                IFileStore fileStore = iFileStoreArray[n3];
                                if (fileStore.fetchInfo().isDirectory()) {
                                    fileStore.delete(0, (IProgressMonitor)new NullProgressMonitor());
                                }
                                ++n3;
                            }
                            exeProject = CCorePlugin.getDefault().createCProject(description, newProjectHandle, null, DEBUG_PROJECT_ID);
                        }
                        catch (OperationCanceledException e) {
                            DebugPlugin.log((Throwable)e);
                        }
                        catch (CoreException e) {
                            DebugPlugin.log((Throwable)e);
                        }
                    }
                    checkProject = true;
                }
                this.importExecutable(exeProject, path);
                handled = true;
            }
            monitor.worked(1);
            if (monitor.isCanceled()) break;
            ++n2;
        }
        monitor.done();
        return handled;
    }

    public boolean AllowImport(IPath path) {
        return !ExecutablesManager.getExecutablesManager().executableExists(path);
    }

    private IContainer createFromRoot(IProject exeProject, IPath path) throws CoreException {
        int segmentCount = path.segmentCount() - 1;
        IProject currentFolder = exeProject;
        int i = 0;
        while (i < segmentCount) {
            if (!(currentFolder = currentFolder.getFolder((IPath)new Path(path.segment(i)))).exists()) {
                ((IFolder)currentFolder).create(false, true, (IProgressMonitor)new NullProgressMonitor());
            }
            ++i;
        }
        return currentFolder;
    }

    private void importExecutable(IProject exeProject, String path) {
        IPath location = Path.fromOSString((String)path);
        String executableName = location.toFile().getName();
        try {
            IContainer fileContainer = this.createFromRoot(exeProject, location);
            Path exectuableFilePath = new Path(executableName);
            IFile exeFile = fileContainer.getFile((IPath)exectuableFilePath);
            if (!exeFile.exists() && this.validateBinaryParsers(exeProject, new File(path))) {
                this.ensureBinaryType((IPath)exectuableFilePath);
                exeFile.createLink(location, 0, null);
            }
        }
        catch (CoreException e) {
            CDebugCorePlugin.log(e);
        }
    }

    private void ensureBinaryType(IPath exectuableFilePath) {
        if (Executable.isBinaryFile(exectuableFilePath)) {
            return;
        }
        String ext = exectuableFilePath.getFileExtension();
        if (ext != null) {
            IContentTypeManager ctm = Platform.getContentTypeManager();
            IContentType ctbin = ctm.getContentType("org.eclipse.cdt.core.binaryFile");
            try {
                ctbin.addFileSpec(ext, 8);
            }
            catch (CoreException e) {
                CDebugCorePlugin.log(e);
            }
        }
    }

    private boolean isExtensionVisible(IExtension ext) {
        IConfigurationElement[] elements;
        IConfigurationElement[] iConfigurationElementArray = elements = ext.getConfigurationElements();
        if (elements.length != 0) {
            IConfigurationElement element = iConfigurationElementArray[0];
            IConfigurationElement[] children = element.getChildren("filter");
            int j = 0;
            while (j < children.length) {
                String value;
                String name = children[j].getAttribute("name");
                if (name != null && name.equals("visibility") && (value = children[j].getAttribute("value")) != null && value.equals("private")) {
                    return false;
                }
                ++j;
            }
            return true;
        }
        return false;
    }

    private IBinaryParser instantiateBinaryParser(IExtension ext) {
        IBinaryParser parser = null;
        IConfigurationElement[] elements = ext.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement[] children = elements[i].getChildren("run");
            int j = 0;
            while (j < children.length) {
                try {
                    parser = (IBinaryParser)children[j].createExecutableExtension("class");
                }
                catch (CoreException e) {
                    CDebugCorePlugin.log(e);
                }
                ++j;
            }
            ++i;
        }
        return parser;
    }

    private boolean validateBinaryParsers(IProject exeProject, File file) {
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.cdt.core", "BinaryParser");
        if (point != null) {
            IExtension[] exts = point.getExtensions();
            ArrayList<IExtension> extensionsInUse = new ArrayList<IExtension>();
            int i = 0;
            while (i < exts.length) {
                if (this.isExtensionVisible(exts[i])) {
                    extensionsInUse.add(exts[i]);
                }
                ++i;
            }
            IExtension[] binaryParserExtensions = extensionsInUse.toArray(new IExtension[extensionsInUse.size()]);
            i = 0;
            while (i < binaryParserExtensions.length) {
                IBinaryParser parser = this.instantiateBinaryParser(binaryParserExtensions[i]);
                if (this.isBinary(file, parser)) {
                    String parserID = binaryParserExtensions[i].getUniqueIdentifier();
                    ICProjectDescription pd = CCorePlugin.getDefault().getProjectDescription(exeProject);
                    try {
                        ICConfigExtensionReference[] parsers;
                        boolean existsAlready = false;
                        ICConfigExtensionReference[] iCConfigExtensionReferenceArray = parsers = pd.getDefaultSettingConfiguration().get("org.eclipse.cdt.core.BinaryParser");
                        int n = parsers.length;
                        int n2 = 0;
                        while (n2 < n) {
                            ICConfigExtensionReference configExtensionReference = iCConfigExtensionReferenceArray[n2];
                            if (configExtensionReference.getID().equals(parserID)) {
                                existsAlready = true;
                                break;
                            }
                            ++n2;
                        }
                        if (!existsAlready) {
                            pd.getDefaultSettingConfiguration().create("org.eclipse.cdt.core.BinaryParser", parserID);
                            CCorePlugin.getDefault().setProjectDescription(exeProject, pd, true, (IProgressMonitor)new NullProgressMonitor());
                        }
                    }
                    catch (CoreException coreException) {}
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private boolean isBinary(File file, IBinaryParser parser) {
        if (parser != null) {
            try {
                IBinaryParser.IBinaryFile bin = parser.getBinary((IPath)new Path(file.getAbsolutePath()));
                return bin != null && (bin.getType() == 2 || bin.getType() == 4);
            }
            catch (IOException iOException) {
                return false;
            }
        }
        return false;
    }

    public int getPriority(String[] fileNames) {
        return 50;
    }
}

