/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.settings.model;

import java.util.Arrays;
import org.eclipse.cdt.core.settings.model.ACPathEntry;
import org.eclipse.cdt.core.settings.model.ICExclusionPatternPathEntry;
import org.eclipse.cdt.core.settings.model.ICSettingEntry;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;

public abstract class ACExclusionFilterEntry
extends ACPathEntry
implements ICExclusionPatternPathEntry {
    private IPath[] exclusionPatterns;
    private static final char[][] UNINIT_PATTERNS = new char[][]{"Non-initialized yet".toCharArray()};
    char[][] fullCharExclusionPatterns = UNINIT_PATTERNS;

    ACExclusionFilterEntry(IPath path, IPath[] exclusionPatterns, int flags) {
        super(path, flags);
        this.exclusionPatterns = exclusionPatterns != null ? (IPath[])exclusionPatterns.clone() : new IPath[]{};
    }

    ACExclusionFilterEntry(IFolder rc, IPath[] exclusionPatterns, int flags) {
        super((IResource)rc, flags);
        this.exclusionPatterns = exclusionPatterns != null ? (IPath[])exclusionPatterns.clone() : new IPath[]{};
    }

    ACExclusionFilterEntry(String value, IPath[] exclusionPatterns, int flags) {
        super(value, flags);
        this.exclusionPatterns = exclusionPatterns != null ? (IPath[])exclusionPatterns.clone() : new IPath[]{};
    }

    protected final boolean isFile() {
        return false;
    }

    public IPath[] getExclusionPatterns() {
        return this.exclusionPatterns.length != 0 ? (IPath[])this.exclusionPatterns.clone() : this.exclusionPatterns;
    }

    public char[][] fullExclusionPatternChars() {
        if (this.fullCharExclusionPatterns == UNINIT_PATTERNS) {
            int length = this.exclusionPatterns.length;
            this.fullCharExclusionPatterns = new char[length][];
            IPath path = this.getFullPath();
            if (path == null) {
                path = this.getLocation();
            }
            IPath prefixPath = path.removeTrailingSeparator();
            int i = 0;
            while (i < length) {
                this.fullCharExclusionPatterns[i] = prefixPath.append(this.exclusionPatterns[i]).toString().toCharArray();
                ++i;
            }
        }
        return this.fullCharExclusionPatterns;
    }

    public boolean equals(Object other) {
        if (!super.equals(other)) {
            return false;
        }
        ACExclusionFilterEntry otherEntry = (ACExclusionFilterEntry)other;
        return Arrays.equals(this.exclusionPatterns, otherEntry.exclusionPatterns);
    }

    public int hashCode() {
        return super.hashCode() + this.exclusionPatterns.hashCode();
    }

    public boolean equalsByContents(ICSettingEntry entry) {
        if (!super.equalsByContents(entry)) {
            return false;
        }
        ACExclusionFilterEntry otherEntry = (ACExclusionFilterEntry)entry;
        return Arrays.equals(this.exclusionPatterns, otherEntry.exclusionPatterns);
    }

    protected String contentsToString() {
        String result = super.contentsToString();
        if (this.exclusionPatterns.length != 0) {
            StringBuffer buf = new StringBuffer();
            buf.append(result);
            buf.append(" ; exclude: ");
            int i = 0;
            while (i < this.exclusionPatterns.length) {
                if (i != 0) {
                    buf.append(", ");
                }
                buf.append(this.exclusionPatterns[i].toString());
                ++i;
            }
            result = buf.toString();
        }
        return result;
    }
}

