/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.settings.model;

import org.eclipse.cdt.core.settings.model.ICSettingEntry;
import org.eclipse.cdt.core.settings.model.util.LanguageSettingEntriesSerializer;

public abstract class ACSettingEntry
implements ICSettingEntry {
    int fFlags;
    String fName;

    ACSettingEntry(String name, int flags) {
        this.fName = name;
        this.fFlags = flags;
    }

    public boolean isBuiltIn() {
        return this.checkFlags(1);
    }

    public boolean isReadOnly() {
        return this.checkFlags(2);
    }

    protected boolean checkFlags(int flags) {
        return (this.fFlags & flags) == flags;
    }

    public String getName() {
        return this.fName;
    }

    public String getValue() {
        return this.fName;
    }

    public boolean isResolved() {
        return this.checkFlags(16);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ACSettingEntry)) {
            return false;
        }
        ACSettingEntry e = (ACSettingEntry)other;
        if (this.getKind() != e.getKind()) {
            return false;
        }
        if (this.fFlags != e.fFlags) {
            return false;
        }
        return this.fName.equals(e.fName);
    }

    public int hashCode() {
        return this.getKind() + this.fFlags + this.fName.hashCode();
    }

    public int getFlags() {
        return this.fFlags;
    }

    public boolean equalsByContents(ICSettingEntry entry) {
        return this.equalsByName(entry);
    }

    protected int getByNameMatchFlags() {
        return this.fFlags & 0xFFFFFFEC;
    }

    public final boolean equalsByName(ICSettingEntry entry) {
        if (entry == this) {
            return true;
        }
        if (!(entry instanceof ACSettingEntry)) {
            return false;
        }
        ACSettingEntry e = (ACSettingEntry)entry;
        if (this.getKind() != e.getKind()) {
            return false;
        }
        if (this.getByNameMatchFlags() != e.getByNameMatchFlags()) {
            return false;
        }
        return this.fName.equals(e.fName);
    }

    public final int codeForNameKey() {
        return this.getKind() + this.getByNameMatchFlags() + this.fName.hashCode();
    }

    public int codeForContentsKey() {
        return this.codeForNameKey();
    }

    public final String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append('[').append(LanguageSettingEntriesSerializer.kindToString(this.getKind())).append(']').append(' ');
        buf.append(this.contentsToString());
        buf.append(" ; flags: ").append(LanguageSettingEntriesSerializer.composeFlagsString(this.getFlags()));
        return buf.toString();
    }

    protected abstract String contentsToString();
}

