/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.c;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTLiteralExpression;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBasicType;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.ProblemType;
import org.eclipse.cdt.internal.core.dom.parser.c.CBasicType;
import org.eclipse.cdt.internal.core.dom.parser.c.CPointerType;
import org.eclipse.cdt.internal.core.dom.parser.c.CQualifierType;

public class CASTLiteralExpression
extends ASTNode
implements IASTLiteralExpression {
    private int kind;
    private char[] value = CharArrayUtils.EMPTY;

    public CASTLiteralExpression() {
    }

    public CASTLiteralExpression(int kind, char[] value) {
        this.kind = kind;
        this.value = value;
    }

    public CASTLiteralExpression copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    public CASTLiteralExpression copy(IASTNode.CopyStyle style) {
        CASTLiteralExpression copy = new CASTLiteralExpression(this.kind, this.value == null ? null : (char[])this.value.clone());
        copy.setOffsetAndLength(this);
        if (style == IASTNode.CopyStyle.withLocations) {
            copy.setCopyLocation(this);
        }
        return copy;
    }

    public int getKind() {
        return this.kind;
    }

    public void setKind(int value) {
        this.assertNotFrozen();
        this.kind = value;
    }

    public char[] getValue() {
        return this.value;
    }

    public void setValue(char[] value) {
        this.assertNotFrozen();
        this.value = value;
    }

    public String toString() {
        return new String(this.value);
    }

    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitExpressions) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (action.shouldVisitExpressions) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    public IType getExpressionType() {
        switch (this.getKind()) {
            case 2: {
                return new CBasicType(IBasicType.Kind.eChar, 0, this);
            }
            case 1: {
                return this.classifyTypeOfFloatLiteral();
            }
            case 0: {
                return this.classifyTypeOfIntLiteral();
            }
            case 3: {
                IType type = new CBasicType(IBasicType.Kind.eChar, 0, this);
                type = new CQualifierType(type, true, false, false);
                return new CPointerType(type, 0);
            }
        }
        return new ProblemType(10004);
    }

    public boolean isLValue() {
        return this.getKind() == 3;
    }

    public final IASTExpression.ValueCategory getValueCategory() {
        return this.isLValue() ? IASTExpression.ValueCategory.LVALUE : IASTExpression.ValueCategory.PRVALUE;
    }

    private IType classifyTypeOfFloatLiteral() {
        char[] lit = this.getValue();
        int len = lit.length;
        IBasicType.Kind kind = IBasicType.Kind.eDouble;
        int flags = 0;
        if (len > 0) {
            switch (lit[len - 1]) {
                case 'F': 
                case 'f': {
                    kind = IBasicType.Kind.eFloat;
                    break;
                }
                case 'L': 
                case 'l': {
                    flags |= 1;
                }
            }
        }
        return new CBasicType(kind, flags, this);
    }

    private IType classifyTypeOfIntLiteral() {
        int makelong = 0;
        boolean unsigned = false;
        char[] lit = this.getValue();
        int i = lit.length - 1;
        while (i >= 0) {
            char c = lit[i];
            if (!(c > 'f' && c <= 'z' || c > 'F' && c <= 'Z')) break;
            switch (c) {
                case 'U': 
                case 'u': {
                    unsigned = true;
                    break;
                }
                case 'L': 
                case 'l': {
                    ++makelong;
                }
            }
            --i;
        }
        int flags = 0;
        if (unsigned) {
            flags |= 8;
        }
        if (makelong > 1) {
            flags |= 0x40;
        } else if (makelong == 1) {
            flags |= 1;
        }
        return new CBasicType(IBasicType.Kind.eInt, flags, this);
    }

    @Deprecated
    public void setValue(String value) {
        this.assertNotFrozen();
        this.value = value.toCharArray();
    }

    @Deprecated
    public CASTLiteralExpression(int kind, String value) {
        this(kind, value.toCharArray());
    }
}

