/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTConstructorChainInitializer;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDefinition;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.ASTQueries;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;

public class CPPASTFunctionDefinition
extends ASTNode
implements ICPPASTFunctionDefinition,
IASTAmbiguityParent {
    private IASTDeclSpecifier declSpecifier;
    private IASTFunctionDeclarator declarator;
    private IASTStatement bodyStatement;
    private ICPPASTConstructorChainInitializer[] memInits = null;
    private int memInitPos = -1;
    private boolean fDeleted = false;
    private boolean fDefaulted = false;

    public CPPASTFunctionDefinition() {
    }

    public CPPASTFunctionDefinition(IASTDeclSpecifier declSpecifier, IASTFunctionDeclarator declarator, IASTStatement bodyStatement) {
        this.setDeclSpecifier(declSpecifier);
        this.setDeclarator(declarator);
        this.setBody(bodyStatement);
    }

    public CPPASTFunctionDefinition copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    public CPPASTFunctionDefinition copy(IASTNode.CopyStyle style) {
        CPPASTFunctionDefinition copy = new CPPASTFunctionDefinition();
        copy.setDeclSpecifier(this.declSpecifier == null ? null : this.declSpecifier.copy(style));
        if (this.declarator != null) {
            IASTDeclarator outer = ASTQueries.findOutermostDeclarator(this.declarator);
            outer = outer.copy(style);
            copy.setDeclarator((IASTFunctionDeclarator)ASTQueries.findTypeRelevantDeclarator(outer));
        }
        copy.setBody(this.bodyStatement == null ? null : this.bodyStatement.copy(style));
        ICPPASTConstructorChainInitializer[] iCPPASTConstructorChainInitializerArray = this.getMemberInitializers();
        int n = iCPPASTConstructorChainInitializerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPASTConstructorChainInitializer initializer = iCPPASTConstructorChainInitializerArray[n2];
            copy.addMemberInitializer(initializer == null ? null : initializer.copy(style));
            ++n2;
        }
        copy.fDefaulted = this.fDefaulted;
        copy.fDeleted = this.fDeleted;
        copy.setOffsetAndLength(this);
        if (style == IASTNode.CopyStyle.withLocations) {
            copy.setCopyLocation(this);
        }
        return copy;
    }

    public IASTDeclSpecifier getDeclSpecifier() {
        return this.declSpecifier;
    }

    public void setDeclSpecifier(IASTDeclSpecifier declSpec) {
        this.assertNotFrozen();
        this.declSpecifier = declSpec;
        if (declSpec != null) {
            declSpec.setParent(this);
            declSpec.setPropertyInParent(DECL_SPECIFIER);
        }
    }

    public IASTFunctionDeclarator getDeclarator() {
        return this.declarator;
    }

    public void setDeclarator(IASTFunctionDeclarator declarator) {
        this.assertNotFrozen();
        this.declarator = declarator;
        if (declarator != null) {
            IASTDeclarator outerDtor = ASTQueries.findOutermostDeclarator(declarator);
            outerDtor.setParent(this);
            outerDtor.setPropertyInParent(DECLARATOR);
        }
    }

    public IASTStatement getBody() {
        return this.bodyStatement;
    }

    public void setBody(IASTStatement statement) {
        this.assertNotFrozen();
        this.bodyStatement = statement;
        if (statement != null) {
            statement.setParent(this);
            statement.setPropertyInParent(FUNCTION_BODY);
        }
    }

    public void addMemberInitializer(ICPPASTConstructorChainInitializer initializer) {
        this.assertNotFrozen();
        if (initializer != null) {
            this.memInits = ArrayUtil.appendAt(ICPPASTConstructorChainInitializer.class, this.memInits, ++this.memInitPos, initializer);
            initializer.setParent(this);
            initializer.setPropertyInParent(MEMBER_INITIALIZER);
        }
    }

    public ICPPASTConstructorChainInitializer[] getMemberInitializers() {
        if (this.memInits == null) {
            return ICPPASTConstructorChainInitializer.EMPTY_CONSTRUCTORCHAININITIALIZER_ARRAY;
        }
        this.memInits = ArrayUtil.trimAt(ICPPASTConstructorChainInitializer.class, this.memInits, this.memInitPos);
        return this.memInits;
    }

    public IScope getScope() {
        return ((ICPPASTFunctionDeclarator)this.declarator).getFunctionScope();
    }

    public boolean isDefaulted() {
        return this.fDefaulted;
    }

    public boolean isDeleted() {
        return this.fDeleted;
    }

    public void setIsDefaulted(boolean isDefaulted) {
        this.assertNotFrozen();
        this.fDefaulted = isDefaulted;
    }

    public void setIsDeleted(boolean isDeleted) {
        this.assertNotFrozen();
        this.fDeleted = isDeleted;
    }

    public boolean accept(ASTVisitor action) {
        ICPPASTConstructorChainInitializer[] chain;
        if (action.shouldVisitDeclarations) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.declSpecifier != null && !this.declSpecifier.accept(action)) {
            return false;
        }
        IASTDeclarator outerDtor = ASTQueries.findOutermostDeclarator(this.declarator);
        if (outerDtor != null && !outerDtor.accept(action)) {
            return false;
        }
        ICPPASTConstructorChainInitializer[] iCPPASTConstructorChainInitializerArray = chain = this.getMemberInitializers();
        int n = chain.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPASTConstructorChainInitializer memInit = iCPPASTConstructorChainInitializerArray[n2];
            if (!memInit.accept(action)) {
                return false;
            }
            ++n2;
        }
        if (this.bodyStatement != null && !this.bodyStatement.accept(action)) {
            return false;
        }
        if (!this.acceptCatchHandlers(action)) {
            return false;
        }
        return !action.shouldVisitDeclarations || action.leave(this) != 2;
    }

    protected boolean acceptCatchHandlers(ASTVisitor action) {
        return true;
    }

    public void replace(IASTNode child, IASTNode other) {
        if (this.bodyStatement == child) {
            other.setPropertyInParent(this.bodyStatement.getPropertyInParent());
            other.setParent(this.bodyStatement.getParent());
            this.bodyStatement = (IASTStatement)other;
        }
    }
}

