/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.rewrite.astwriter;

import org.eclipse.cdt.core.dom.ast.IASTASMDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTProblemDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCatchHandler;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTConstructorChainInitializer;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTExplicitTemplateInstantiation;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionWithTryBlock;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTLinkageSpecification;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNamespaceAlias;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNamespaceDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTUsingDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTUsingDirective;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTVisibilityLabel;
import org.eclipse.cdt.internal.core.dom.parser.ASTQueries;
import org.eclipse.cdt.internal.core.dom.rewrite.astwriter.ASTWriterVisitor;
import org.eclipse.cdt.internal.core.dom.rewrite.astwriter.NodeWriter;
import org.eclipse.cdt.internal.core.dom.rewrite.astwriter.ProblemRuntimeException;
import org.eclipse.cdt.internal.core.dom.rewrite.astwriter.Scribe;
import org.eclipse.cdt.internal.core.dom.rewrite.commenthandler.NodeCommentMap;

public class DeclarationWriter
extends NodeWriter {
    private static final String ASM_END = ")";
    private static final String ASM_START = "asm(";
    private static final String TEMPLATE_DECLARATION = "template<";
    private static final String EXPORT = "export ";
    private static final String TEMPLATE_SPECIALIZATION = "template <> ";
    private static final String NAMESPACE = "namespace ";
    private static final String USING = "using ";
    private boolean printSemicolon;

    public DeclarationWriter(Scribe scribe, ASTWriterVisitor visitor, NodeCommentMap commentMap) {
        super(scribe, visitor, commentMap);
    }

    protected void writeDeclaration(IASTDeclaration declaration) throws ProblemRuntimeException {
        this.writeDeclaration(declaration, true);
    }

    protected void writeDeclaration(IASTDeclaration declaration, boolean writeSemicolon) {
        boolean addNewLine = true;
        this.printSemicolon = writeSemicolon;
        if (declaration instanceof IASTASMDeclaration) {
            this.writeASMDeclatation((IASTASMDeclaration)declaration);
        } else if (declaration instanceof IASTFunctionDefinition) {
            this.writeFunctionDefinition((IASTFunctionDefinition)declaration);
            addNewLine = false;
        } else {
            if (declaration instanceof IASTProblemDeclaration) {
                throw new ProblemRuntimeException((IASTProblemDeclaration)declaration);
            }
            if (declaration instanceof IASTSimpleDeclaration) {
                this.writeSimpleDeclaration((IASTSimpleDeclaration)declaration);
            } else if (declaration instanceof ICPPASTExplicitTemplateInstantiation) {
                this.writeExplicitTemplateInstantiation((ICPPASTExplicitTemplateInstantiation)declaration);
                addNewLine = false;
            } else if (declaration instanceof ICPPASTLinkageSpecification) {
                this.writeLinkageSpecification((ICPPASTLinkageSpecification)declaration);
            } else if (declaration instanceof ICPPASTNamespaceAlias) {
                this.writeNamespaceAlias((ICPPASTNamespaceAlias)declaration);
            } else if (declaration instanceof ICPPASTTemplateDeclaration) {
                this.writeTemplateDeclaration((ICPPASTTemplateDeclaration)declaration);
                addNewLine = false;
            } else if (declaration instanceof ICPPASTTemplateSpecialization) {
                this.writeTemplateSpecialization((ICPPASTTemplateSpecialization)declaration);
                addNewLine = false;
            } else if (declaration instanceof ICPPASTUsingDeclaration) {
                this.writeUsingDeclaration((ICPPASTUsingDeclaration)declaration);
            } else if (declaration instanceof ICPPASTUsingDirective) {
                this.writeUsingDirective((ICPPASTUsingDirective)declaration);
            } else if (declaration instanceof ICPPASTVisibilityLabel) {
                this.writeVisibilityLabel((ICPPASTVisibilityLabel)declaration);
            }
        }
        if (this.hasTrailingComments(declaration)) {
            this.writeTrailingComments(declaration, false);
        }
        if (addNewLine) {
            this.scribe.newLine();
        }
        if (this.hasFreestandingComments(declaration)) {
            if (declaration instanceof IASTFunctionDefinition) {
                this.scribe.newLine();
            }
            this.writeFreeStandingComments(declaration);
        }
    }

    private void writeVisibilityLabel(ICPPASTVisibilityLabel visiblityLabel) {
        this.scribe.decrementIndentationLevel();
        switch (visiblityLabel.getVisibility()) {
            case 3: {
                this.scribe.print("private");
                this.scribe.print(':');
                break;
            }
            case 2: {
                this.scribe.print("protected");
                this.scribe.print(':');
                break;
            }
            case 1: {
                this.scribe.print("public");
                this.scribe.print(':');
                break;
            }
            default: {
                return;
            }
        }
        this.scribe.incrementIndentationLevel();
    }

    private void writeUsingDirective(ICPPASTUsingDirective usingDirective) {
        this.scribe.print("using namespace ");
        usingDirective.getQualifiedName().accept(this.visitor);
        this.scribe.printSemicolon();
    }

    private void writeUsingDeclaration(ICPPASTUsingDeclaration usingDeclaration) {
        this.scribe.print(USING);
        if (usingDeclaration.isTypename()) {
            this.scribe.print("typename ");
        }
        usingDeclaration.getName().accept(this.visitor);
        this.scribe.printSemicolon();
    }

    private void writeTemplateSpecialization(ICPPASTTemplateSpecialization templateSpecialization) {
        this.scribe.print(TEMPLATE_SPECIALIZATION);
        templateSpecialization.getDeclaration().accept(this.visitor);
    }

    protected void writeTemplateDeclaration(ICPPASTTemplateDeclaration templateDeclaration) {
        if (templateDeclaration.isExported()) {
            this.scribe.print(EXPORT);
        }
        this.scribe.print(TEMPLATE_DECLARATION);
        ICPPASTTemplateParameter[] paraDecls = templateDeclaration.getTemplateParameters();
        int i = 0;
        while (i < paraDecls.length) {
            paraDecls[i].accept(this.visitor);
            if (i + 1 < paraDecls.length) {
                this.scribe.print(',');
                this.scribe.printSpaces(1);
            }
            ++i;
        }
        this.scribe.print('>');
        this.scribe.printSpace();
        templateDeclaration.getDeclaration().accept(this.visitor);
    }

    protected void writeDeclaration(ICPPASTNamespaceDefinition declaration) {
        this.printSemicolon = true;
        this.writeNamespaceDefinition(declaration);
    }

    private void writeNamespaceDefinition(ICPPASTNamespaceDefinition namespaceDefinition) {
        this.scribe.print(NAMESPACE);
        namespaceDefinition.getName().accept(this.visitor);
        if (!this.hasTrailingComments(namespaceDefinition.getName())) {
            this.scribe.newLine();
        }
        this.scribe.print('{');
        this.scribe.newLine(2);
        this.writeDeclarationsInNamespace(namespaceDefinition, namespaceDefinition.getDeclarations());
        if (this.hasFreestandingComments(namespaceDefinition)) {
            this.writeFreeStandingComments(namespaceDefinition);
        }
        this.scribe.newLine();
        this.scribe.print('}');
        if (this.hasTrailingComments(namespaceDefinition)) {
            this.writeTrailingComments(namespaceDefinition);
        } else {
            this.scribe.newLine();
        }
    }

    protected void writeDeclarationsInNamespace(ICPPASTNamespaceDefinition namespaceDefinition, IASTDeclaration[] declarations) {
        IASTDeclaration[] iASTDeclarationArray = declarations;
        int n = declarations.length;
        int n2 = 0;
        while (n2 < n) {
            IASTDeclaration declaration = iASTDeclarationArray[n2];
            declaration.accept(this.visitor);
            ++n2;
        }
    }

    private void writeNamespaceAlias(ICPPASTNamespaceAlias namespaceAliasDefinition) {
        this.scribe.print(NAMESPACE);
        namespaceAliasDefinition.getAlias().accept(this.visitor);
        this.scribe.print(" = ");
        namespaceAliasDefinition.getMappingName().accept(this.visitor);
        this.printSemicolon();
    }

    private void writeLinkageSpecification(ICPPASTLinkageSpecification linkageSpecification) {
        this.scribe.print("extern ");
        this.scribe.print(linkageSpecification.getLiteral());
        this.scribe.printSpaces(1);
        IASTDeclaration[] declarations = linkageSpecification.getDeclarations();
        if (declarations.length > 1) {
            this.scribe.printLBrace();
            this.scribe.decrementIndentationLevel();
            this.scribe.newLine();
            IASTDeclaration[] iASTDeclarationArray = declarations;
            int n = declarations.length;
            int n2 = 0;
            while (n2 < n) {
                IASTDeclaration declaration = iASTDeclarationArray[n2];
                declaration.accept(this.visitor);
                ++n2;
            }
            this.scribe.printRBrace();
            this.scribe.incrementIndentationLevel();
        } else if (declarations.length > 0) {
            this.visitNodeIfNotNull(declarations[0]);
        }
    }

    private void writeExplicitTemplateInstantiation(ICPPASTExplicitTemplateInstantiation explicitTemplateInstantiation) {
        switch (explicitTemplateInstantiation.getModifier()) {
            case 3: {
                this.scribe.print("extern ");
                break;
            }
            case 2: {
                this.scribe.print("inline ");
                break;
            }
            case 1: {
                this.scribe.print("static ");
            }
        }
        this.scribe.print("template ");
        explicitTemplateInstantiation.getDeclaration().accept(this.visitor);
    }

    private void writeASMDeclatation(IASTASMDeclaration asmDeclaration) {
        this.scribe.print(ASM_START);
        this.scribe.print(asmDeclaration.getAssembly());
        this.scribe.print(ASM_END);
        this.printSemicolon();
    }

    private void printSemicolon() {
        if (this.printSemicolon) {
            this.scribe.printSemicolon();
        }
    }

    private void writeFunctionDefinition(IASTFunctionDefinition funcDef) {
        IASTDeclSpecifier declSpecifier = funcDef.getDeclSpecifier();
        declSpecifier.accept(this.visitor);
        if (declSpecifier instanceof IASTSimpleDeclSpecifier) {
            IASTSimpleDeclSpecifier simDeclSpec = (IASTSimpleDeclSpecifier)declSpecifier;
            if (simDeclSpec.getType() != 0) {
                this.visitor.setSpaceNeededBeforeName(true);
            }
        } else {
            this.visitor.setSpaceNeededBeforeName(true);
        }
        IASTDeclarator declarator = ASTQueries.findOutermostDeclarator(funcDef.getDeclarator());
        declarator.accept(this.visitor);
        if (funcDef instanceof ICPPASTFunctionWithTryBlock) {
            this.scribe.newLine();
            this.scribe.print("try");
        }
        if (funcDef instanceof ICPPASTFunctionDefinition) {
            ICPPASTFunctionDefinition cppFuncDef = (ICPPASTFunctionDefinition)funcDef;
            this.writeCtorChainInitializer(cppFuncDef, cppFuncDef.getMemberInitializers());
        }
        this.scribe.newLine();
        funcDef.getBody().accept(this.visitor);
        if (funcDef instanceof ICPPASTFunctionWithTryBlock) {
            ICPPASTCatchHandler[] catches;
            ICPPASTFunctionWithTryBlock tryblock = (ICPPASTFunctionWithTryBlock)funcDef;
            ICPPASTCatchHandler[] iCPPASTCatchHandlerArray = catches = tryblock.getCatchHandlers();
            int n = catches.length;
            int n2 = 0;
            while (n2 < n) {
                ICPPASTCatchHandler handler = iCPPASTCatchHandlerArray[n2];
                handler.accept(this.visitor);
                ++n2;
            }
        }
    }

    protected void writeCtorChainInitializer(ICPPASTFunctionDefinition funcDec, ICPPASTConstructorChainInitializer[] ctorInitChain) {
        if (ctorInitChain.length != 0) {
            this.scribe.newLine();
            this.scribe.print(':');
        }
        int i = 0;
        while (i < ctorInitChain.length) {
            ICPPASTConstructorChainInitializer initializer = ctorInitChain[i];
            initializer.accept(this.visitor);
            if (i + 1 < ctorInitChain.length) {
                this.scribe.print(", ");
            }
            ++i;
        }
    }

    private void writeSimpleDeclaration(IASTSimpleDeclaration simpDec) {
        IASTSimpleDeclSpecifier simpleDeclSpecifier;
        IASTDeclSpecifier declSpecifier = simpDec.getDeclSpecifier();
        IASTNode[] decls = simpDec.getDeclarators();
        declSpecifier.accept(this.visitor);
        boolean noSpace = false;
        if (declSpecifier instanceof IASTSimpleDeclSpecifier && (simpleDeclSpecifier = (IASTSimpleDeclSpecifier)declSpecifier).getType() == 0) {
            noSpace = true;
        }
        if (decls.length > 0) {
            if (decls.length == 1) {
                if (!noSpace) {
                    this.visitor.setSpaceNeededBeforeName(true);
                }
                decls[0].accept(this.visitor);
            } else {
                if (!noSpace) {
                    this.scribe.printSpace();
                }
                this.writeNodeList(decls);
            }
        }
        this.printSemicolon();
    }
}

