/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.rewrite.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;

public class FileContentHelper {
    private static final int BUFFER_SIZE = 2048;

    public static String getContent(IFile file, int start) throws CoreException, IOException {
        InputStreamReader reader = FileContentHelper.getReaderForFile(file);
        FileContentHelper.skip(start, reader);
        String rest = FileContentHelper.readRest(reader);
        reader.close();
        return rest;
    }

    public static String getContent(IFile file, int start, int length) {
        try {
            InputStreamReader r = FileContentHelper.getReaderForFile(file);
            char[] chars = new char[length];
            FileContentHelper.skip(start, r);
            FileContentHelper.read(length, r, chars);
            r.close();
            return new String(chars);
        }
        catch (IOException e) {
            CCorePlugin.log(e);
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
        }
        return "";
    }

    private static InputStreamReader getReaderForFile(IFile file) throws CoreException, UnsupportedEncodingException {
        InputStream contents = file.getContents();
        return new InputStreamReader(contents, file.getCharset());
    }

    private static String readRest(InputStreamReader reader) throws IOException {
        StringBuilder content = new StringBuilder();
        char[] buffer = new char[2048];
        int bytesRead = 0;
        while ((bytesRead = reader.read(buffer)) >= 0) {
            content.append(buffer, 0, bytesRead);
        }
        return content.toString();
    }

    private static void read(int length, InputStreamReader r, char[] bytes) throws IOException {
        int bufferOffset = 0;
        int charactersRead = 0;
        while (charactersRead >= 0 && length > 0) {
            charactersRead = r.read(bytes, bufferOffset, length);
            if (charactersRead <= 0) continue;
            bufferOffset += charactersRead;
            length -= charactersRead;
        }
    }

    private static void skip(int start, InputStreamReader r) throws IOException {
        long skipped = 0L;
        while (skipped >= 0L && start > 0 && r.ready()) {
            skipped = r.skip(start);
            if (skipped <= 0L) continue;
            start = (int)((long)start - skipped);
        }
    }
}

