/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.scanner;

import org.eclipse.cdt.internal.core.parser.scanner.Token;

class TokenList {
    private Token fFirst;
    private Token fLast;

    TokenList() {
    }

    final Token removeFirst() {
        Token first = this.fFirst;
        if (first == this.fLast) {
            this.fLast = null;
            this.fFirst = null;
            return first;
        }
        this.fFirst = (Token)first.getNext();
        return first;
    }

    public final void append(Token t) {
        if (this.fFirst == null) {
            this.fFirst = this.fLast = t;
        } else {
            this.fLast.setNext(t);
            this.fLast = t;
        }
        t.setNext(null);
    }

    public final void appendAll(TokenList tl) {
        Token t = tl.first();
        if (t != null) {
            if (this.fFirst == null) {
                this.fFirst = tl.fFirst;
            } else {
                this.fLast.setNext(tl.fFirst);
            }
            this.fLast = tl.fLast;
        }
        tl.fLast = null;
        tl.fFirst = null;
    }

    public final void appendAllButLast(TokenList tl) {
        Token t = tl.first();
        if (t != null) {
            Token n = (Token)t.getNext();
            while (n != null) {
                this.append(t);
                t = n;
                n = (Token)n.getNext();
            }
        }
    }

    public final void prepend(Token t) {
        Token first = t;
        if (first != null) {
            Token last = t;
            last.setNext(this.fFirst);
            this.fFirst = first;
            if (this.fLast == null) {
                this.fLast = last;
            }
        }
    }

    public final void prepend(TokenList prepend) {
        Token first = prepend.fFirst;
        if (first != null) {
            Token last = prepend.fLast;
            last.setNext(this.fFirst);
            this.fFirst = first;
            if (this.fLast == null) {
                this.fLast = last;
            }
        }
    }

    public final TokenList cloneTokens() {
        TokenList result = new TokenList();
        Token t = this.fFirst;
        while (t != null) {
            if (t.getType() != -198) {
                result.append((Token)t.clone());
            }
            t = (Token)t.getNext();
        }
        return result;
    }

    public final Token first() {
        return this.fFirst;
    }

    public final Token last() {
        return this.fLast;
    }

    final void removeBehind(Token l) {
        if (l == null) {
            Token t = this.fFirst;
            if (t != null) {
                this.fFirst = t = (Token)t.getNext();
                if (t == null) {
                    this.fLast = null;
                }
            }
        } else {
            Token r = (Token)l.getNext();
            if (r != null) {
                l.setNext(r.getNext());
                if (r == this.fLast) {
                    this.fLast = l;
                }
            }
        }
    }

    void cutAfter(Token l) {
        if (l == null) {
            this.fLast = null;
            this.fFirst = null;
        } else {
            l.setNext(null);
            this.fLast = l;
        }
    }

    public void clear() {
        this.fLast = null;
        this.fFirst = null;
    }

    public boolean isEmpty() {
        return this.fFirst == null;
    }
}

