/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.c;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.IParameter;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.index.IIndexFile;
import org.eclipse.cdt.internal.core.index.IIndexFragment;
import org.eclipse.cdt.internal.core.index.IIndexScope;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.dom.IPDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNamedNode;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.core.runtime.CoreException;

final class PDOMCParameter
extends PDOMNamedNode
implements IParameter,
IPDOMBinding {
    private static final int NEXT_PARAM = 12;
    private static final int FLAG_OFFSET = 16;
    public static final int RECORD_SIZE = 17;
    private final IType fType;

    public PDOMCParameter(PDOMLinkage linkage, long record, IType type) {
        super(linkage, record);
        this.fType = type;
    }

    public PDOMCParameter(PDOMLinkage linkage, PDOMNode parent, IParameter param, PDOMCParameter next) throws CoreException {
        super(linkage, parent, param.getNameCharArray());
        this.fType = null;
        Database db = this.getDB();
        db.putRecPtr(this.record + 12L, 0L);
        db.putRecPtr(this.record + 12L, next == null ? 0L : next.getRecord());
        db.putByte(this.record + 16L, this.encodeFlags(param));
    }

    protected int getRecordSize() {
        return 17;
    }

    public int getNodeType() {
        return 13;
    }

    public IType getType() {
        return this.fType;
    }

    public boolean isAuto() {
        byte flag = 1;
        return this.hasFlag(flag, true);
    }

    public boolean isRegister() {
        byte flag = 8;
        return this.hasFlag(flag, false);
    }

    public String getName() {
        return new String(this.getNameCharArray());
    }

    public IIndexScope getScope() {
        return null;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public char[] getNameCharArray() {
        try {
            return super.getNameCharArray();
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return new char[0];
        }
    }

    public IIndexFragment getFragment() {
        return this.getPDOM();
    }

    public boolean hasDefinition() throws CoreException {
        return true;
    }

    public boolean hasDeclaration() throws CoreException {
        return true;
    }

    public String[] getQualifiedName() {
        return new String[]{this.getName()};
    }

    public int getBindingConstant() {
        return this.getNodeType();
    }

    public void delete(PDOMLinkage linkage) throws CoreException {
        PDOMCParameter p = this;
        while (true) {
            long rec = p.getNextPtr();
            p.flatDelete(linkage);
            if (rec == 0L) {
                return;
            }
            p = new PDOMCParameter(linkage, rec, null);
        }
    }

    private void flatDelete(PDOMLinkage linkage) throws CoreException {
        super.delete(linkage);
    }

    public long getNextPtr() throws CoreException {
        long rec = this.getDB().getRecPtr(this.record + 12L);
        return rec;
    }

    public boolean isFileLocal() throws CoreException {
        return false;
    }

    public IIndexFile getLocalToFile() throws CoreException {
        return null;
    }

    public IValue getInitialValue() {
        return null;
    }

    protected byte encodeFlags(IParameter param) {
        byte flags = 0;
        flags = (byte)(flags | (param.isAuto() ? 1 : 0) << 0);
        flags = (byte)(flags | (param.isRegister() ? 1 : 0) << 3);
        return flags;
    }

    protected boolean hasFlag(byte flag, boolean defValue) {
        try {
            byte myflags = this.getDB().getByte(this.record + 16L);
            return (myflags & flag) == flag;
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return defValue;
        }
    }

    public boolean isExtern() {
        return false;
    }

    public boolean isStatic() {
        return false;
    }
}

