/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.ui;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;

public class URLCoder {
    public static String encode(String s) throws UnsupportedEncodingException {
        return URLCoder.urlEncode(s.getBytes("UTF8"));
    }

    public static String decode(String s) throws UnsupportedEncodingException {
        return new String(URLCoder.urlDecode(s), "UTF8");
    }

    private static String urlEncode(byte[] data) {
        StringBuffer buf = new StringBuffer(data.length);
        int i = 0;
        while (i < data.length) {
            buf.append('%');
            buf.append(Character.forDigit((data[i] & 0xF0) >>> 4, 16));
            buf.append(Character.forDigit(data[i] & 0xF, 16));
            ++i;
        }
        return buf.toString();
    }

    private static byte[] urlDecode(String encodedURL) {
        int len = encodedURL.length();
        ByteArrayOutputStream os = new ByteArrayOutputStream(len);
        int i = 0;
        while (i < len) {
            switch (encodedURL.charAt(i)) {
                case '%': {
                    if (len >= i + 3) {
                        os.write(Integer.parseInt(encodedURL.substring(i + 1, i + 3), 16));
                    }
                    i += 3;
                    break;
                }
                case '+': {
                    os.write(32);
                    ++i;
                    break;
                }
                default: {
                    os.write(encodedURL.charAt(i++));
                }
            }
        }
        return os.toByteArray();
    }
}

