/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core.scannerconfig.util;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.internal.core.SafeStringInterner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SymbolEntry {
    private static final String UNSPECIFIED_VALUE = "1";
    private String name;
    private Map<String, Boolean> values;

    public SymbolEntry(String name, String value, boolean active) {
        this.name = SafeStringInterner.safeIntern((String)name);
        if (this.values == null) {
            this.values = new LinkedHashMap<String, Boolean>(1);
        }
        this.values.put(SafeStringInterner.safeIntern((String)value), active);
    }

    public boolean add(String value, boolean active) {
        Boolean old = this.values.put(SafeStringInterner.safeIntern((String)value), active);
        return old == null || old != active;
    }

    public void remove(String value) {
        this.values.remove(value);
    }

    public void removeAll() {
        this.values = null;
    }

    public List<String> getActive() {
        return this.get(true, true, true);
    }

    public List<String> getActiveRaw() {
        return this.get(false, true, true);
    }

    public List<String> getRemoved() {
        return this.get(true, true, false);
    }

    public List<String> getRemovedRaw() {
        return this.get(false, true, false);
    }

    public List<String> getAll() {
        return this.get(true, false, true);
    }

    public List<String> getAllRaw() {
        return this.get(false, false, true);
    }

    private List<String> get(boolean format, boolean subset, boolean active) {
        ArrayList<String> rv = new ArrayList<String>(this.values.size());
        for (String val : this.values.keySet()) {
            if (subset && this.values.get(val) != active) continue;
            if (format) {
                rv.add(String.valueOf(this.name) + "=" + (val == null ? UNSPECIFIED_VALUE : val));
                continue;
            }
            rv.add(String.valueOf(this.name) + (val == null ? "" : "=" + val));
        }
        return rv;
    }

    public List<String> getValuesOnly(boolean active) {
        ArrayList<String> rv = new ArrayList<String>(this.values.size());
        for (String element : this.values.keySet()) {
            String val = element;
            if (this.values.get(val) != active) continue;
            rv.add(val == null ? UNSPECIFIED_VALUE : val);
        }
        return rv;
    }

    public int numberOfValues() {
        return this.values.size();
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(this.name);
        buffer.append(':');
        for (String val : this.values.keySet()) {
            buffer.append('\t');
            buffer.append(val == null ? "null" : val);
            if (this.values.get(val).booleanValue()) {
                buffer.append("(active)");
            }
            buffer.append('\n');
        }
        return SafeStringInterner.safeIntern((String)buffer.toString());
    }
}

