/*************************************************************************/
/* DUCTAPE Version 2.0                                                   */
/* Copyright (C) 2001                                                    */
/* Forschungszentrum Juelich, Zentralinstitut fuer Angewandte Mathematik */
/*************************************************************************/

#ifndef __PDB_GROUP_H__
#define __PDB_GROUP_H__

#ifdef _OLD_HEADER_
# include <vector.h>
#else
# include <vector>
  using std::vector;
#endif
#include "pdbTemplateItem.h"

class pdbGroup : public pdbTemplateItem {
public:
  pdbGroup(int id);
  pdbGroup(const string& name, int id);
  virtual ~pdbGroup();

  virtual const char *desc() const;
  virtual ostream& print(ostream& ostr) const;

  typedef vector<pdbGroupField *> fieldvec;

  const fieldvec& dataMembers() const;
  group_t kind() const;

  void addDataMember(pdbGroupField *field);
  void kind(group_t kd);

protected:
  fieldvec  dmem;
  group_t   knd;
};

#ifndef NO_INLINE
#  include "pdbGroup.inl"
#endif
#endif
