/*************************************************************************/
/* DUCTAPE Version 2.0                                                   */
/* Copyright (C) 2001                                                    */
/* Forschungszentrum Juelich, Zentralinstitut fuer Angewandte Mathematik */
/*************************************************************************/

#ifndef __PDB_NAMESPACE_H__
#define __PDB_NAMESPACE_H__

#include "pdbFatItem.h"

class pdbNamespace : public pdbFatItem {
public:
  pdbNamespace(int id);
  pdbNamespace(const string& name, int id);

  virtual const char *desc() const;
  virtual ostream& print(ostream& ostr) const;
  virtual void adjustPtrs(PDB* p);
  virtual dupl_t findDuplicate(pdbSimpleItem* r);


  typedef vector<pdbItem *> memvec;

  const memvec& members() const;
  const pdbNamespace* isAlias() const;

  void addMember(pdbItem* item);
  void isAlias(const pdbNamespace* n);

private:
  const pdbNamespace *alias;
  memvec              mems;
};

#ifndef NO_INLINE
#  include "pdbNamespace.inl"
#endif
#endif
