/*************************************************************************/
/* DUCTAPE Version 2.0                                                   */
/* Copyright (C) 2001                                                    */
/* Forschungszentrum Juelich, Zentralinstitut fuer Angewandte Mathematik */
/*************************************************************************/

#ifndef __PDB_ROUTINE_H__
#define __PDB_ROUTINE_H__

#include "pdbTemplateItem.h"

class pdbStmt {
public:
  enum stmt_t { ST_NA, ST_SWITCH, ST_CASE, ST_INIT, ST_RETURN, ST_IF,
                ST_EMPTY, ST_FOR, ST_GOTO, ST_CONTINUE, ST_BREAK,
                ST_LABEL, ST_BLOCK, ST_ASM,  ST_EXPR, ST_ASSIGN, ST_THROW,
                ST_WHILE, ST_DO, ST_TRY, ST_CATCH, ST_DECL,
                ST_SET_VLA_SIZE, ST_VLA_DECL, ST_VLA_DEALLOC };

  pdbStmt(int id);

  void kind(stmt_t kind);
  void stmtBegin(const pdbLoc& loc);
  void stmtEnd(const pdbLoc& loc);
  void nextStmt(const pdbStmt* s);
  void downStmt(const pdbStmt* s);   // body, if: then
  void extraStmt(const pdbStmt* s);  // if: else, for: init/decl
                                     // case: break, try: catch
				     // goto, break, continue: target

  int id() const;
  stmt_t kind() const;
  const pdbLoc& stmtBegin() const;
  const pdbLoc& stmtEnd() const;
  const pdbStmt* nextStmt() const;
  const pdbStmt* downStmt() const;
  const pdbStmt* extraStmt() const;

  static const char *toName(stmt_t v);
  static stmt_t toStmt(const char* v);

  friend class pdbRoutine;

private:
  int            i;
  stmt_t         knd;
  pdbLoc         bg;
  pdbLoc         ed;
  const pdbStmt* nxt;
  const pdbStmt* dwn;
  const pdbStmt* ex;
};

ostream& operator<<(ostream& ostr, const pdbStmt& s);

class pdbCallee : public pdbLoc {
public:
  pdbCallee ();
  pdbCallee (const pdbRoutine *call, pdbItem::virt_t v,
             pdbFile *file, int line, int col);
  
  pdbItem::virt_t virtuality() const;
  const pdbRoutine *call() const;
  bool isVirtual() const;

  void virtuality(pdbItem::virt_t v);
  void call(const pdbRoutine* call);

private:
  pdbItem::virt_t virt;
  const pdbRoutine *rptr;
};

ostream& operator<<(ostream& ostr, const pdbCallee& c);

class pdbRoutine : public pdbTemplateItem {
public:
  pdbRoutine(int id);
  pdbRoutine(const string& name, int id);
  virtual ~pdbRoutine();

  virtual ostream& print(ostream& ostr) const;
  virtual const char *desc() const;
  virtual void adjustPtrs(PDB* p);
  virtual dupl_t findDuplicate(pdbSimpleItem* r);

  typedef vector<pdbCallee *> callvec;
  typedef vector<pdbLoc *> locvec;
  typedef vector<pdbStmt *> stmtvec;

  const pdbType *signature() const;
  routine_t kind() const;
  rspec_t specialKind() const;
  callvec& callees();
  const callvec& callees() const;
  int numCalled() const;
  link_t linkage() const;
  const pdbLoc& firstExecStmtLocation() const;
  const locvec& returnLocations() const;
  const pdbStmt* body() const;
  const stmtvec& statements() const;

  void signature(const pdbType *sigtype);
  void kind(routine_t kind);
  void specialKind(rspec_t rs);
  void addCallee(const pdbRoutine *callee, pdbItem::virt_t v,
                 pdbFile *file, int line, int col);
  void linkage(link_t l);
  void firstExecStmtLocation(const pdbLoc& l);
  void addReturnLocation(const pdbFile *file, int line, int col);
  void body(const pdbStmt* b);
  pdbStmt* addStmt(int id);

  virtual void process(PDB *p);

protected:
  void incrCalled() const;

  const pdbType     *sig;
  const pdbStmt     *bdy;
  routine_t          knd;
  rspec_t            rspec;
  link_t             link;
  int                numc;
  callvec            calls;
  locvec             retrns;
  pdbLoc             festmt;
  stmtvec            stmts;
};

#ifndef NO_INLINE
#  include "pdbRoutine.inl"
#endif
#endif
